/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nl.svenar.lib.fasterxml.jackson.annotation.JsonIgnoreProperties;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRUtil;

@JsonIgnoreProperties(value={"disabled"})
public class PRPlayerRank {
    private String name;
    private HashMap<String, Object> tags = new HashMap();
    private boolean disabled = false;

    public PRPlayerRank() {
    }

    public PRPlayerRank(String name) {
        this();
        this.name = name;
    }

    public PRPlayerRank(PRRank rank) {
        this(rank.getName());
    }

    public String getName() {
        return this.name;
    }

    public HashMap<String, Object> getTags() {
        return this.tags;
    }

    public void addTag(String tagName, Object tagValue) {
        if (tagName == null || tagValue == null) {
            return;
        }
        if (tagName.length() == 0) {
            return;
        }
        if (tagName.equalsIgnoreCase("expires")) {
            long currentTimeMillis = System.currentTimeMillis();
            tagValue = PRUtil.timeStringToSecondsConverter(String.valueOf(tagValue));
            tagValue = currentTimeMillis + (long)((Integer)((Object)tagValue) * 1000);
        }
        if (tagName.equalsIgnoreCase("world")) {
            tagName = "worlds";
            ArrayList<String> worlds = new ArrayList<String>();
            if (this.tags.containsKey(tagName)) {
                for (Object world : (List)this.tags.get(tagName)) {
                    if (!(world instanceof String)) continue;
                    worlds.add((String)world);
                }
            }
            worlds.add((String)((Object)tagValue));
            tagValue = worlds;
        }
        this.tags.put(tagName, tagValue);
    }

    public void addTagRaw(String tagName, Object tagValue) {
        if (tagName == null || tagValue == null) {
            return;
        }
        if (tagName.length() == 0) {
            return;
        }
        this.tags.put(tagName, tagValue);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }
}

