/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.structure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import nl.svenar.lib.fasterxml.jackson.annotation.JsonIgnoreProperties;
import nl.svenar.powerranks.common.structure.PRPermission;
import nl.svenar.powerranks.common.structure.PRPlayerRank;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRCache;
import nl.svenar.powerranks.common.utils.PRUtil;

@JsonIgnoreProperties(value={"defaultRanks", "effectivePermissions"})
public class PRPlayer {
    private UUID uuid;
    private String name = "";
    private String nickname = "";
    private Set<PRPlayerRank> ranks = new HashSet<PRPlayerRank>();
    private Set<PRPermission> permissions = new HashSet<PRPermission>();
    private Set<String> usertags = new HashSet<String>();
    private long playtime = 0L;

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Set<PRPlayerRank> getRanks() {
        return this.ranks;
    }

    public List<PRRank> getDefaultRanks() {
        ArrayList<PRRank> defaultRanks = new ArrayList<PRRank>();
        for (PRPlayerRank rank : this.ranks) {
            PRRank prRank = PRCache.getRank(rank.getName());
            if (prRank == null || !prRank.isDefault()) continue;
            defaultRanks.add(prRank);
        }
        return defaultRanks;
    }

    public void setRanks(Set<PRPlayerRank> ranks) {
        this.ranks = ranks;
    }

    public void setRank(PRPlayerRank rank) {
        this.ranks.clear();
        this.ranks.add(rank);
    }

    public void addRank(PRPlayerRank rank) {
        if (!this.ranks.contains(rank)) {
            this.ranks.add(rank);
        }
    }

    public void addRank(PRRank rank) {
        this.addRank(new PRPlayerRank(rank.getName()));
    }

    public void removeRank(PRPlayerRank rank) {
        if (this.ranks.contains(rank)) {
            this.ranks.remove(rank);
        }
    }

    public boolean hasRank(String rankName) {
        for (PRPlayerRank rank : this.ranks) {
            if (!rank.getName().equalsIgnoreCase(rankName)) continue;
            return true;
        }
        return false;
    }

    public Set<PRPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(HashSet<PRPermission> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(PRPermission permission) {
        if (this.permissions == null) {
            this.permissions = new HashSet<PRPermission>();
        }
        this.permissions.add(permission);
    }

    public void removePermission(PRPermission permission) {
        if (!this.permissions.contains(permission)) {
            return;
        }
        this.permissions.remove(permission);
    }

    public void updatePermissionsFromRanks() {
        if (this.permissions == null) {
            this.permissions = new HashSet<PRPermission>();
        } else {
            this.permissions.clear();
        }
        ArrayList<PRRank> playerRanks = new ArrayList<PRRank>();
        for (PRPlayerRank pRPlayerRank : this.getRanks()) {
            PRRank rank;
            if (pRPlayerRank.isDisabled() || (rank = PRCache.getRank(pRPlayerRank.getName())) == null) continue;
            playerRanks.add(rank);
        }
        PRUtil.sortRanksByWeight(playerRanks);
        for (PRRank pRRank : playerRanks) {
            if (!Objects.nonNull(pRRank)) continue;
            for (PRPermission permission : pRRank.getPermissions()) {
                for (PRPermission existingPermission : this.permissions) {
                    if (!permission.getName().equals(existingPermission.getName())) continue;
                    this.permissions.remove(existingPermission);
                    break;
                }
                this.permissions.add(permission);
            }
        }
    }

    public boolean hasPermission(String name, boolean wildcard) {
        PRPermission permission = this.getPermission(name, wildcard);
        return permission != null;
    }

    public boolean isPermissionAllowed(String name, boolean wildcard) {
        PRPermission permission = this.getPermission(name, wildcard);
        if (permission != null) {
            return permission.getValue();
        }
        return false;
    }

    public PRPermission getPermission(String name) {
        return this.getPermission(name, false);
    }

    public PRPermission getPermission(String name, boolean wildcard) {
        if (this.permissions == null) {
            this.permissions = new HashSet<PRPermission>();
        }
        for (PRPermission permission : this.permissions) {
            if (!permission.getName().equals(name)) continue;
            return permission;
        }
        if (wildcard) {
            ArrayList<String> wildcardPermissions = PRUtil.generateWildcardList(name);
            for (PRPermission permission : this.permissions) {
                if (!wildcardPermissions.contains(permission.getName())) continue;
                return permission;
            }
        }
        return null;
    }

    public List<PRPermission> getEffectivePermissions() {
        ArrayList<PRPermission> permissions = new ArrayList<PRPermission>();
        permissions.addAll(this.getPermissions());
        ArrayList<PRRank> playerRanks = new ArrayList<PRRank>();
        for (PRPlayerRank playerRank : this.getRanks()) {
            PRRank rank;
            if (playerRank.isDisabled() || (rank = PRCache.getRank(playerRank.getName())) == null) continue;
            playerRanks.add(rank);
        }
        ArrayList<PRRank> effectiveRanks = new ArrayList<PRRank>();
        if (Objects.nonNull(playerRanks)) {
            effectiveRanks.addAll(playerRanks);
            for (PRRank playerRank : playerRanks) {
                for (String inheritance : playerRank.getInheritances()) {
                    PRRank inheritanceRank = PRCache.getRank(inheritance);
                    if (inheritanceRank == null) continue;
                    effectiveRanks.add(inheritanceRank);
                }
            }
        }
        effectiveRanks.removeIf(Objects::isNull);
        PRUtil.sortRanksByWeight(effectiveRanks);
        for (PRRank effectiveRank : effectiveRanks) {
            if (!Objects.nonNull(effectiveRank)) continue;
            for (PRPermission permission : effectiveRank.getPermissions()) {
                PRPermission permissionToRemove = null;
                for (PRPermission existingPermission : permissions) {
                    if (!permission.getName().equals(existingPermission.getName())) continue;
                    permissionToRemove = existingPermission;
                    break;
                }
                if (Objects.nonNull(permissionToRemove)) {
                    permissions.remove(permissionToRemove);
                }
                permissions.add(permission);
            }
        }
        return permissions;
    }

    public long getPlaytime() {
        return this.playtime;
    }

    public void setPlaytime(long playtime) {
        this.playtime = playtime;
    }

    public Set<String> getUsertags() {
        return this.usertags;
    }

    public void setUsertags(Set<String> usertags) {
        this.usertags = usertags;
    }

    public void setUsertag(String usertag) {
        this.usertags = new HashSet<String>();
        this.usertags.add(usertag);
    }

    public void addUsertag(String usertag) {
        if (Objects.isNull(this.usertags)) {
            this.usertags = new HashSet<String>();
        }
        if (!this.usertags.contains(usertag)) {
            this.usertags.add(usertag);
        }
    }

    public void removeUsertag(String usertag) {
        if (!this.usertags.contains(usertag)) {
            return;
        }
        this.usertags.remove(usertag);
    }

    public boolean hasUsertag(String usertag) {
        if (Objects.isNull(this.usertags)) {
            this.usertags = new HashSet<String>();
        }
        for (String tag : this.usertags) {
            if (!tag.equals(usertag)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var4_7;
        String output = "uuid:" + this.uuid.toString() + ", name:" + this.name + ", ranks:[<<RANKS>>], permissions:[<<PERMISSIONS>>], usertags:[<<USERTAGS>>]";
        String ranks = "";
        for (PRPlayerRank pRPlayerRank : this.getRanks()) {
            ranks = ranks + pRPlayerRank.getName() + " (";
            for (Map.Entry<String, Object> entry : pRPlayerRank.getTags().entrySet()) {
                ranks = ranks + entry.getKey() + "=" + entry.getValue() + ",";
            }
            ranks = pRPlayerRank.getTags().size() > 0 ? ranks.substring(0, ranks.length() - 1) : "";
            ranks = ranks + ");";
        }
        ranks = ranks.length() > 0 ? ranks.substring(0, ranks.length() - 1) : "";
        String permissions = "";
        for (PRPermission permission : this.getPermissions()) {
            permissions = permissions + permission.toString() + ";";
        }
        permissions = permissions.length() > 0 ? permissions.substring(0, permissions.length() - 1) : "";
        String string = "";
        for (String usertag : this.getUsertags()) {
            String string2 = (String)var4_7 + usertag + ";";
        }
        String string3 = var4_7.length() > 0 ? var4_7.substring(0, var4_7.length() - 1) : "";
        output = output.replaceAll("<<RANKS>>", ranks);
        output = output.replaceAll("<<PERMISSIONS>>", permissions);
        output = output.replaceAll("<<USERTAGS>>", string3);
        return output;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.toString().hashCode();
        return result;
    }

    public void updateTags(String worldName) {
        for (PRPlayerRank prPlayerRank : this.getRanks()) {
            if (!prPlayerRank.getTags().containsKey("worlds")) continue;
            boolean playerInWorld = false;
            for (Object worldObject : (List)prPlayerRank.getTags().get("worlds")) {
                String world;
                if (!(worldObject instanceof String) || !(world = (String)worldObject).equalsIgnoreCase(worldName)) continue;
                playerInWorld = true;
                break;
            }
            prPlayerRank.setDisabled(!playerInWorld);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PRPlayer)) {
            return false;
        }
        PRPlayer prPlayer = (PRPlayer)obj;
        return this.getUUID().equals(prPlayer.getUUID());
    }
}

