/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.storage.provided;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import nl.svenar.lib.yaml.snakeyaml.DumperOptions;
import nl.svenar.lib.yaml.snakeyaml.LoaderOptions;
import nl.svenar.lib.yaml.snakeyaml.Yaml;
import nl.svenar.lib.yaml.snakeyaml.constructor.BaseConstructor;
import nl.svenar.lib.yaml.snakeyaml.constructor.Constructor;
import nl.svenar.lib.yaml.snakeyaml.representer.Representer;
import nl.svenar.powerranks.common.storage.PowerStorageManager;
import nl.svenar.powerranks.common.structure.PRPlayer;
import nl.svenar.powerranks.common.structure.PRRank;

public class YAMLStorageManager
extends PowerStorageManager {
    private final DumperOptions yamlOptions = new DumperOptions();
    private final LoaderOptions loaderOptions = new LoaderOptions();
    private final Representer yamlRepresenter = new Representer(this.yamlOptions);
    private final Yaml yaml = new Yaml((BaseConstructor)new Constructor(this.loaderOptions), this.yamlRepresenter, this.yamlOptions, this.loaderOptions);
    private File ranksFile;
    private File playersFile;

    public YAMLStorageManager(String directory, String ranksFileName, String playersFileName) {
        File targetDir = new File(directory);
        this.ranksFile = new File(targetDir, ranksFileName);
        this.playersFile = new File(targetDir, playersFileName);
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        if (!this.ranksFile.exists()) {
            try {
                this.ranksFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.playersFile.exists()) {
            try {
                this.playersFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loadRanks();
        this.loadPlayers();
    }

    @Override
    public String getType() {
        return "YAML";
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void loadRanks() {
        boolean success = true;
        FileInputStream inputStream2 = null;
        this.setRanks(new ArrayList<PRRank>());
        try {
            inputStream2 = new FileInputStream(this.ranksFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (Objects.nonNull(inputStream2)) {
            Object obj = this.yaml.load(inputStream2);
            if (Objects.nonNull(obj)) {
                if (obj instanceof LinkedHashMap) {
                    for (Map.Entry entry : ((LinkedHashMap)obj).entrySet()) {
                        if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof LinkedHashMap)) continue;
                        String rankName = (String)entry.getKey();
                        Map rankData = (Map)entry.getValue();
                        rankData.put("name", rankName);
                        PRRank rank = this.getSerializer().deserialize(rankData, PRRank.class);
                        this.addRank(rank);
                    }
                } else {
                    success = false;
                }
            } else {
                success = false;
            }
        } else {
            success = false;
        }
        if (!success) {
            this.setRanks(new ArrayList<PRRank>());
        }
    }

    @Override
    public void loadPlayers() {
        boolean success = true;
        FileInputStream inputStream2 = null;
        this.setPlayers(new ArrayList<PRPlayer>());
        try {
            inputStream2 = new FileInputStream(this.playersFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (Objects.nonNull(inputStream2)) {
            Object obj = this.yaml.load(inputStream2);
            if (Objects.nonNull(obj)) {
                if (obj instanceof LinkedHashMap) {
                    for (Map.Entry entry : ((LinkedHashMap)obj).entrySet()) {
                        if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof LinkedHashMap)) continue;
                        String playerUUID = (String)entry.getKey();
                        Map playerData = (Map)entry.getValue();
                        playerData.put("uuid", playerUUID);
                        PRPlayer player = this.getSerializer().deserialize(playerData, PRPlayer.class);
                        this.addPlayer(player);
                    }
                } else {
                    success = false;
                }
            } else {
                success = false;
            }
        } else {
            success = false;
        }
        if (!success) {
            this.setPlayers(new ArrayList<PRPlayer>());
        }
    }

    @Override
    public void saveRanks() {
        this.yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        try {
            PrintWriter writer = new PrintWriter(this.ranksFile);
            HashMap<String, Map<String, Object>> ranks2 = new HashMap<String, Map<String, Object>>();
            for (PRRank r : this.getRanks()) {
                Map<String, Object> serializedRank = this.getSerializer().serialize(r);
                for (Map.Entry<String, Object> entry : serializedRank.entrySet()) {
                    if (!entry.getValue().equals(r.getName())) continue;
                    serializedRank.remove(entry.getKey());
                    break;
                }
                ranks2.put(r.getName(), serializedRank);
            }
            this.yaml.dump(ranks2, writer);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void savePlayers() {
        this.yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        try {
            PrintWriter writer = new PrintWriter(this.playersFile);
            HashMap<String, Map<String, Object>> players2 = new HashMap<String, Map<String, Object>>();
            for (PRPlayer p : this.getPlayers()) {
                Map<String, Object> serializedPlayer = this.getSerializer().serialize(p);
                for (Map.Entry<String, Object> entry : serializedPlayer.entrySet()) {
                    if (!entry.getValue().equals(p.getUUID().toString())) continue;
                    serializedPlayer.remove(entry.getKey());
                    break;
                }
                players2.put(p.getUUID().toString(), serializedPlayer);
            }
            this.yaml.dump(players2, writer);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveRank(PRRank rank) {
        this.addRank(rank);
        this.saveRanks();
    }

    @Override
    public void savePlayer(PRPlayer player) {
        this.addPlayer(player);
        this.savePlayers();
    }

    @Override
    public void removeAllData() {
        this.ranksFile.delete();
        this.playersFile.delete();
    }
}

