/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.storage.provided;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import nl.svenar.lib.yaml.snakeyaml.DumperOptions;
import nl.svenar.lib.yaml.snakeyaml.LoaderOptions;
import nl.svenar.lib.yaml.snakeyaml.Yaml;
import nl.svenar.lib.yaml.snakeyaml.constructor.BaseConstructor;
import nl.svenar.lib.yaml.snakeyaml.constructor.Constructor;
import nl.svenar.lib.yaml.snakeyaml.representer.Representer;
import nl.svenar.powerranks.common.storage.PowerConfigManager;

public class YAMLConfigManager
extends PowerConfigManager {
    private final DumperOptions yamlOptions = new DumperOptions();
    private final LoaderOptions loaderOptions = new LoaderOptions();
    private final Representer yamlRepresenter = new Representer(this.yamlOptions);
    private final Yaml yaml = new Yaml((BaseConstructor)new Constructor(this.loaderOptions), this.yamlRepresenter, this.yamlOptions, this.loaderOptions);
    private File configFile;

    public YAMLConfigManager(String directory, String filename) {
        try {
            File configDir = new File(directory);
            this.configFile = new File(configDir, filename);
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            if (!this.configFile.exists()) {
                this.configFile.createNewFile();
                this.hasCreatedFile = true;
            }
            this.reload();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public YAMLConfigManager(String directory, String filename, String defaults) {
        try {
            File configDir = new File(directory);
            this.configFile = new File(configDir, filename);
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            if (!this.configFile.exists()) {
                InputStream inputStream2 = this.getClass().getResourceAsStream(defaults.startsWith("/") ? defaults : "/" + defaults);
                this.copyFile(inputStream2, this.configFile);
            }
            this.reload();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void save() {
        try {
            this.yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            PrintWriter writer = new PrintWriter(this.configFile);
            this.yaml.dump(this.data, writer);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reload() {
        try {
            FileInputStream inputStream2 = new FileInputStream(this.configFile);
            this.data = (Map)this.yaml.load(inputStream2);
            if (this.data == null) {
                this.data = new HashMap();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean destroyFile() {
        return this.configFile.delete();
    }
}

