/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.storage.provided;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import nl.svenar.powerranks.common.storage.PowerStorageManager;
import nl.svenar.powerranks.common.structure.PRPlayer;
import nl.svenar.powerranks.common.structure.PRRank;

public class SQLiteStorageManager
extends PowerStorageManager {
    private File ranksFile;
    private File playersFile;
    private Connection ranksSQLConnection;
    private Connection playersSQLConnection;

    public SQLiteStorageManager(String directory, String ranksFileName, String playersFileName) {
        File targetDir = new File(directory);
        this.ranksFile = new File(targetDir, ranksFileName);
        this.playersFile = new File(targetDir, playersFileName);
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        if (!this.ranksFile.exists()) {
            try {
                this.ranksFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.playersFile.exists()) {
            try {
                this.playersFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.setupTables();
        try {
            this.loadRanks();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadPlayers();
    }

    @Override
    public String getType() {
        return "SQLITE";
    }

    @Override
    public boolean isConnected() {
        try {
            if (Objects.isNull(this.ranksSQLConnection) || Objects.isNull(this.ranksSQLConnection)) {
                return false;
            }
            return !this.ranksSQLConnection.isClosed() && !this.playersSQLConnection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public void close() {
        try {
            this.ranksSQLConnection.close();
            this.playersSQLConnection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void setupTables() {
        this.setupTableRanks();
        this.setupTablePlayers();
    }

    private void setupTableRanks() {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            this.ranksSQLConnection = DriverManager.getConnection("jdbc:sqlite:" + this.ranksFile);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (Objects.nonNull(this.ranksSQLConnection)) {
            String query = this.SQLCreateTable(this.ranksFile.getName().split("\\.")[0]);
            try {
                int result = this.ranksSQLConnection.createStatement().executeUpdate(query);
                this.checkSQLResult(result, query);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void setupTablePlayers() {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            this.playersSQLConnection = DriverManager.getConnection("jdbc:sqlite:" + this.playersFile);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (Objects.nonNull(this.playersSQLConnection)) {
            String query = this.SQLCreateTable(this.playersFile.getName().split("\\.")[0]);
            try {
                int result = this.playersSQLConnection.createStatement().executeUpdate(query);
                this.checkSQLResult(result, query);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void loadRanks() {
        Gson gson = new Gson();
        boolean success = false;
        this.setRanks(new ArrayList<PRRank>());
        HashMap<String, Object> rawDBData = new HashMap<String, Object>();
        try {
            String query = this.SQLSelectAllInTable(this.ranksFile.getName().split("\\.")[0]);
            Statement st = this.ranksSQLConnection.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                String key = rs.getString("keyname");
                String rawValue = rs.getString("val");
                Type mapType = new TypeToken<Object>(){}.getType();
                Object data = gson.fromJson(rawValue, mapType);
                rawDBData.put(key, data);
            }
        }
        catch (SQLException e) {
            success = false;
            e.printStackTrace();
        }
        HashMap rawRanksData = new HashMap();
        for (Map.Entry entry : rawDBData.entrySet()) {
            Map updatedData;
            String rankName = ((String)entry.getKey()).split("\\.")[0];
            if (!rawRanksData.containsKey(rankName)) {
                updatedData = new HashMap<String, String>();
                updatedData.put("name", rankName);
                rawRanksData.put(rankName, updatedData);
            }
            updatedData = (Map)rawRanksData.get(rankName);
            if (((String)entry.getKey()).split("\\.").length > 2) {
                String key = String.join((CharSequence)".", Arrays.copyOfRange(((String)entry.getKey()).split("\\."), 2, ((String)entry.getKey()).split("\\.").length));
                String propertyKey = ((String)entry.getKey()).split("\\.")[1];
                if (!((Map)rawRanksData.get(rankName)).containsKey(propertyKey)) {
                    HashMap newMap = new HashMap();
                    ((Map)rawRanksData.get(rankName)).put(propertyKey, newMap);
                }
                Map dataMap = (Map)((Map)rawRanksData.get(rankName)).get(propertyKey);
                dataMap.put(key, entry.getValue());
                ((Map)rawRanksData.get(rankName)).put(propertyKey, dataMap);
                continue;
            }
            updatedData.put(((String)entry.getKey()).split("\\.")[1], entry.getValue());
            rawRanksData.put(rankName, updatedData);
        }
        for (Map.Entry entry : rawRanksData.entrySet()) {
            PRRank rank = this.getSerializer().deserialize((Map)entry.getValue(), PRRank.class);
            if (!Objects.nonNull(rank)) continue;
            this.addRank(rank);
            success = true;
        }
        if (!success) {
            this.setRanks(new ArrayList<PRRank>());
        }
    }

    @Override
    public void loadPlayers() {
        Gson gson = new Gson();
        boolean success = false;
        this.setPlayers(new ArrayList<PRPlayer>());
        HashMap<String, Object> rawDBData = new HashMap<String, Object>();
        try {
            String query = this.SQLSelectAllInTable(this.playersFile.getName().split("\\.")[0]);
            Statement st = this.playersSQLConnection.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                String key = rs.getString("keyname");
                String rawValue = rs.getString("val");
                Type mapType = new TypeToken<Object>(){}.getType();
                Object data = gson.fromJson(rawValue, mapType);
                rawDBData.put(key, data);
            }
        }
        catch (SQLException e) {
            success = false;
            e.printStackTrace();
        }
        HashMap rawPlayersData = new HashMap();
        for (Map.Entry entry : rawDBData.entrySet()) {
            Map updatedData;
            String playerUUID = ((String)entry.getKey()).split("\\.")[0];
            if (!rawPlayersData.containsKey(playerUUID)) {
                updatedData = new HashMap<String, String>();
                updatedData.put("uuid", playerUUID);
                rawPlayersData.put(playerUUID, updatedData);
            }
            updatedData = (Map)rawPlayersData.get(playerUUID);
            if (((String)entry.getKey()).split("\\.").length > 2) {
                String key = String.join((CharSequence)".", Arrays.copyOfRange(((String)entry.getKey()).split("\\."), 2, ((String)entry.getKey()).split("\\.").length));
                String propertyKey = ((String)entry.getKey()).split("\\.")[1];
                if (!((Map)rawPlayersData.get(playerUUID)).containsKey(propertyKey)) {
                    HashMap newMap = new HashMap();
                    ((Map)rawPlayersData.get(playerUUID)).put(propertyKey, newMap);
                }
                Map dataMap = (Map)((Map)rawPlayersData.get(playerUUID)).get(propertyKey);
                dataMap.put(key, entry.getValue());
                ((Map)rawPlayersData.get(playerUUID)).put(propertyKey, dataMap);
                continue;
            }
            updatedData.put(((String)entry.getKey()).split("\\.")[1], entry.getValue());
            rawPlayersData.put(playerUUID, updatedData);
        }
        for (Map.Entry entry : rawPlayersData.entrySet()) {
            PRPlayer player = this.getSerializer().deserialize((Map)entry.getValue(), PRPlayer.class);
            if (!Objects.nonNull(player)) continue;
            this.addPlayer(player);
            success = true;
        }
        if (!success) {
            this.setPlayers(new ArrayList<PRPlayer>());
        }
    }

    @Override
    public void saveRanks() {
        Gson gson = new Gson();
        try {
            String query = this.SQLDeleteAllInTable(this.ranksFile.getName().split("\\.")[0]);
            int result = this.ranksSQLConnection.createStatement().executeUpdate(query);
            this.checkSQLResult(result, query);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        PreparedStatement stmt = null;
        try {
            this.ranksSQLConnection.setAutoCommit(false);
            stmt = this.ranksSQLConnection.prepareStatement(this.SQLInsertOrUpdateKV(this.ranksFile.getName().split("\\.")[0]));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        HashMap<String, Map<String, Object>> ranks2 = new HashMap<String, Map<String, Object>>();
        for (PRRank pRRank : this.getRanks()) {
            Map<String, Object> serializedRank = this.getSerializer().serialize(pRRank);
            for (Map.Entry<String, Object> entry : serializedRank.entrySet()) {
                if (!entry.getValue().equals(pRRank.getName())) continue;
                serializedRank.remove(entry.getKey());
                break;
            }
            ranks2.put(pRRank.getName(), serializedRank);
        }
        for (Map.Entry entry : ranks2.entrySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.iterate(map, (LinkedHashMap)entry.getValue(), "");
            for (Map.Entry<String, Object> entry2 : map.entrySet()) {
                String dbKey = (String)entry.getKey() + "." + entry2.getKey();
                String serializedValue = gson.toJson(entry2.getValue());
                try {
                    if (stmt == null) continue;
                    stmt.clearParameters();
                    stmt.setString(1, dbKey);
                    stmt.setString(2, serializedValue);
                    stmt.setString(3, serializedValue);
                    stmt.addBatch();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            if (stmt != null) {
                stmt.executeBatch();
                this.ranksSQLConnection.commit();
                this.ranksSQLConnection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void savePlayers() {
        Gson gson = new Gson();
        PreparedStatement stmt = null;
        try {
            this.playersSQLConnection.setAutoCommit(false);
            stmt = this.playersSQLConnection.prepareStatement(this.SQLInsertOrUpdateKV(this.playersFile.getName().split("\\.")[0]));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            String query = this.SQLDeleteAllInTable(this.playersFile.getName().split("\\.")[0]);
            int result = this.playersSQLConnection.createStatement().executeUpdate(query);
            this.checkSQLResult(result, query);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        HashMap<String, Map<String, Object>> players2 = new HashMap<String, Map<String, Object>>();
        for (PRPlayer pRPlayer : this.getPlayers()) {
            Map<String, Object> serializedPlayer = this.getSerializer().serialize(pRPlayer);
            for (Map.Entry<String, Object> entry : serializedPlayer.entrySet()) {
                if (!entry.getValue().equals(pRPlayer.getUUID().toString())) continue;
                serializedPlayer.remove(entry.getKey());
                break;
            }
            players2.put(pRPlayer.getUUID().toString(), serializedPlayer);
        }
        for (Map.Entry entry : players2.entrySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.iterate(map, (LinkedHashMap)entry.getValue(), "");
            for (Map.Entry<String, Object> entry2 : map.entrySet()) {
                String dbKey = (String)entry.getKey() + "." + entry2.getKey();
                String serializedValue = gson.toJson(entry2.getValue());
                try {
                    if (stmt == null) continue;
                    stmt.clearParameters();
                    stmt.setString(1, dbKey);
                    stmt.setString(2, serializedValue);
                    stmt.setString(3, serializedValue);
                    stmt.addBatch();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            if (stmt != null) {
                stmt.executeBatch();
                this.playersSQLConnection.commit();
                this.playersSQLConnection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveRank(PRRank rank) {
        this.addRank(rank);
        this.saveRanks();
    }

    @Override
    public void savePlayer(PRPlayer player) {
        this.addPlayer(player);
        this.savePlayers();
    }

    private String SQLCreateTable(String tableName) {
        return "CREATE TABLE IF NOT EXISTS `" + tableName + "` (`keyname` VARCHAR(256) NOT NULL UNIQUE, `val` LONGTEXT NOT NULL , UNIQUE(`keyname`));";
    }

    private String SQLInsertOrUpdateKV(String tableName) {
        return "INSERT INTO `" + tableName + "` (keyname, val) VALUES (?, ?) ON CONFLICT(keyname) DO UPDATE SET val=?;";
    }

    private String SQLSelectAllInTable(String tableName) {
        return "SELECT * FROM `" + tableName + "`;";
    }

    private String SQLDeleteAllInTable(String tableName) {
        return "DELETE FROM `" + tableName + "`;";
    }

    private void checkSQLResult(int result, String query) throws SQLException {
        if (result < 0) {
            throw new SQLException("Failed to execute SQL query (" + query + ")");
        }
    }

    @Override
    public void removeAllData() {
        this.ranksFile.delete();
        this.playersFile.delete();
    }
}

