/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.storage.provided;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import nl.svenar.powerranks.common.storage.PowerStorageManager;
import nl.svenar.powerranks.common.structure.PRPlayer;
import nl.svenar.powerranks.common.structure.PRRank;

public class PSMStorageManager
extends PowerStorageManager {
    private File ranksFile;
    private File playersFile;

    public PSMStorageManager(String directory, String ranksFileName, String playersFileName) {
        File targetDir = new File(directory);
        this.ranksFile = new File(targetDir, ranksFileName);
        this.playersFile = new File(targetDir, playersFileName);
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        if (!this.ranksFile.exists()) {
            try {
                this.ranksFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.playersFile.exists()) {
            try {
                this.playersFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loadRanks();
        this.loadPlayers();
    }

    @Override
    public String getType() {
        return "PSM";
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void loadRanks() {
        Gson gson = new Gson();
        boolean success = false;
        this.setRanks(new ArrayList<PRRank>());
        HashMap<String, Object> rawDBData = new HashMap<String, Object>();
        Type mapType = new TypeToken<Object>(){}.getType();
        try (BufferedReader br = new BufferedReader(new FileReader(this.ranksFile));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] lineSplit = line.split("=");
                rawDBData.put(lineSplit[0], gson.fromJson(lineSplit[1], mapType));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashMap rawRanksData = new HashMap();
        for (Map.Entry entry : rawDBData.entrySet()) {
            Map updatedData;
            String rankName = ((String)entry.getKey()).split("\\.")[0];
            if (!rawRanksData.containsKey(rankName)) {
                updatedData = new HashMap<String, String>();
                updatedData.put("name", rankName);
                rawRanksData.put(rankName, updatedData);
            }
            updatedData = (Map)rawRanksData.get(rankName);
            if (((String)entry.getKey()).split("\\.").length > 2) {
                String key = String.join((CharSequence)".", Arrays.copyOfRange(((String)entry.getKey()).split("\\."), 2, ((String)entry.getKey()).split("\\.").length));
                String propertyKey = ((String)entry.getKey()).split("\\.")[1];
                if (!((Map)rawRanksData.get(rankName)).containsKey(propertyKey)) {
                    HashMap newMap = new HashMap();
                    ((Map)rawRanksData.get(rankName)).put(propertyKey, newMap);
                }
                Map dataMap = (Map)((Map)rawRanksData.get(rankName)).get(propertyKey);
                dataMap.put(key, entry.getValue());
                ((Map)rawRanksData.get(rankName)).put(propertyKey, dataMap);
                continue;
            }
            updatedData.put(((String)entry.getKey()).split("\\.")[1], entry.getValue());
            rawRanksData.put(rankName, updatedData);
        }
        for (Map.Entry entry : rawRanksData.entrySet()) {
            PRRank rank = this.getSerializer().deserialize((Map)entry.getValue(), PRRank.class);
            if (!Objects.nonNull(rank)) continue;
            this.addRank(rank);
            success = true;
        }
        if (!success) {
            this.setRanks(new ArrayList<PRRank>());
        }
    }

    @Override
    public void loadPlayers() {
        Gson gson = new Gson();
        boolean success = false;
        this.setPlayers(new ArrayList<PRPlayer>());
        HashMap<String, Object> rawDBData = new HashMap<String, Object>();
        Type mapType = new TypeToken<Object>(){}.getType();
        try (BufferedReader br = new BufferedReader(new FileReader(this.playersFile));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] lineSplit = line.split("=");
                rawDBData.put(lineSplit[0], gson.fromJson(lineSplit[1], mapType));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashMap rawPlayersData = new HashMap();
        for (Map.Entry entry : rawDBData.entrySet()) {
            Map updatedData;
            String playerUUID = ((String)entry.getKey()).split("\\.")[0];
            if (!rawPlayersData.containsKey(playerUUID)) {
                updatedData = new HashMap<String, String>();
                updatedData.put("uuid", playerUUID);
                rawPlayersData.put(playerUUID, updatedData);
            }
            updatedData = (Map)rawPlayersData.get(playerUUID);
            if (((String)entry.getKey()).split("\\.").length > 2) {
                String key = String.join((CharSequence)".", Arrays.copyOfRange(((String)entry.getKey()).split("\\."), 2, ((String)entry.getKey()).split("\\.").length));
                String propertyKey = ((String)entry.getKey()).split("\\.")[1];
                if (!((Map)rawPlayersData.get(playerUUID)).containsKey(propertyKey)) {
                    HashMap newMap = new HashMap();
                    ((Map)rawPlayersData.get(playerUUID)).put(propertyKey, newMap);
                }
                Map dataMap = (Map)((Map)rawPlayersData.get(playerUUID)).get(propertyKey);
                dataMap.put(key, entry.getValue());
                ((Map)rawPlayersData.get(playerUUID)).put(propertyKey, dataMap);
                continue;
            }
            updatedData.put(((String)entry.getKey()).split("\\.")[1], entry.getValue());
            rawPlayersData.put(playerUUID, updatedData);
        }
        for (Map.Entry entry : rawPlayersData.entrySet()) {
            PRPlayer player = this.getSerializer().deserialize((Map)entry.getValue(), PRPlayer.class);
            if (!Objects.nonNull(player)) continue;
            this.addPlayer(player);
            success = true;
        }
        if (!success) {
            this.setPlayers(new ArrayList<PRPlayer>());
        }
    }

    @Override
    public void saveRanks() {
        Gson gson = new Gson();
        String buffer = "";
        HashMap<String, Map<String, Object>> ranks2 = new HashMap<String, Map<String, Object>>();
        for (PRRank r : this.getRanks()) {
            Map<String, Object> serializedRank = this.getSerializer().serialize(r);
            for (Map.Entry<String, Object> entry : serializedRank.entrySet()) {
                if (!entry.getValue().equals(r.getName())) continue;
                serializedRank.remove(entry.getKey());
                break;
            }
            ranks2.put(r.getName(), serializedRank);
        }
        try {
            FileWriter fw = new FileWriter(this.ranksFile.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            for (Map.Entry entry : ranks2.entrySet()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                this.iterate(map, (LinkedHashMap)entry.getValue(), "");
                for (Map.Entry mapEntry : map.entrySet()) {
                    String dbKey = (String)entry.getKey() + "." + (String)mapEntry.getKey();
                    String serializedValue = gson.toJson(mapEntry.getValue());
                    buffer = dbKey;
                    buffer = buffer + "=";
                    buffer = buffer + serializedValue;
                    buffer = buffer + "\n";
                    bw.write(buffer);
                }
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void savePlayers() {
        Gson gson = new Gson();
        String buffer = "";
        HashMap<String, Map<String, Object>> players2 = new HashMap<String, Map<String, Object>>();
        for (PRPlayer p : this.getPlayers()) {
            Map<String, Object> serializedPlayer = this.getSerializer().serialize(p);
            for (Map.Entry<String, Object> entry : serializedPlayer.entrySet()) {
                if (!entry.getValue().equals(p.getUUID().toString())) continue;
                serializedPlayer.remove(entry.getKey());
                break;
            }
            players2.put(p.getUUID().toString(), serializedPlayer);
        }
        try {
            FileWriter fw = new FileWriter(this.playersFile.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            for (Map.Entry entry : players2.entrySet()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                this.iterate(map, (LinkedHashMap)entry.getValue(), "");
                for (Map.Entry mapEntry : map.entrySet()) {
                    String dbKey = (String)entry.getKey() + "." + (String)mapEntry.getKey();
                    String serializedValue = gson.toJson(mapEntry.getValue());
                    buffer = dbKey;
                    buffer = buffer + "=";
                    buffer = buffer + serializedValue;
                    buffer = buffer + "\n";
                    bw.write(buffer);
                }
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveRank(PRRank rank) {
        this.addRank(rank);
        this.saveRanks();
    }

    @Override
    public void savePlayer(PRPlayer player) {
        this.addPlayer(player);
        this.savePlayers();
    }

    @Override
    public void removeAllData() {
        this.ranksFile.delete();
        this.playersFile.delete();
    }
}

