/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.storage.provided;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import nl.svenar.powerranks.common.storage.PowerSQLConfiguration;
import nl.svenar.powerranks.common.storage.PowerStorageManager;
import nl.svenar.powerranks.common.structure.PRPlayer;
import nl.svenar.powerranks.common.structure.PRRank;

public class MySQLStorageManager
extends PowerStorageManager {
    private Connection connection;
    private PowerSQLConfiguration sqlConfig;

    public MySQLStorageManager(PowerSQLConfiguration sqlConfig) {
        block5: {
            this.sqlConfig = sqlConfig;
            try {
                Class.forName("com.mysql.cj.jdbc.Driver");
            }
            catch (ClassNotFoundException e) {
                try {
                    Class.forName("com.mysql.jdbc.Driver");
                }
                catch (ClassNotFoundException ex) {
                    if (sqlConfig.silentErrors()) break block5;
                    ex.printStackTrace();
                }
            }
        }
        this.reconnect();
        if (this.isConnected()) {
            this.setupDatabase();
            this.setupTables();
        }
    }

    private void reconnect() {
        block2: {
            try {
                this.connection = DriverManager.getConnection("jdbc:mysql://" + this.sqlConfig.getHost() + ":" + this.sqlConfig.getPort() + "?autoReconnect=true&useSSL=" + (this.sqlConfig.isUsingSSL() ? "true" : "false") + "&rewriteBatchedStatements=true", this.sqlConfig.getUsername(), this.sqlConfig.getPassword());
            }
            catch (SQLException e) {
                if (this.sqlConfig.silentErrors()) break block2;
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getType() {
        return "MYSQL";
    }

    @Override
    public boolean isConnected() {
        try {
            return Objects.isNull(this.connection) ? false : !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public void close() {
        block2: {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                if (this.sqlConfig.silentErrors()) break block2;
                e.printStackTrace();
            }
        }
    }

    private void setupDatabase() {
        try {
            String query = this.SQLCreateDatabase(this.sqlConfig.getDatabase());
            int result = this.connection.createStatement().executeUpdate(query);
            this.checkSQLResult(result, query);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void setupTables() {
        try {
            String query = this.SQLCreateTable(this.sqlConfig.getDatabase(), this.sqlConfig.getTableRanks());
            int result = this.connection.createStatement().executeUpdate(query);
            this.checkSQLResult(result, query);
            query = this.SQLCreateTable(this.sqlConfig.getDatabase(), this.sqlConfig.getTablePlayers());
            result = this.connection.createStatement().executeUpdate(query);
            this.checkSQLResult(result, query);
            query = this.SQLCreateTable(this.sqlConfig.getDatabase(), this.sqlConfig.getTableMessages());
            result = this.connection.createStatement().executeUpdate(query);
            this.checkSQLResult(result, query);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadRanks() {
        if (!this.isConnected()) {
            this.reconnect();
        }
        Gson gson = new Gson();
        boolean success = false;
        this.setRanks(new ArrayList<PRRank>());
        HashMap<String, Object> rawDBData = new HashMap<String, Object>();
        try {
            String query = this.SQLSelectAllInTable(this.sqlConfig.getDatabase(), this.sqlConfig.getTableRanks());
            Statement st = this.connection.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                String key = rs.getString("keyname");
                String rawValue = rs.getString("val");
                Type mapType = new TypeToken<Object>(){}.getType();
                Object data = gson.fromJson(rawValue, mapType);
                rawDBData.put(key, data);
            }
        }
        catch (SQLException e) {
            success = false;
            e.printStackTrace();
        }
        HashMap rawRanksData = new HashMap();
        for (Map.Entry entry : rawDBData.entrySet()) {
            Map updatedData;
            String rankName = ((String)entry.getKey()).split("\\.")[0];
            if (!rawRanksData.containsKey(rankName)) {
                updatedData = new HashMap<String, String>();
                updatedData.put("name", rankName);
                rawRanksData.put(rankName, updatedData);
            }
            updatedData = (Map)rawRanksData.get(rankName);
            if (((String)entry.getKey()).split("\\.").length > 2) {
                String key = String.join((CharSequence)".", Arrays.copyOfRange(((String)entry.getKey()).split("\\."), 2, ((String)entry.getKey()).split("\\.").length));
                String propertyKey = ((String)entry.getKey()).split("\\.")[1];
                if (!((Map)rawRanksData.get(rankName)).containsKey(propertyKey)) {
                    HashMap newMap = new HashMap();
                    ((Map)rawRanksData.get(rankName)).put(propertyKey, newMap);
                }
                Map dataMap = (Map)((Map)rawRanksData.get(rankName)).get(propertyKey);
                dataMap.put(key, entry.getValue());
                ((Map)rawRanksData.get(rankName)).put(propertyKey, dataMap);
                continue;
            }
            updatedData.put(((String)entry.getKey()).split("\\.")[1], entry.getValue());
            rawRanksData.put(rankName, updatedData);
        }
        for (Map.Entry entry : rawRanksData.entrySet()) {
            PRRank rank = this.getSerializer().deserialize((Map)entry.getValue(), PRRank.class);
            if (!Objects.nonNull(rank)) continue;
            this.addRank(rank);
            success = true;
        }
        if (!success) {
            this.setRanks(new ArrayList<PRRank>());
        }
    }

    @Override
    public void loadPlayers() {
        if (!this.isConnected()) {
            this.reconnect();
        }
        Gson gson = new Gson();
        boolean success = false;
        this.setPlayers(new ArrayList<PRPlayer>());
        HashMap<String, Object> rawDBData = new HashMap<String, Object>();
        try {
            String query = this.SQLSelectAllInTable(this.sqlConfig.getDatabase(), this.sqlConfig.getTablePlayers());
            Statement st = this.connection.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                String key = rs.getString("keyname");
                String rawValue = rs.getString("val");
                Type mapType = new TypeToken<Object>(){}.getType();
                Object data = gson.fromJson(rawValue, mapType);
                rawDBData.put(key, data);
            }
        }
        catch (SQLException e) {
            success = false;
            e.printStackTrace();
        }
        HashMap rawPlayersData = new HashMap();
        for (Map.Entry entry : rawDBData.entrySet()) {
            Map updatedData;
            String playerUUID = ((String)entry.getKey()).split("\\.")[0];
            if (!rawPlayersData.containsKey(playerUUID)) {
                updatedData = new HashMap<String, String>();
                updatedData.put("uuid", playerUUID);
                rawPlayersData.put(playerUUID, updatedData);
            }
            updatedData = (Map)rawPlayersData.get(playerUUID);
            if (((String)entry.getKey()).split("\\.").length > 2) {
                String key = String.join((CharSequence)".", Arrays.copyOfRange(((String)entry.getKey()).split("\\."), 2, ((String)entry.getKey()).split("\\.").length));
                String propertyKey = ((String)entry.getKey()).split("\\.")[1];
                if (!((Map)rawPlayersData.get(playerUUID)).containsKey(propertyKey)) {
                    HashMap newMap = new HashMap();
                    ((Map)rawPlayersData.get(playerUUID)).put(propertyKey, newMap);
                }
                Map dataMap = (Map)((Map)rawPlayersData.get(playerUUID)).get(propertyKey);
                dataMap.put(key, entry.getValue());
                ((Map)rawPlayersData.get(playerUUID)).put(propertyKey, dataMap);
                continue;
            }
            updatedData.put(((String)entry.getKey()).split("\\.")[1], entry.getValue());
            rawPlayersData.put(playerUUID, updatedData);
        }
        for (Map.Entry entry : rawPlayersData.entrySet()) {
            PRPlayer player = this.getSerializer().deserialize((Map)entry.getValue(), PRPlayer.class);
            if (!Objects.nonNull(player)) continue;
            this.addPlayer(player);
            success = true;
        }
        if (!success) {
            this.setPlayers(new ArrayList<PRPlayer>());
        }
    }

    @Override
    public void saveRanks() {
        if (!this.isConnected()) {
            this.reconnect();
        }
        Gson gson = new Gson();
        try {
            String query = this.SQLDeleteAllInTable(this.sqlConfig.getDatabase(), this.sqlConfig.getTableRanks());
            int result = this.connection.createStatement().executeUpdate(query);
            this.checkSQLResult(result, query);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        PreparedStatement stmt = null;
        try {
            this.connection.setAutoCommit(false);
            stmt = this.connection.prepareStatement(this.SQLInsert(this.sqlConfig.getDatabase(), this.sqlConfig.getTableRanks()));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        HashMap<String, Map<String, Object>> ranks2 = new HashMap<String, Map<String, Object>>();
        for (PRRank pRRank : this.getRanks()) {
            Map<String, Object> serializedRank = this.getSerializer().serialize(pRRank);
            for (Map.Entry<String, Object> entry : serializedRank.entrySet()) {
                if (!entry.getValue().equals(pRRank.getName())) continue;
                serializedRank.remove(entry.getKey());
                break;
            }
            ranks2.put(pRRank.getName(), serializedRank);
        }
        for (Map.Entry entry : ranks2.entrySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.iterate(map, (LinkedHashMap)entry.getValue(), "");
            for (Map.Entry<String, Object> entry2 : map.entrySet()) {
                String dbKey = (String)entry.getKey() + "." + entry2.getKey();
                String serializedValue = gson.toJson(entry2.getValue());
                try {
                    if (stmt == null) continue;
                    stmt.clearParameters();
                    stmt.setString(1, dbKey);
                    stmt.setString(2, serializedValue);
                    stmt.addBatch();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            if (stmt != null) {
                stmt.executeBatch();
                this.connection.commit();
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void savePlayers() {
        if (!this.isConnected()) {
            this.reconnect();
        }
        Gson gson = new Gson();
        PreparedStatement stmt = null;
        try {
            this.connection.setAutoCommit(false);
            stmt = this.connection.prepareStatement(this.SQLInsert(this.sqlConfig.getDatabase(), this.sqlConfig.getTablePlayers()));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            String query = this.SQLDeleteAllInTable(this.sqlConfig.getDatabase(), this.sqlConfig.getTablePlayers());
            int result = this.connection.createStatement().executeUpdate(query);
            this.checkSQLResult(result, query);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        HashMap<String, Map<String, Object>> players2 = new HashMap<String, Map<String, Object>>();
        for (PRPlayer pRPlayer : this.getPlayers()) {
            Map<String, Object> serializedPlayer = this.getSerializer().serialize(pRPlayer);
            for (Map.Entry<String, Object> entry : serializedPlayer.entrySet()) {
                if (!entry.getValue().equals(pRPlayer.getUUID().toString())) continue;
                serializedPlayer.remove(entry.getKey());
                break;
            }
            players2.put(pRPlayer.getUUID().toString(), serializedPlayer);
        }
        for (Map.Entry entry : players2.entrySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.iterate(map, (LinkedHashMap)entry.getValue(), "");
            for (Map.Entry<String, Object> entry2 : map.entrySet()) {
                String dbKey = (String)entry.getKey() + "." + entry2.getKey();
                String serializedValue = gson.toJson(entry2.getValue());
                try {
                    if (stmt == null) continue;
                    stmt.clearParameters();
                    stmt.setString(1, dbKey);
                    stmt.setString(2, serializedValue);
                    stmt.addBatch();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            if (stmt != null) {
                stmt.executeBatch();
                this.connection.commit();
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveRank(PRRank rank) {
        this.addRank(rank);
        this.saveRanks();
    }

    @Override
    public void savePlayer(PRPlayer player) {
        this.addPlayer(player);
        this.savePlayers();
    }

    private String SQLCreateDatabase(String databaseName) {
        return "CREATE DATABASE IF NOT EXISTS " + databaseName;
    }

    private String SQLCreateTable(String databaseName, String tableName) {
        return "CREATE TABLE IF NOT EXISTS `" + databaseName + "`.`" + tableName + "` (`keyname` VARCHAR(256) NOT NULL UNIQUE, `val` LONGTEXT NOT NULL , UNIQUE(`keyname`));";
    }

    private String SQLInsert(String databaseName, String tableName) {
        return "INSERT INTO " + (databaseName.length() > 0 ? "`" + databaseName + "`." : "") + "`" + tableName + "` (keyname, val) VALUES (?, ?) ON DUPLICATE KEY UPDATE keyname = VALUES (keyname), val = VALUES (val)";
    }

    public void SQLInsert(String databaseName, String tableName, String key, String value) {
        if (!this.isConnected()) {
            this.reconnect();
        }
        PreparedStatement stmt = null;
        try {
            this.connection.setAutoCommit(false);
            stmt = this.connection.prepareStatement(this.SQLInsert(databaseName, tableName));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            if (stmt != null) {
                stmt.clearParameters();
                stmt.setString(1, key);
                stmt.setString(2, value);
                stmt.addBatch();
                stmt.executeBatch();
                this.connection.commit();
                this.connection.setAutoCommit(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteKeyInTable(String databaseName, String tableName, String key) {
        if (!this.isConnected()) {
            this.reconnect();
        }
        String query = "DELETE FROM `?`.? WHERE `keyname` = '?';";
        query = query.replaceFirst("\\?", databaseName);
        query = query.replaceFirst("\\?", tableName);
        query = query.replaceFirst("\\?", key);
        try {
            Statement st = this.connection.createStatement();
            st.execute(query);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private String SQLSelectAllInTable(String databaseName, String tableName) {
        return "SELECT * FROM `" + databaseName + "`.`" + tableName + "`;";
    }

    public Map<String, String> selectSimiliarInTable(String databaseName, String tableName, String baseKey) {
        if (!this.isConnected()) {
            this.reconnect();
        }
        String query = "SELECT * FROM `?`.? WHERE keyname LIKE '?%';";
        query = query.replaceFirst("\\?", databaseName);
        query = query.replaceFirst("\\?", tableName);
        query = query.replaceFirst("\\?", baseKey);
        HashMap<String, String> data = new HashMap<String, String>();
        try {
            Statement st = this.connection.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                String key = rs.getString("keyname");
                String value = rs.getString("val");
                data.put(key, value);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return data;
    }

    private String SQLDeleteAllInTable(String databaseName, String tableName) {
        return "DELETE FROM `" + databaseName + "`.`" + tableName + "`;";
    }

    private String SQLDropDatabase(String databaseName) {
        return "DROP DATABASE IF EXISTS " + databaseName;
    }

    private void checkSQLResult(int result, String query) throws SQLException {
        if (result < 0) {
            throw new SQLException("Failed to execute SQL query (" + query + ")");
        }
    }

    @Override
    public void removeAllData() {
        if (this.isConnected()) {
            try {
                String query = this.SQLDropDatabase(this.sqlConfig.getDatabase());
                int result = this.connection.createStatement().executeUpdate(query);
                this.checkSQLResult(result, query);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public PowerSQLConfiguration getConfig() {
        return this.sqlConfig;
    }
}

