/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.storage.provided;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import nl.svenar.powerranks.common.storage.PowerStorageManager;
import nl.svenar.powerranks.common.structure.PRPlayer;
import nl.svenar.powerranks.common.structure.PRRank;

public class JSONStorageManager
extends PowerStorageManager {
    private File ranksFile;
    private File playersFile;

    public JSONStorageManager(String directory, String ranksFileName, String playersFileName) {
        File targetDir = new File(directory);
        this.ranksFile = new File(targetDir, ranksFileName);
        this.playersFile = new File(targetDir, playersFileName);
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        if (!this.ranksFile.exists()) {
            try {
                this.ranksFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.playersFile.exists()) {
            try {
                this.playersFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loadRanks();
        this.loadPlayers();
    }

    @Override
    public String getType() {
        return "JSON";
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void loadRanks() {
        boolean success = false;
        this.setRanks(new ArrayList<PRRank>());
        StringBuilder resultStringBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.ranksFile)));){
            String line;
            while ((line = br.readLine()) != null) {
                resultStringBuilder.append(line).append("\n");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        String jsonData = resultStringBuilder.toString();
        if (jsonData.length() > 0) {
            Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
            Gson gson = new Gson();
            Map data = (Map)gson.fromJson(jsonData, mapType);
            for (Map.Entry entry : data.entrySet()) {
                if (!(entry.getValue() instanceof LinkedTreeMap)) continue;
                LinkedTreeMap map = (LinkedTreeMap)entry.getValue();
                map.put((Object)"name", entry.getKey());
                PRRank rank = this.getSerializer().deserialize((Map<String, Object>)map, PRRank.class);
                this.addRank(rank);
                success = true;
            }
        }
        if (!success) {
            this.setRanks(new ArrayList<PRRank>());
        }
    }

    @Override
    public void loadPlayers() {
        boolean success = false;
        this.setPlayers(new ArrayList<PRPlayer>());
        StringBuilder resultStringBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.playersFile)));){
            String line;
            while ((line = br.readLine()) != null) {
                resultStringBuilder.append(line).append("\n");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        String jsonData = resultStringBuilder.toString();
        if (jsonData.length() > 0) {
            Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
            Gson gson = new Gson();
            Map data = (Map)gson.fromJson(jsonData, mapType);
            for (Map.Entry entry : data.entrySet()) {
                if (!(entry.getValue() instanceof LinkedTreeMap)) continue;
                LinkedTreeMap map = (LinkedTreeMap)entry.getValue();
                map.put((Object)"uuid", (Object)UUID.fromString((String)entry.getKey()));
                PRPlayer player = this.getSerializer().deserialize((Map<String, Object>)map, PRPlayer.class);
                this.addPlayer(player);
                success = true;
            }
        }
        if (!success) {
            this.setPlayers(new ArrayList<PRPlayer>());
        }
    }

    public Map<String, Object> getRanksAsMap() {
        HashMap<String, Object> ranks2 = new HashMap<String, Object>();
        for (PRRank r : this.getRanks()) {
            Map<String, Object> serializedRank = this.getSerializer().serialize(r);
            for (Map.Entry<String, Object> entry : serializedRank.entrySet()) {
                if (!entry.getValue().equals(r.getName())) continue;
                serializedRank.remove(entry.getKey());
                break;
            }
            ranks2.put(r.getName(), serializedRank);
        }
        return ranks2;
    }

    public String getRanksAsJSON(boolean pretty) {
        Gson gson = null;
        gson = pretty ? new GsonBuilder().setPrettyPrinting().create() : new Gson();
        Map<String, Object> ranks2 = this.getRanksAsMap();
        return gson.toJson(ranks2);
    }

    public Map<String, Object> getPlayersAsMap() {
        HashMap<String, Object> players2 = new HashMap<String, Object>();
        for (PRPlayer p : this.getPlayers()) {
            Map<String, Object> serializedPlayer = this.getSerializer().serialize(p);
            for (Map.Entry<String, Object> entry : serializedPlayer.entrySet()) {
                if (!entry.getValue().equals(p.getUUID().toString())) continue;
                serializedPlayer.remove(entry.getKey());
                break;
            }
            players2.put(p.getUUID().toString(), serializedPlayer);
        }
        return players2;
    }

    public String getPlayersAsJSON(boolean pretty) {
        Gson gson = null;
        gson = pretty ? new GsonBuilder().setPrettyPrinting().create() : new Gson();
        Map<String, Object> players2 = this.getPlayersAsMap();
        return gson.toJson(players2);
    }

    public ArrayList<PRRank> getRanksFromJSON(LinkedTreeMap<?, ?> ranks) {
        ArrayList<PRRank> newRanks = new ArrayList<PRRank>();
        for (Map.Entry entry : ranks.entrySet()) {
            LinkedTreeMap rankData;
            String rankName = (String)entry.getKey();
            LinkedTreeMap map = rankData = (LinkedTreeMap)entry.getValue();
            map.put((Object)"name", (Object)rankName);
            PRRank newRank = this.getSerializer().deserialize((Map<String, Object>)map, PRRank.class);
            newRanks.add(newRank);
        }
        return newRanks;
    }

    public ArrayList<PRPlayer> getPlayersFromJSON(LinkedTreeMap<?, ?> players) {
        ArrayList<PRPlayer> newPlayers = new ArrayList<PRPlayer>();
        for (Map.Entry entry : players.entrySet()) {
            LinkedTreeMap playerData;
            String playerUUID = (String)entry.getKey();
            LinkedTreeMap map = playerData = (LinkedTreeMap)entry.getValue();
            map.put((Object)"uuid", (Object)UUID.fromString(playerUUID));
            PRPlayer newPlayer = this.getSerializer().deserialize((Map<String, Object>)map, PRPlayer.class);
            newPlayers.add(newPlayer);
        }
        return newPlayers;
    }

    @Override
    public void saveRanks() {
        String jsonData = this.getRanksAsJSON(true);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.ranksFile));
            writer.write(jsonData);
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void savePlayers() {
        String jsonData = this.getPlayersAsJSON(true);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.playersFile));
            writer.write(jsonData);
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void saveRank(PRRank rank) {
        this.addRank(rank);
        this.saveRanks();
    }

    @Override
    public void savePlayer(PRPlayer player) {
        this.addPlayer(player);
        this.savePlayers();
    }

    @Override
    public void removeAllData() {
        this.ranksFile.delete();
        this.playersFile.delete();
    }
}

