/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nl.svenar.powerranks.common.serializer.PRSerializer;
import nl.svenar.powerranks.common.structure.PRPlayer;
import nl.svenar.powerranks.common.structure.PRRank;

public abstract class PowerStorageManager {
    private List<PRRank> ranks = new ArrayList<PRRank>();
    private List<PRPlayer> players = new ArrayList<PRPlayer>();
    private PRSerializer serializer = new PRSerializer();

    public abstract String getType();

    public PRSerializer getSerializer() {
        return this.serializer;
    }

    public void loadAll() {
        this.loadRanks();
        this.loadPlayers();
    }

    public void saveAll() {
        this.saveRanks();
        this.savePlayers();
    }

    public abstract boolean isConnected();

    public abstract void loadRanks();

    public abstract void loadPlayers();

    public abstract void saveRanks();

    public abstract void savePlayers();

    public abstract void saveRank(PRRank var1);

    public abstract void savePlayer(PRPlayer var1);

    public abstract void removeAllData();

    public List<PRRank> getRanks() {
        return this.ranks;
    }

    public PRRank getRank(String rankName) {
        for (PRRank obj : this.ranks) {
            if (!obj.getName().equalsIgnoreCase(rankName)) continue;
            return obj;
        }
        return null;
    }

    public void addRank(PRRank rank) {
        this.ranks.add(rank);
    }

    public void removeRank(PRRank rank) {
        this.ranks.remove(rank);
    }

    public void setRanks(List<PRRank> ranks) {
        this.ranks = ranks;
    }

    public void clearRanks() {
        this.ranks = new ArrayList<PRRank>();
    }

    public List<PRPlayer> getPlayers() {
        return this.players;
    }

    public PRPlayer getPlayer(String playerName) {
        for (PRPlayer obj : this.players) {
            if (!obj.getName().equalsIgnoreCase(playerName)) continue;
            return obj;
        }
        return null;
    }

    public PRPlayer getPlayer(UUID playerUUID) {
        for (PRPlayer obj : this.players) {
            if (!obj.getUUID().toString().equals(playerUUID.toString())) continue;
            return obj;
        }
        return null;
    }

    public void addPlayer(PRPlayer player) {
        this.players.add(player);
    }

    public void removePlayer(PRPlayer player) {
        this.players.remove(player);
    }

    public void setPlayers(List<PRPlayer> players) {
        this.players = players;
    }

    public void clearPlayers() {
        this.players = new ArrayList<PRPlayer>();
    }

    public void iterate(Map<String, Object> out, Map<String, Object> map, String keyPart) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                this.iterate(out, (Map)entry.getValue(), keyPart + "." + entry.getKey());
                continue;
            }
            String key = keyPart + "." + entry.getKey();
            key = key.replaceFirst("\\.", "");
            out.put(key, entry.getValue());
        }
    }
}

