/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PowerConfigManager {
    protected Map<String, Object> data = new HashMap<String, Object>();
    protected boolean hasCreatedFile = false;

    public abstract void save();

    public abstract void reload();

    public Map<String, Object> getRawData() {
        return this.data;
    }

    public void setRawData(Map<String, Object> data) {
        this.data = data;
    }

    public void copyFile(InputStream inputSteam, File outputFile) throws IOException {
        int len;
        if (inputSteam == null) {
            throw new FileNotFoundException("Input stream for '" + outputFile.getAbsolutePath() + "'' is null");
        }
        FileOutputStream out = new FileOutputStream(outputFile);
        byte[] buf = new byte[1024];
        while ((len = inputSteam.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        inputSteam.close();
    }

    public boolean isNewFile() {
        return this.hasCreatedFile;
    }

    public List<String> getKeys(String path) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<?, ?> entry : this.getMap(path, new HashMap()).entrySet()) {
            keys.add(String.valueOf(entry.getKey()));
        }
        return keys;
    }

    public Object getKV(String key, Object defaultValue) {
        String[] keySplit = key.split("\\.");
        Object tmp = null;
        Object output = null;
        int index = 0;
        for (String keyPart : keySplit) {
            HashMap tmpMap;
            boolean isLastKeyPart;
            boolean bl = isLastKeyPart = index == keySplit.length - 1;
            if (!isLastKeyPart) {
                if (index == 0) {
                    tmp = this.data.get(keyPart);
                } else if (tmp != null && tmp instanceof HashMap) {
                    tmpMap = (HashMap)tmp;
                    tmp = tmpMap.get(keyPart);
                }
            } else if (index > 0) {
                if (tmp != null && tmp instanceof HashMap) {
                    tmpMap = (HashMap)tmp;
                    output = tmpMap.get(keyPart);
                }
            } else {
                output = this.data.get(keyPart);
            }
            ++index;
        }
        if (output == null && defaultValue != null) {
            this.setKV(key, defaultValue);
            output = defaultValue;
        }
        return output;
    }

    public void setKV(String key, Object value) {
        String[] keySplit = key.split("\\.");
        int entries = keySplit.length;
        Map<String, Object> currentKey = this.data;
        for (int i = 0; i < entries; ++i) {
            boolean isLast;
            boolean bl = isLast = i == entries - 1;
            if (!isLast) {
                if (currentKey instanceof HashMap) {
                    currentKey = ((HashMap)currentKey).get(keySplit[i]);
                    continue;
                }
                if (currentKey == null) continue;
                if (((HashMap)currentKey).containsKey(keySplit[i])) {
                    throw new IllegalStateException("Key part '" + keySplit[i] + "' from '" + key + "' is not a map and has no children to be set!");
                }
                ((HashMap)currentKey).put(keySplit[i], new HashMap());
                currentKey = ((HashMap)currentKey).get(keySplit[i]);
                continue;
            }
            if (currentKey == null) continue;
            try {
                ((HashMap)currentKey).put(keySplit[i], value);
                continue;
            }
            catch (ClassCastException cce) {
                ((LinkedTreeMap)currentKey).put((Object)keySplit[i], value);
            }
        }
    }

    public boolean hasKey(String key) {
        return this.data.containsKey(key);
    }

    public String getString(String key, String defaultValue) {
        return this.getKV(key, defaultValue).toString();
    }

    public String getString(String key) {
        return this.getKV(key, key).toString();
    }

    public void setString(String key, String value) {
        this.setKV(key, value);
    }

    public int getInt(String key, int defaultValue) {
        String input = this.getKV(key, defaultValue).toString();
        int output = input.contains(".") ? Math.round(Float.parseFloat(input.replaceAll("[^0-9.]", ""))) : Integer.parseInt(input.replaceAll("[^0-9.]", ""));
        return output;
    }

    public void setInt(String key, int value) {
        this.setKV(key, value);
    }

    public float getFloat(String key, float defaultValue) {
        return Float.parseFloat(this.getKV(key, Float.valueOf(defaultValue)).toString());
    }

    public void setFloat(String key, float value) {
        this.setKV(key, Float.valueOf(value));
    }

    public boolean getBool(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getKV(key, defaultValue).toString());
    }

    public void setBool(String key, boolean value) {
        this.setKV(key, value);
    }

    public List<?> getList(String key, List<?> defaultValue) {
        return this.getKV(key, defaultValue) instanceof List ? (List)this.getKV(key, defaultValue) : defaultValue;
    }

    public void setList(String key, List<?> value) {
        this.setKV(key, value);
    }

    public Map<?, ?> getMap(String key, Map<?, ?> defaultValue) {
        return this.getKV(key, defaultValue) instanceof Map ? (Map)this.getKV(key, defaultValue) : defaultValue;
    }

    public void setMap(String key, Map<?, ?> value) {
        if (value.size() == 1) {
            this.setKV(key + "." + value.keySet().toArray()[0], value.values().toArray()[0]);
        } else {
            this.setKV(key, value);
        }
    }

    public String toJSON(String searchKey, boolean pretty) {
        Gson gson = null;
        gson = pretty ? new GsonBuilder().setPrettyPrinting().create() : new Gson();
        if (searchKey == null || searchKey.length() == 0) {
            return gson.toJson(this.data);
        }
        return gson.toJson(this.data.get(searchKey));
    }

    public void fromJSON(String targetKey, LinkedTreeMap<?, ?> input) {
        HashMap<String, Object> newData = new HashMap<String, Object>();
        for (Map.Entry entry : input.entrySet()) {
            newData.put(entry.getKey().toString(), entry.getValue());
        }
        if (targetKey == null || targetKey.length() == 0) {
            this.setRawData(newData);
        } else {
            this.data = new HashMap<String, Object>();
            this.data.put(targetKey, newData);
        }
    }

    public boolean destroyFile() {
        return false;
    }
}

