/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.http;

import java.io.IOException;
import nl.svenar.lib.okhttp3.Call;
import nl.svenar.lib.okhttp3.Callback;
import nl.svenar.lib.okhttp3.MediaType;
import nl.svenar.lib.okhttp3.OkHttpClient;
import nl.svenar.lib.okhttp3.Request;
import nl.svenar.lib.okhttp3.Response;

public abstract class PowerHTTPClient {
    public static final MediaType JSON_TYPE = MediaType.parse("application/json; charset=utf-8");
    protected final OkHttpClient httpClient;

    public PowerHTTPClient() {
        this.httpClient = new OkHttpClient();
    }

    public PowerHTTPClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected abstract void callbackFailure(Call var1, IOException var2);

    protected abstract void callbackResponse(Call var1, Response var2);

    protected Request createSimpleRequest(String url) {
        return new Request.Builder().url(url).build();
    }

    protected void makeHttpRequest(Request request) {
        Call call = this.httpClient.newCall(request);
        final PowerHTTPClient self = this;
        call.enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException exception) {
                self.callbackFailure(call, exception);
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                self.callbackResponse(call, response);
            }
        });
    }
}

