/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.http;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import nl.svenar.lib.okhttp3.Call;
import nl.svenar.lib.okhttp3.OkHttpClient;
import nl.svenar.lib.okhttp3.Request;
import nl.svenar.lib.okhttp3.RequestBody;
import nl.svenar.lib.okhttp3.Response;
import nl.svenar.powerranks.common.PowerLogger;
import nl.svenar.powerranks.common.http.PowerHTTPClient;

public class DatabinClient
extends PowerHTTPClient {
    private final String url;
    private final String userAgent;
    private String rawResponse = "";
    private int responseCode = 0;

    public DatabinClient(OkHttpClient httpClient, String url, String userAgent) {
        super(httpClient);
        this.url = url.endsWith("/") ? url : url + "/";
        this.userAgent = userAgent;
    }

    public DatabinClient(String url, String userAgent) {
        this.url = url.endsWith("/") ? url : url + "/";
        this.userAgent = userAgent;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void postJSON(String text) {
        RequestBody body = RequestBody.create(text, JSON_TYPE);
        Request.Builder requestBuilder = new Request.Builder().url(this.url + "documents").header("User-Agent", this.userAgent).header("Content-Encoding", "gzip");
        Request request = requestBuilder.post(body).build();
        this.makeHttpRequest(request);
    }

    public void getJSON(String key) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url + "raw/" + key).header("User-Agent", this.userAgent).header("Content-Encoding", "gzip");
        Request request = requestBuilder.get().build();
        this.makeHttpRequest(request);
    }

    @Override
    protected void callbackFailure(Call call, IOException exception) {
        this.rawResponse = "[FAILED] " + exception.getMessage();
    }

    @Override
    protected void callbackResponse(Call call, Response response) {
        try {
            this.rawResponse = response.body().string();
            this.responseCode = response.code();
        }
        catch (IOException e) {
            this.rawResponse = "[FAILED] " + e.getMessage();
        }
    }

    public boolean hasResponse() {
        return this.rawResponse.length() > 0;
    }

    public Map<String, String> getResponse() {
        String response = this.rawResponse;
        this.rawResponse = "";
        try {
            if (this.responseCode < 200 || this.responseCode > 299 || response.contains("</html>")) {
                throw new IllegalStateException("Invalid response from server (Error " + this.responseCode + ")!");
            }
            return this.parseJSON(response);
        }
        catch (IllegalStateException ise) {
            PowerLogger.severe("");
            PowerLogger.severe("=== ------------------------------------- ===");
            PowerLogger.severe("An error occurred while parsing response code");
            PowerLogger.severe(ise.getMessage());
            PowerLogger.severe("=== ------------------------------------- ===");
            PowerLogger.severe("");
            return new HashMap<String, String>();
        }
    }

    public String getRawResponse() {
        String response = this.rawResponse;
        this.rawResponse = "";
        return response;
    }

    public Map<String, String> parseJSON(String response) throws IllegalStateException {
        Gson gson = new Gson();
        Type mapType = new TypeToken<Map<String, String>>(){}.getType();
        Map map = (Map)gson.fromJson(response, mapType);
        return map;
    }
}

