/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.svenar.lib.json.simple.JSONObject;
import nl.svenar.lib.json.simple.JSONValue;
import nl.svenar.powerranks.bukkit.PowerRanks;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Player;

public class Util {
    public static final long TASK_TPS = 20L;

    public static String getServerVersion(Server server) {
        try {
            Matcher matcher = Pattern.compile("\\d{1,3}.\\d{1,3}|\\d{1,3}.\\d{1,3}.\\d{1,3}").matcher(server.getVersion());
            ArrayList<String> results = new ArrayList<String>();
            while (matcher.find()) {
                if (matcher.groupCount() > 0) {
                    results.add(matcher.group(1));
                    continue;
                }
                results.add(matcher.group());
            }
            return (String)results.get(0);
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    public static String getServerType(Server server) {
        try {
            Matcher matcher = Pattern.compile("-\\w{1,32}-").matcher(server.getVersion());
            ArrayList<String> results = new ArrayList<String>();
            while (matcher.find()) {
                if (matcher.groupCount() > 0) {
                    results.add(matcher.group(1));
                    continue;
                }
                results.add(matcher.group());
            }
            return ((String)results.get(0)).replaceAll("-", "");
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    public static String replaceAll(String source2, String key, String value) {
        String[] split = source2.split(Pattern.quote(key));
        if (split.length > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append(split[0]);
            for (int i = 1; i < split.length; ++i) {
                builder.append(value);
                builder.append(split[i]);
            }
            while (source2.endsWith(key)) {
                builder.append(value);
                source2 = source2.substring(0, source2.length() - key.length());
            }
            return builder.toString();
        }
        return source2;
    }

    public static boolean isPowerRanksSign(PowerRanks main, Sign sign) {
        String sign_header;
        try {
            Class.forName("org.bukkit.block.sign.Side");
            sign_header = sign.getSide(Side.FRONT).getLine(0);
            if (sign_header.length() == 0) {
                sign_header = sign.getSide(Side.BACK).getLine(0);
            }
        }
        catch (ClassNotFoundException e) {
            sign_header = sign.getLine(0);
        }
        return Util.isPowerRanksSign(main, sign_header);
    }

    public static boolean isPowerRanksSign(PowerRanks main, String sign_header) {
        return sign_header.toLowerCase().contains("powerranks") && PowerRanks.getConfigManager().getBool("signs.enabled", false);
    }

    public String getCraftBukkitClassName(String simpleName) {
        String version = Bukkit.getServer().getClass().getName().substring("org.bukkit.craftbukkit".length());
        version = version.substring(0, version.length() - "CraftServer".length());
        return "org.bukkit.craftbukkit" + version + simpleName;
    }

    private static String getServerVersion() {
        Class server = Bukkit.getServer().getClass();
        if (!server.getSimpleName().equals("CraftServer")) {
            return ".";
        }
        if (server.getName().equals("org.bukkit.craftbukkit.CraftServer")) {
            return ".";
        }
        String version = server.getName().substring("org.bukkit.craftbukkit".length());
        return version.substring(0, version.length() - "CraftServer".length());
    }

    public static String nms(String className) {
        return "net.minecraft.server" + Util.getServerVersion() + className;
    }

    public static Class<?> nmsClass(String className) throws ClassNotFoundException {
        return Class.forName(Util.nms(className));
    }

    public static String obc(String className) {
        return "org.bukkit.craftbukkit" + Util.getServerVersion() + className;
    }

    public static Class<?> obcClass(String className) throws ClassNotFoundException {
        return Class.forName(Util.obc(className));
    }

    public static int calculateVersionFromString(String input) {
        int output = 0;
        input = input.replaceAll("[a-zA-Z- ]", "");
        String[] input_split = input.split("\\.");
        String calcString = "1000000";
        for (int i = 0; i < input_split.length; ++i) {
            if (input_split[i].length() == 0) continue;
            int num = Integer.parseInt(input_split[i]) * Integer.parseInt(calcString);
            if (calcString.charAt(calcString.length() - 1) == '0') {
                calcString = calcString.substring(0, calcString.length() - 1);
            }
            output += num;
        }
        return output;
    }

    public static Player getPlayerByName(String target_player_name) {
        Player target_player = null;
        for (Player online_player : Bukkit.getOnlinePlayers()) {
            if (!online_player.getName().equalsIgnoreCase(target_player_name)) continue;
            target_player = online_player;
            break;
        }
        return target_player;
    }

    public static String[] splitStringEvery(String s, int interval) {
        int arrayLength = (int)Math.ceil((double)s.length() / (double)interval);
        String[] result = new String[arrayLength];
        int j = 0;
        int lastIndex = result.length - 1;
        for (int i = 0; i < lastIndex; ++i) {
            result[i] = s.substring(j, j + interval);
            j += interval;
        }
        result[lastIndex] = s.substring(j);
        return result;
    }

    public static URLConnection getURL(String urlString) throws Exception {
        int MAX_REDIRECTS = 10;
        URLConnection urlConnection = new URL(urlString).openConnection();
        String redirect = urlConnection.getHeaderField("Location");
        for (int i = 0; i < MAX_REDIRECTS && redirect != null; ++i) {
            urlConnection = new URL(redirect).openConnection();
            redirect = urlConnection.getHeaderField("Location");
        }
        return urlConnection;
    }

    public static String readUrl(String urlString) throws Exception {
        String line;
        String output = "";
        URLConnection urlConnection = Util.getURL(urlString);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        while ((line = bufferedReader.readLine()) != null) {
            output = output + line + "\n";
        }
        bufferedReader.close();
        return output;
    }

    public static UUID getUUIDFromAPI(String playerName) {
        try {
            String line;
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + playerName);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String UUIDJson = "";
            while ((line = in.readLine()) != null) {
                UUIDJson = UUIDJson + line + "\n";
            }
            in.close();
            JSONObject UUIDObject = (JSONObject)JSONValue.parseWithException(UUIDJson);
            String uuid = UUIDObject.get("id").toString();
            if (!uuid.contains("-")) {
                uuid = uuid.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5");
            }
            return UUID.fromString(uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getNameFromAPI(String uuid) {
        try {
            String line;
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.replaceAll("-", ""));
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String nameJson = "";
            while ((line = in.readLine()) != null) {
                nameJson = nameJson + line + "\n";
            }
            in.close();
            JSONObject nameObject = (JSONObject)JSONValue.parseWithException(nameJson);
            return nameObject.get("name").toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long convertToLong(Object value) {
        if (value instanceof Integer) {
            return (long)((Integer)value);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new IllegalArgumentException("Value is not an Integer or Long");
    }

    public static Object formatStringToType(String input) {
        ArrayList<String> output = input;
        if (input.equalsIgnoreCase("true") || input.equalsIgnoreCase("false")) {
            output = Boolean.parseBoolean(input);
        } else if (input.matches("^\\d+$")) {
            try {
                output = Integer.parseInt(input);
            }
            catch (Exception e) {
                output = Long.parseLong(input);
            }
        } else if (input.matches("^\\d+\\.\\d+$")) {
            output = Double.parseDouble(input);
        } else if (input.startsWith("[") && input.endsWith("]")) {
            String[] inputSplit = input.substring(1, input.length() - 1).split(",");
            ArrayList<String> outputList = new ArrayList<String>();
            for (String inputSplitItem : inputSplit) {
                outputList.add(inputSplitItem);
            }
            output = outputList;
        }
        return output;
    }
}

