/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import nl.svenar.powerranks.bukkit.PowerRanks;
import org.bukkit.Bukkit;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredListener;

public class PluginReloader {
    public void reload(String name) {
        this.disable(name);
        this.enable(name);
    }

    public void disable(String name) {
        ClassLoader cl;
        PluginManager pluginManager = Bukkit.getPluginManager();
        Plugin plugin = pluginManager.getPlugin(name);
        SimpleCommandMap commandMap = null;
        List plugins = null;
        Map names = null;
        Map commands = null;
        Map listeners = null;
        boolean reloadlisteners = true;
        if (pluginManager != null) {
            pluginManager.disablePlugin(plugin);
            try {
                Field pluginsField = Bukkit.getPluginManager().getClass().getDeclaredField("plugins");
                pluginsField.setAccessible(true);
                plugins = (List)pluginsField.get(pluginManager);
                Field lookupNamesField = Bukkit.getPluginManager().getClass().getDeclaredField("lookupNames");
                lookupNamesField.setAccessible(true);
                names = (Map)lookupNamesField.get(pluginManager);
                try {
                    Field listenersField = Bukkit.getPluginManager().getClass().getDeclaredField("listeners");
                    listenersField.setAccessible(true);
                    listeners = (Map)listenersField.get(pluginManager);
                }
                catch (Exception e) {
                    reloadlisteners = false;
                }
                Field commandMapField = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
                commandMapField.setAccessible(true);
                commandMap = (SimpleCommandMap)commandMapField.get(pluginManager);
                Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
                knownCommandsField.setAccessible(true);
                commands = (Map)knownCommandsField.get(commandMap);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        pluginManager.disablePlugin(plugin);
        if (plugins != null && plugins.contains(plugin)) {
            plugins.remove(plugin);
        }
        if (names != null && names.containsKey(name)) {
            names.remove(name);
        }
        if (listeners != null && reloadlisteners) {
            for (SortedSet set : listeners.values()) {
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    RegisteredListener value = (RegisteredListener)it.next();
                    if (value.getPlugin() != plugin) continue;
                    it.remove();
                }
            }
        }
        if (commandMap != null && commands != null) {
            Iterator it = commands.entrySet().iterator();
            while (it.hasNext()) {
                PluginCommand c;
                Map.Entry entry = it.next();
                if (!(entry.getValue() instanceof PluginCommand) || (c = (PluginCommand)entry.getValue()).getPlugin() != plugin) continue;
                c.unregister(commandMap);
                it.remove();
            }
        }
        if ((cl = plugin.getClass().getClassLoader()) instanceof URLClassLoader) {
            try {
                Field pluginField = cl.getClass().getDeclaredField("plugin");
                pluginField.setAccessible(true);
                pluginField.set(cl, null);
                Field pluginInitField = cl.getClass().getDeclaredField("pluginInit");
                pluginInitField.setAccessible(true);
                pluginInitField.set(cl, null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                PowerRanks.getInstance().getLogger().severe(ex.getMessage());
            }
            try {
                ((URLClassLoader)cl).close();
            }
            catch (IOException ex) {
                PowerRanks.getInstance().getLogger().severe(ex.getMessage());
            }
        }
        System.gc();
    }

    public void enable(String name) {
        Plugin target = null;
        File pluginDir = new File("plugins");
        if (!pluginDir.isDirectory()) {
            return;
        }
        File pluginFile = new File(pluginDir, name + ".jar");
        if (!pluginFile.isFile()) {
            for (File f : pluginDir.listFiles()) {
                if (!f.getName().endsWith(".jar")) continue;
                try {
                    PluginDescriptionFile desc = PowerRanks.getInstance().getPluginLoader().getPluginDescription(f);
                    if (!desc.getName().equalsIgnoreCase(name)) continue;
                    pluginFile = f;
                    break;
                }
                catch (InvalidDescriptionException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
        try {
            target = Bukkit.getPluginManager().loadPlugin(pluginFile);
        }
        catch (InvalidDescriptionException e) {
            e.printStackTrace();
            return;
        }
        catch (InvalidPluginException e) {
            e.printStackTrace();
            return;
        }
        target.onLoad();
        Bukkit.getPluginManager().enablePlugin(target);
    }
}

