/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.update;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.common.storage.PowerConfigManager;
import nl.svenar.powerranks.common.storage.provided.YAMLConfigManager;
import nl.svenar.powerranks.common.storage.provided.YAMLStorageManager;
import nl.svenar.powerranks.common.structure.PRPermission;
import nl.svenar.powerranks.common.structure.PRPlayer;
import nl.svenar.powerranks.common.structure.PRPlayerRank;
import nl.svenar.powerranks.common.structure.PRRank;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigFilesUpdater {
    private static final String subPrefixSuffixRegex = "[ ]{0,1}([&][a-fA-F0-9k-oK-OrR]){0,1}((&){0,1}[#][a-fA-F0-9]{6}){0,1}[ ]{0,1}[\\[](subprefix|subsuffix)[\\]][ ]{0,1}([&][a-fA-F0-9k-oK-OrR]){0,1}((&){0,1}[#][a-fA-F0-9]{6}){0,1}[ ]{0,1}";
    private static File backupDir;
    private static File backupRanks;
    private static File backupConfig;
    private static File backupLang;
    private static File backupPlayers;
    private static File oldRanksFile;
    private static File newRanksFile;
    private static File oldPlayersFile;
    private static File newPlayersFile;
    private static File usertagsFile;
    private static File configFile;
    private static File langFile;

    public static void updateOldDataFiles() {
        backupDir = new File(PowerRanks.fileLoc + File.separator + "backup" + File.separator + "old");
        backupRanks = new File(PowerRanks.fileLoc + File.separator + "backup" + File.separator + "old" + File.separator + "Ranks.yml");
        backupPlayers = new File(PowerRanks.fileLoc + File.separator + "backup" + File.separator + "old" + File.separator + "Players.yml");
        backupConfig = new File(PowerRanks.fileLoc + File.separator + "backup" + File.separator + "old" + File.separator + "config.yml");
        backupLang = new File(PowerRanks.fileLoc + File.separator + "backup" + File.separator + "old" + File.separator + "lang.yml");
        oldRanksFile = new File(PowerRanks.fileLoc + File.separator + "Ranks" + File.separator + "Ranks.yml");
        newRanksFile = new File(PowerRanks.fileLoc + File.separator + "ranks.yml");
        oldPlayersFile = new File(PowerRanks.fileLoc + File.separator + "Ranks" + File.separator + "Players.yml");
        newPlayersFile = new File(PowerRanks.fileLoc + File.separator + "players.yml");
        usertagsFile = new File(PowerRanks.fileLoc + File.separator + "usertags.yml");
        configFile = new File(PowerRanks.fileLoc + File.separator + "config.yml");
        langFile = new File(PowerRanks.fileLoc + File.separator + "lang.yml");
        if (Files.exists(oldRanksFile.toPath(), new LinkOption[0])) {
            PRPermission newPermission;
            PowerRanks.getInstance().getLogger().warning("Converting data from a previous installation!");
            YAMLConfigManager oldConfigManager = new YAMLConfigManager(PowerRanks.fileLoc, "config.yml");
            YAMLConfigManager oldLanguageManager = new YAMLConfigManager(PowerRanks.fileLoc, "lang.yml");
            try {
                Files.createDirectories(backupDir.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (Files.exists(oldRanksFile.toPath(), new LinkOption[0])) {
                    Files.move(oldRanksFile.toPath(), backupRanks.toPath(), new CopyOption[0]);
                }
                if (Files.exists(oldPlayersFile.toPath(), new LinkOption[0])) {
                    Files.move(oldPlayersFile.toPath(), backupPlayers.toPath(), new CopyOption[0]);
                }
                if (Files.exists(configFile.toPath(), new LinkOption[0])) {
                    Files.move(configFile.toPath(), backupConfig.toPath(), new CopyOption[0]);
                }
                if (Files.exists(langFile.toPath(), new LinkOption[0])) {
                    Files.move(langFile.toPath(), backupLang.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                Files.delete(new File(PowerRanks.fileLoc + File.separator + "Ranks").toPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            PowerRanks.getInstance().getLogger().warning("Finished backing up data from a previous version.");
            YAMLStorageManager storageManager = new YAMLStorageManager(PowerRanks.fileLoc, newRanksFile.getName(), newPlayersFile.getName());
            storageManager.loadAll();
            ArrayList<PRRank> storedRanks = new ArrayList<PRRank>();
            ArrayList<PRPlayer> storedPlayers = new ArrayList<PRPlayer>();
            YAMLConfigManager newConfigManager = new YAMLConfigManager(PowerRanks.fileLoc, configFile.getName(), "config.yml");
            YAMLConfigManager newLanguageManager = new YAMLConfigManager(PowerRanks.fileLoc, langFile.getName(), "lang.yml");
            YAMLConfigManager usertagManager = new YAMLConfigManager(PowerRanks.fileLoc, usertagsFile.getName());
            YamlConfiguration ranksYaml = new YamlConfiguration();
            try {
                ranksYaml.load(backupRanks);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InvalidConfigurationException e) {
                e.printStackTrace();
            }
            YamlConfiguration playersYaml = new YamlConfiguration();
            try {
                playersYaml.load(backupPlayers);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InvalidConfigurationException e) {
                e.printStackTrace();
            }
            Map<String, Object> configData = newConfigManager.getRawData();
            for (Map.Entry<String, Object> entry : oldConfigManager.getRawData().entrySet()) {
                if (entry.getKey().contains("version")) continue;
                configData.put(entry.getKey(), entry.getValue());
            }
            newConfigManager.setRawData(configData);
            Map<?, ?> generalConfigData = newConfigManager.getMap("general", new HashMap());
            CacheManager.configConverterSetDefaultRank(ranksYaml.getString("Default"));
            newConfigManager.setMap("general", generalConfigData);
            ((PowerConfigManager)newConfigManager).save();
            Map<String, Object> languageData = newLanguageManager.getRawData();
            for (Map.Entry<String, Object> entry : oldLanguageManager.getRawData().entrySet()) {
                if (entry.getKey().contains("version")) continue;
                languageData.put(entry.getKey(), entry.getValue());
            }
            newLanguageManager.setRawData(languageData);
            ((PowerConfigManager)newLanguageManager).save();
            if (!ranksYaml.isString("Usertags")) {
                for (String usertagKey : ranksYaml.getConfigurationSection("Usertags").getKeys(false)) {
                    usertagManager.setString("usertags." + usertagKey, ranksYaml.getString("Usertags." + usertagKey));
                }
                ((PowerConfigManager)usertagManager).save();
            }
            for (String rankName : ranksYaml.getConfigurationSection("Groups").getKeys(false)) {
                PRRank newRank = new PRRank();
                newRank.setName(rankName);
                for (String perm : new ArrayList(ranksYaml.getStringList("Groups." + rankName + ".permissions"))) {
                    newPermission = new PRPermission();
                    newPermission.setName(perm);
                    newRank.addPermission(newPermission);
                }
                newRank.setInheritances(new ArrayList<String>(ranksYaml.getStringList("Groups." + rankName + ".inheritance")));
                newRank.setPrefix(ranksYaml.getString("Groups." + rankName + ".chat.prefix"));
                newRank.setSuffix(ranksYaml.getString("Groups." + rankName + ".chat.suffix"));
                newRank.setChatcolor(ranksYaml.getString("Groups." + rankName + ".chat.chatColor"));
                newRank.setNamecolor(ranksYaml.getString("Groups." + rankName + ".chat.nameColor"));
                newRank.setBuyableRanks(new ArrayList<String>(ranksYaml.getStringList("Groups." + rankName + ".economy.buyable")));
                newRank.setBuyCost(ranksYaml.getInt("Groups." + rankName + ".economy.cost"));
                newRank.setBuyDescription(ranksYaml.getString("Groups." + rankName + ".economy.description"));
                storedRanks.add(newRank);
            }
            for (String playerUUID : playersYaml.getConfigurationSection("players").getKeys(false)) {
                PRPlayer newPlayer = new PRPlayer();
                newPlayer.setUUID(UUID.fromString(playerUUID));
                newPlayer.setName(playersYaml.getString("players." + playerUUID + ".name"));
                newPlayer.setRank(new PRPlayerRank(playersYaml.getString("players." + playerUUID + ".rank")));
                newPlayer.setPlaytime(playersYaml.getInt("players." + playerUUID + ".playtime"));
                if (playersYaml.getString("players." + playerUUID + ".usertag").length() > 0) {
                    newPlayer.addUsertag(playersYaml.getString("players." + playerUUID + ".usertag"));
                }
                for (String perm : new ArrayList(playersYaml.getStringList("players." + playerUUID + ".permissions"))) {
                    newPermission = new PRPermission();
                    newPermission.setName(perm);
                    newPlayer.addPermission(newPermission);
                }
                if (!playersYaml.isString("players." + playerUUID + ".subranks")) {
                    for (String playerSubrankName : playersYaml.getConfigurationSection("players." + playerUUID + ".subranks").getKeys(false)) {
                        newPlayer.addRank(new PRPlayerRank(playerSubrankName));
                    }
                }
                storedPlayers.add(newPlayer);
            }
            storageManager.setRanks(storedRanks);
            storageManager.setPlayers(storedPlayers);
            storageManager.saveAll();
            PowerRanks.getInstance().getLogger().warning("Finished converting data from a previous installation!");
        }
    }

    public static void updateConfigFiles() {
        YamlConfiguration tmpYamlConf;
        YamlConfiguration yamlConf;
        File tmpFile;
        File file;
        PowerRanks plugin = PowerRanks.getInstance();
        boolean updateConfigYAML = ConfigFilesUpdater.checkVersion(PowerRanks.fileLoc, "config.yml");
        boolean updateLangYAML = true;
        if (updateConfigYAML) {
            ConfigFilesUpdater.copyTmpFile("config.yml");
            file = new File(plugin.getDataFolder(), "config.yml");
            tmpFile = new File(plugin.getDataFolder() + File.separator + "tmp", "config.yml");
            yamlConf = new YamlConfiguration();
            tmpYamlConf = new YamlConfiguration();
            try {
                tmpYamlConf.load(tmpFile);
                yamlConf.load(file);
                yamlConf.set("version", null);
                if (yamlConf.isSet("plugin_hook.vault")) {
                    yamlConf.set("plugin_hook.vault_economy", (Object)yamlConf.getBoolean("plugin_hook.vault"));
                    yamlConf.set("plugin_hook.vault", null);
                }
                if (yamlConf.isSet("defaultrank")) {
                    CacheManager.configConverterSetDefaultRank(yamlConf.getString("defaultrank"));
                }
                for (String key : tmpYamlConf.getConfigurationSection("").getKeys(false)) {
                    for (String key2 : tmpYamlConf.getConfigurationSection(key).getKeys(false)) {
                        String field = key + "." + key2;
                        if (yamlConf.contains(field)) continue;
                        yamlConf.set(field, tmpYamlConf.get(field));
                    }
                }
                yamlConf.set("chat.format", (Object)yamlConf.getString("chat.format").replaceAll(subPrefixSuffixRegex, " ").replaceAll("  ", " ").trim());
                yamlConf.set("tablist_modification.format", (Object)yamlConf.getString("tablist_modification.format").replaceAll(subPrefixSuffixRegex, " ").replaceAll("  ", " ").trim());
                yamlConf.set("nametagedit.prefix", (Object)yamlConf.getString("nametagedit.prefix").replaceAll(subPrefixSuffixRegex, " ").replaceAll("  ", " ").trim());
                yamlConf.set("nametagedit.suffix", (Object)yamlConf.getString("nametagedit.suffix").replaceAll(subPrefixSuffixRegex, " ").replaceAll("  ", " ").trim());
                yamlConf.set("version", (Object)PowerRanks.getVersion().replaceAll("[a-zA-Z ]", ""));
                yamlConf.save(file);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
            ConfigFilesUpdater.deleteTmpFile("config.yml");
        }
        if (updateLangYAML) {
            ConfigFilesUpdater.copyTmpFile("lang.yml");
            file = new File(plugin.getDataFolder(), "lang.yml");
            tmpFile = new File(plugin.getDataFolder() + File.separator + "tmp", "lang.yml");
            yamlConf = new YamlConfiguration();
            tmpYamlConf = new YamlConfiguration();
            try {
                tmpYamlConf.load(tmpFile);
                yamlConf.load(file);
                yamlConf.set("version", null);
                yamlConf.set("commands.help", null);
                for (String key : tmpYamlConf.getConfigurationSection("").getKeys(true)) {
                    if (yamlConf.contains(key) || !tmpYamlConf.isString(key)) continue;
                    yamlConf.set(key, tmpYamlConf.get(key));
                }
                yamlConf.set("version", (Object)PowerRanks.getVersion().replaceAll("[a-zA-Z ]", ""));
                yamlConf.save(file);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
            ConfigFilesUpdater.deleteTmpFile("lang.yml");
        }
        if (new File(plugin.getDataFolder() + File.separator + "tmp").exists()) {
            new File(plugin.getDataFolder() + File.separator + "tmp").delete();
        }
    }

    private static void copyTmpFile(String yamlFileName) {
        PowerRanks plugin = PowerRanks.getInstance();
        File tmp_file = new File(plugin.getDataFolder() + File.separator + "tmp", yamlFileName);
        if (!tmp_file.exists()) {
            tmp_file.getParentFile().mkdirs();
        }
        plugin.copy(plugin.getResource(yamlFileName), tmp_file);
    }

    private static void deleteTmpFile(String yamlFileName) {
        PowerRanks plugin = PowerRanks.getInstance();
        File tmp_file = new File(plugin.getDataFolder() + File.separator + "tmp", yamlFileName);
        if (tmp_file.exists()) {
            tmp_file.delete();
        }
    }

    private static boolean checkVersion(String file_path, String fileName) {
        PowerRanks plugin = PowerRanks.getInstance();
        File file = new File(file_path + fileName);
        YamlConfiguration yamlConf = new YamlConfiguration();
        try {
            yamlConf.load(file);
            if (yamlConf.getString("version") == null) {
                yamlConf.set("version", (Object)PowerRanks.getVersion().replaceAll("[a-zA-Z ]", ""));
                yamlConf.save(file);
                PowerRanks.log.info("Setting up file: " + fileName);
                return !plugin.configContainsKey("updates.automatic_update_config_files") || plugin.getConfigBool("updates.automatic_update_config_files", false);
            }
            if (!yamlConf.getString("version").equalsIgnoreCase(PowerRanks.getVersion().replaceAll("[a-zA-Z ]", ""))) {
                if (!plugin.configContainsKey("updates.automatic_update_config_files") || plugin.getConfigBool("updates.automatic_update_config_files", false)) {
                    plugin.printVersionError(fileName, true);
                    return true;
                }
                plugin.printVersionError(fileName, false);
                return false;
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        return false;
    }
}

