/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.textcomponents;

import java.util.ArrayList;
import java.util.List;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.textcomponents.Page;

public class PageNavigationManager {
    private int itemsPerPage = 10;
    private String title = "PowerRanks";
    private String baseCommand;
    private List<String> items = new ArrayList<String>();
    private boolean isMonospace;
    private boolean fancyPageControls;

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBaseCommand(String baseCommand) {
        this.baseCommand = baseCommand;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public void addItem(String item) {
        this.items.add(item);
    }

    public void setMonospace(boolean isMonospace) {
        this.isMonospace = isMonospace;
    }

    public void setFancyPageControls(boolean fancyPageControls) {
        this.fancyPageControls = fancyPageControls;
    }

    public int getNumPages() {
        return (int)Math.ceil((double)this.items.size() / (double)this.itemsPerPage);
    }

    public Page getPage(int pageNum) {
        pageNum = Math.max(1, Math.min(pageNum, this.getNumPages()));
        int startIndex = (pageNum - 1) * this.itemsPerPage;
        int endIndex = Math.min(startIndex + this.itemsPerPage, this.items.size());
        List<String> pageItems = this.items.subList(startIndex, endIndex);
        boolean everyLineBeginsWithSpace = true;
        while (everyLineBeginsWithSpace) {
            for (String item : pageItems) {
                if (PowerRanks.getPowerColor().removeFormat('\u00a7', item).startsWith(" ")) continue;
                everyLineBeginsWithSpace = false;
                break;
            }
            if (!everyLineBeginsWithSpace) continue;
            if (pageItems.size() == 0) break;
            for (int i = 0; i < pageItems.size(); ++i) {
                String color = "";
                for (char c : pageItems.get(i).toCharArray()) {
                    if (c == ' ') break;
                    color = color + c;
                }
                pageItems.set(i, color + pageItems.get(i).substring(pageItems.get(i).startsWith(" ") ? 1 : 3));
            }
        }
        return new Page(pageNum, this.getNumPages(), this.title, this.baseCommand, pageItems, this.isMonospace, this.fancyPageControls);
    }
}

