/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.textcomponents;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.textcomponents.DefaultFontInfo;

public class Page {
    private int pageNum;
    private int totalPages;
    private String title;
    private String baseCommand;
    private List<String> items;
    private boolean isMonospace;
    private boolean fancyPageControls;
    private int internalTitleWidth;

    public Page(int pageNum, int totalPages, String title, String baseCommand, List<String> items, boolean isMonospace, boolean fancyPageControls) {
        this.pageNum = pageNum;
        this.totalPages = totalPages;
        this.title = title;
        this.baseCommand = baseCommand;
        this.items = items;
        this.isMonospace = isMonospace;
        this.fancyPageControls = fancyPageControls;
    }

    private String getTitle() {
        return this.title;
    }

    public List<Object> generate() {
        int nextPage = this.pageNum + 1 > this.totalPages ? this.totalPages : this.pageNum + 1;
        int previousPage = this.pageNum - 1 < 1 ? 1 : this.pageNum - 1;
        ArrayList<Object> generatedList = new ArrayList<Object>();
        int maxItemWidth = this.items.stream().map(e -> PowerRanks.getPowerColor().removeFormat('&', PowerRanks.getPowerColor().removeFormat('\u00a7', (String)e))).mapToInt(e -> this.isMonospace ? e.length() : DefaultFontInfo.getStringLength(e)).max().orElse(0);
        this.createHeader(maxItemWidth, true, previousPage, nextPage);
        generatedList.addAll(this.createHeader(maxItemWidth, false, previousPage, nextPage));
        generatedList.addAll(this.createSpacedItems(maxItemWidth));
        generatedList.addAll(this.createFooter(maxItemWidth));
        if (!this.fancyPageControls) {
            String offset = "";
            if (this.pageNum != previousPage) {
                generatedList.add("[gradient=#ffff00,#ef3300]Previous page[/gradient]&r \u00bb /" + this.baseCommand + " " + previousPage);
                while ((this.isMonospace ? ("Next page" + offset).length() : DefaultFontInfo.getStringLength("Next page" + offset)) < (this.isMonospace ? "Previous page".length() : DefaultFontInfo.getStringLength("Previous page"))) {
                    offset = offset + " ";
                }
            }
            if (this.pageNum != nextPage) {
                generatedList.add("[gradient=#ffff00,#ef3300]Next page " + offset + "[/gradient]&r\u00bb /" + this.baseCommand + " " + nextPage);
            }
        }
        Iterator iterator2 = generatedList.iterator();
        while (iterator2.hasNext()) {
            Object item;
            Object newItem = item = iterator2.next();
            if (item instanceof String) {
                newItem = PowerRanks.getPowerColor().format('&', (String)item, true, false, false);
            }
            generatedList.set(generatedList.indexOf(item), newItem);
        }
        return generatedList;
    }

    private List<String> createSpacedItems(int maxItemWidth) {
        int targetWidth = Math.max(this.internalTitleWidth, maxItemWidth);
        ArrayList<String> generatedList = new ArrayList<String>();
        for (String item : this.items) {
            String unformattedItemString = PowerRanks.getPowerColor().removeFormat('&', PowerRanks.getPowerColor().removeFormat('\u00a7', item));
            String offset = "";
            while (true) {
                double d = this.isMonospace ? (double)unformattedItemString.length() : (double)DefaultFontInfo.getStringLength(unformattedItemString + " ") - 0.5;
                if (!(d < (double)targetWidth)) break;
                offset = offset + " ";
                unformattedItemString = unformattedItemString + " ";
            }
            generatedList.add("#01b0fb\u2502 " + item + offset + " #f50be5\u2502");
        }
        return generatedList;
    }

    private List<Object> createHeader(int maxItemWidth, boolean generateTitleWidth, int previousPage, int nextPage) {
        int targetWidth = Math.max(this.internalTitleWidth, maxItemWidth);
        ArrayList<Object> generatedList = new ArrayList<Object>();
        String title = "#01b0fb\u2502 [gradient=#ffff00,#ef3300]" + this.getTitle() + "[/gradient] #7E63DE\u2502";
        String unformattedTitle = PowerRanks.getPowerColor().removeFormat('&', PowerRanks.getPowerColor().removeFormat('\u00a7', title));
        int titleWidth = this.isMonospace ? unformattedTitle.length() : DefaultFontInfo.getStringLength(unformattedTitle);
        BaseComponent[] pageInfo = "";
        String baseText = "";
        if (!this.fancyPageControls) {
            pageInfo = this.totalPages > 1 ? "#7E63DE\u2502 [gradient=#ffff00,#ef3300]" + this.pageNum + "/" + this.totalPages + "[/gradient] #f50be5\u2502" : "";
        } else {
            String string = baseText = this.totalPages > 1 ? "#7E63DE\u2502 &r\u25c0[gradient=#ffff00,#ef3300]" + this.pageNum + "/" + this.totalPages + "[/gradient]&r\u25b6 #f50be5\u2502" : "";
            if (this.totalPages > 1) {
                pageInfo = new ComponentBuilder();
                TextComponent leftArrow = new TextComponent("\u25c0");
                TextComponent rightArrow = new TextComponent("\u25b6");
                leftArrow.setColor(ChatColor.WHITE);
                rightArrow.setColor(ChatColor.WHITE);
                leftArrow.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("Previous page")}));
                rightArrow.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("Next page")}));
                leftArrow.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + this.baseCommand + " " + previousPage));
                rightArrow.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + this.baseCommand + " " + nextPage));
                ((ComponentBuilder)pageInfo).appendLegacy(PowerRanks.getPowerColor().format('&', "#7E63DE\u2502 ", true, false, false));
                ((ComponentBuilder)pageInfo).append((BaseComponent)leftArrow);
                ((ComponentBuilder)pageInfo).appendLegacy(PowerRanks.getPowerColor().format('&', "[gradient=#ffff00,#ef3300]" + this.pageNum + "/" + this.totalPages + "[/gradient]", true, false, false));
                ((ComponentBuilder)pageInfo).append((BaseComponent)rightArrow);
                ((ComponentBuilder)pageInfo).appendLegacy(PowerRanks.getPowerColor().format('&', " #f50be5\u2502", true, false, false));
                pageInfo = ((ComponentBuilder)pageInfo).create();
            }
        }
        String unformattedPageInfo = PowerRanks.getPowerColor().removeFormat('&', PowerRanks.getPowerColor().removeFormat('\u00a7', (String)(pageInfo instanceof String && pageInfo != null ? pageInfo : baseText)));
        String pageInfoOffset = "";
        while (true) {
            double d = this.isMonospace ? (unformattedTitle + pageInfoOffset + unformattedPageInfo).length() : DefaultFontInfo.getStringLength(unformattedTitle + pageInfoOffset + unformattedPageInfo);
            double d2 = (double)targetWidth - 0.5;
            int n = this.isMonospace ? "\u2502  \u2502".length() : DefaultFontInfo.getStringLength("\u2502 \u2502");
            if (!(d < d2 + (double)n)) break;
            pageInfoOffset = pageInfoOffset + " ";
        }
        if (generateTitleWidth) {
            this.internalTitleWidth = this.isMonospace ? (unformattedTitle + pageInfoOffset + unformattedPageInfo).length() : DefaultFontInfo.getStringLength(unformattedTitle + pageInfoOffset + unformattedPageInfo);
            return null;
        }
        String top = "\u250c";
        String bottom = "\u251c";
        while ((this.isMonospace ? top.length() + 1 : DefaultFontInfo.getStringLength(top + "\u2500\u2510")) < titleWidth) {
            top = top + "\u2500";
            bottom = bottom + "\u2500";
        }
        top = top + "\u2510";
        bottom = bottom + "\u2534";
        if (this.totalPages > 1) {
            top = top + pageInfoOffset + "\u250c";
            while ((this.isMonospace ? top.length() - 3 : DefaultFontInfo.getStringLength(top + "\u2510")) < targetWidth) {
                top = top + "\u2500";
            }
            top = top + "\u2510";
            while ((this.isMonospace ? bottom.length() : DefaultFontInfo.getStringLength(bottom)) < (this.isMonospace ? (unformattedTitle + pageInfoOffset).length() : DefaultFontInfo.getStringLength(unformattedTitle + pageInfoOffset) - DefaultFontInfo.getStringLength("\u2500\u2510"))) {
                bottom = bottom + "\u2500";
            }
            bottom = bottom + "\u2534";
        }
        while ((this.isMonospace ? bottom.length() - 3 : DefaultFontInfo.getStringLength(bottom + "\u2510")) < targetWidth) {
            bottom = bottom + "\u2500";
        }
        bottom = bottom + (this.totalPages > 1 ? "\u2524" : "\u2510");
        generatedList.add("[gradient=#01b0fb,#f50be5]" + top + "[/gradient]");
        if (pageInfo instanceof String) {
            generatedList.add(title + pageInfoOffset + pageInfo);
        } else {
            ComponentBuilder titleComponent = new ComponentBuilder();
            titleComponent.appendLegacy(PowerRanks.getPowerColor().format('&', title, true, false, false));
            titleComponent.append(pageInfoOffset);
            titleComponent.append(pageInfo);
            generatedList.add(titleComponent.create());
        }
        generatedList.add("[gradient=#01b0fb,#f50be5]" + bottom + "[/gradient]");
        return generatedList;
    }

    private List<String> createFooter(int maxItemWidth) {
        int targetWidth = Math.max(this.internalTitleWidth, maxItemWidth);
        ArrayList<String> generatedList = new ArrayList<String>();
        String bottom = "\u2514";
        while ((this.isMonospace ? bottom.length() - 3 : DefaultFontInfo.getStringLength(bottom + "\u2510")) < targetWidth) {
            bottom = bottom + "\u2500";
        }
        bottom = bottom + "\u2518";
        generatedList.add("[gradient=#01b0fb,#f50be5]" + bottom + "[/gradient]");
        return generatedList;
    }
}

