/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.external;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import net.milkbowl.vault.permission.Permission;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.data.PowerRanksVerbose;
import nl.svenar.powerranks.bukkit.data.Users;
import nl.svenar.powerranks.common.structure.PRPlayerRank;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class PowerRanksVaultPermission
extends Permission {
    final PowerRanks plugin;
    final Users users;
    private boolean playerHasErrorQueueOffline = false;

    PowerRanksVaultPermission(PowerRanks plugin) {
        this.plugin = plugin;
        this.users = new Users(plugin);
    }

    public String getName() {
        return this.plugin.getName();
    }

    public boolean isEnabled() {
        return this.plugin.isEnabled();
    }

    public boolean hasSuperPermsCompat() {
        return true;
    }

    public String[] getGroups() {
        ArrayList<String> ranks = new ArrayList<String>();
        for (PRRank rank : CacheManager.getRanks()) {
            ranks.add(rank.getName());
        }
        return (String[])Iterables.toArray(ranks, String.class);
    }

    public boolean hasGroupSupport() {
        return true;
    }

    String getActiveWorld(OfflinePlayer player) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.getActiveWorld(...)", "Called, player: " + player.getName());
        Player p = player.getPlayer();
        return p != null ? p.getWorld().getName() : null;
    }

    public boolean groupHas(String world, String name, String permission) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.groupHas(...)", "Called");
        return CacheManager.getRank(name).getPermission(permission) != null;
    }

    public boolean groupAdd(String world, String name, String permission) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.groupAdd(...)", "Called");
        return false;
    }

    public boolean groupRemove(String world, String name, String permission) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.groupRemove(...)", "Called");
        return false;
    }

    public boolean playerHas(String world, OfflinePlayer player, String permission) {
        if (player.isOnline()) {
            boolean hasPermission = ((Player)player).hasPermission(permission);
            PowerRanksVerbose.log("PowerRanksVaultPermission.playerHas(...)", "Checking player '" + player.getName() + "', permission: " + permission + ", hasPermission: " + hasPermission);
            return hasPermission;
        }
        if (!this.playerHasErrorQueueOffline) {
            this.playerHasErrorQueueOffline = true;
            PowerRanksVerbose.log("PowerRanksVaultPermission.playerHas(...)", "===----------WARNING----------===");
            PowerRanksVerbose.log("PowerRanksVaultPermission.playerHas(...)", "PowerRanksVaultPermission.playerHas(...)");
            PowerRanksVerbose.log("PowerRanksVaultPermission.playerHas(...)", "The UUID of player '" + player.getName() + "' is offline and permissions can't be checked!");
            PowerRanksVerbose.log("PowerRanksVaultPermission.playerHas(...)", "===---------------------------===");
            BukkitScheduler scheduler = this.plugin.getServer().getScheduler();
            scheduler.scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    PowerRanksVaultPermission.this.playerHasErrorQueueOffline = false;
                }
            }, 20L);
        }
        return false;
    }

    public boolean playerAdd(String world, OfflinePlayer player, String permission) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.playerAdd(...)", "Called, player: " + player.getName());
        return false;
    }

    public boolean playerAddTransient(OfflinePlayer player, String permission) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.playerAddTransient(...)", "Called, player: " + player.getName());
        return this.playerAddTransient(this.getActiveWorld(player), player, permission);
    }

    public boolean playerAddTransient(Player player, String permission) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.playerAddTransient(...)", "Called, player: " + player.getName());
        return this.playerAddTransient(player.getWorld().getName(), player, permission);
    }

    public boolean playerAddTransient(String worldName, OfflinePlayer player, String permission) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.playerAddTransient(...)", "Called, player: " + player.getName());
        return false;
    }

    public boolean playerRemoveTransient(String worldName, OfflinePlayer player, String permission) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.playerRemoveTransient(...)", "Called, player: " + player.getName());
        return false;
    }

    public boolean playerRemove(String world, OfflinePlayer player, String permission) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.playerRemove(...)", "Called, player: " + player.getName());
        return false;
    }

    public boolean playerRemoveTransient(Player player, String permission) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.playerRemoveTransient(...)", "Called, player: " + player.getName());
        return this.playerRemoveTransient(player.getWorld().getName(), player, permission);
    }

    public boolean playerRemoveTransient(OfflinePlayer player, String permission) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.playerRemoveTransient(...)", "Called, player: " + player.getName());
        return this.playerRemoveTransient(this.getActiveWorld(player), player, permission);
    }

    public boolean playerInGroup(String world, OfflinePlayer player, String group) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.playerInGroup(...)", "Called, player: " + player.getName());
        return false;
    }

    public boolean playerAddGroup(String world, OfflinePlayer player, String group) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.playerAddGroup(...)", "Called, player: " + player.getName());
        return false;
    }

    public boolean playerRemoveGroup(String world, OfflinePlayer player, String group) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.playerRemoveGroup(...)", "Called, player: " + player.getName());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String[] getPlayerGroups(String world, OfflinePlayer player) {
        void var6_10;
        PowerRanksVerbose.log("PowerRanksVaultPermission.getPlayerGroups(...)", "Called, player: " + player.getName());
        ArrayList<String> groups2 = new ArrayList<String>();
        ArrayList<String> ranks = new ArrayList<String>();
        for (PRPlayerRank pRPlayerRank : CacheManager.getPlayer(player.getUniqueId().toString()).getRanks()) {
            ranks.add(pRPlayerRank.getName());
        }
        if (ranks != null) {
            for (String string : ranks) {
                groups2.add(string);
            }
        }
        String[] output = new String[groups2.size()];
        boolean bl = false;
        while (var6_10 < groups2.size()) {
            output[var6_10] = (String)groups2.get((int)var6_10);
            ++var6_10;
        }
        return output;
    }

    public String getPrimaryGroup(String world, OfflinePlayer player) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.getPrimaryGroup(...)", "Called, player: " + player.getName());
        ArrayList<PRRank> ranks = new ArrayList<PRRank>();
        for (PRPlayerRank playerRank : CacheManager.getPlayer(player.getUniqueId().toString()).getRanks()) {
            PRRank rank = CacheManager.getRank(playerRank.getName());
            if (rank == null) continue;
            ranks.add(rank);
        }
        PRUtil.sortRanksByWeight(ranks);
        PRUtil.reverseRanks(ranks);
        return ranks.size() > 0 ? ((PRRank)ranks.get(0)).getName() : "";
    }

    private OfflinePlayer playerFromName(String name) {
        PowerRanksVerbose.log("PowerRanksVaultPermission.playerFromName(...)", "Called, player: " + name);
        return this.plugin.getServer().getOfflinePlayer(name);
    }

    public boolean playerHas(String world, String name, String permission) {
        return this.playerHas(world, this.playerFromName(name), permission);
    }

    public boolean playerAdd(String world, String name, String permission) {
        return this.playerAdd(world, this.playerFromName(name), permission);
    }

    public boolean playerRemove(String world, String name, String permission) {
        return this.playerRemove(world, this.playerFromName(name), permission);
    }

    public boolean playerInGroup(String world, String player, String group) {
        return this.playerInGroup(world, this.playerFromName(player), group);
    }

    public boolean playerAddGroup(String world, String player, String group) {
        return this.playerAddGroup(world, this.playerFromName(player), group);
    }

    public boolean playerRemoveGroup(String world, String player, String group) {
        return this.playerRemoveGroup(world, this.playerFromName(player), group);
    }

    public String[] getPlayerGroups(String world, String player) {
        return this.getPlayerGroups(world, this.playerFromName(player));
    }

    public String getPrimaryGroup(String world, String player) {
        return this.getPrimaryGroup(world, this.playerFromName(player));
    }
}

