/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.external;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.data.Users;
import nl.svenar.powerranks.common.structure.PRPlayerRank;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class PowerRanksExpansion
extends PlaceholderExpansion {
    private PowerRanks plugin;

    public PowerRanksExpansion(PowerRanks plugin) {
        this.plugin = plugin;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getIdentifier() {
        return "powerranks";
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        boolean format_colors = PowerRanks.getConfigManager().getBool("placeholderapi.inject_powerranks_color", false);
        if (player == null) {
            return "";
        }
        Users users = new Users(null);
        if (identifier.equals("rank")) {
            return users.getPrimaryRank(player);
        }
        if (identifier.equals("prefix")) {
            if (format_colors) {
                return PowerRanks.chatColor(users.getPrefix(player), true) + ChatColor.RESET;
            }
            return users.getPrefix(player) + ChatColor.RESET;
        }
        if (identifier.equals("suffix")) {
            if (format_colors) {
                return ChatColor.RESET + PowerRanks.chatColor(users.getSuffix(player), true);
            }
            return ChatColor.RESET + users.getSuffix(player);
        }
        if (identifier.equals("subrankprefix")) {
            List<PRRank> playerRanks = this.getPlayerRanksSorted(player);
            ArrayList<String> prefixes = new ArrayList<String>();
            for (PRRank rank : playerRanks) {
                if (format_colors) {
                    prefixes.add(PowerRanks.chatColor(rank.getPrefix(), true) + ChatColor.RESET);
                    continue;
                }
                prefixes.add(rank.getPrefix() + ChatColor.RESET);
            }
            return String.join((CharSequence)PowerRanks.getInstance().getConfigString("placeholderapi.multi_rank_separator", " "), prefixes);
        }
        if (identifier.equals("subranksuffix")) {
            List<PRRank> playerRanks = this.getPlayerRanksSorted(player);
            ArrayList<String> suffixes = new ArrayList<String>();
            for (PRRank rank : playerRanks) {
                if (format_colors) {
                    suffixes.add(ChatColor.RESET + PowerRanks.chatColor(rank.getSuffix(), true));
                    continue;
                }
                suffixes.add(ChatColor.RESET + rank.getSuffix());
            }
            return String.join((CharSequence)PowerRanks.getInstance().getConfigString("placeholderapi.multi_rank_separator", " "), suffixes);
        }
        if (identifier.equals("primary_rank")) {
            List<PRRank> playerRanks = this.getPlayerRanksSorted(player);
            return playerRanks.size() > 0 ? playerRanks.get(0).getName() : "";
        }
        if (identifier.equals("ranks")) {
            ArrayList<String> playerRankNames = new ArrayList<String>();
            List<PRRank> playerRanks = this.getPlayerRanksSorted(player);
            for (PRRank rank : playerRanks) {
                playerRankNames.add(rank.getName());
            }
            return String.join((CharSequence)PowerRanks.getInstance().getConfigString("placeholderapi.multi_rank_separator", " "), playerRankNames);
        }
        if (identifier.equals("primary_prefix")) {
            List<PRRank> playerRanks = this.getPlayerRanksSorted(player);
            return playerRanks.size() > 0 ? (format_colors ? PowerRanks.chatColor(playerRanks.get(0).getPrefix(), true) : playerRanks.get(0).getPrefix()) + ChatColor.RESET : "";
        }
        if (identifier.equals("primary_suffix")) {
            List<PRRank> playerRanks = this.getPlayerRanksSorted(player);
            return playerRanks.size() > 0 ? ChatColor.RESET + (format_colors ? PowerRanks.chatColor(playerRanks.get(0).getSuffix(), true) : playerRanks.get(0).getSuffix()) : "";
        }
        if (identifier.equals("prefixes")) {
            List<PRRank> playerRanks = this.getPlayerRanksSorted(player);
            ArrayList<String> prefixes = new ArrayList<String>();
            for (PRRank rank : playerRanks) {
                if (format_colors) {
                    prefixes.add(PowerRanks.chatColor(rank.getPrefix(), true) + ChatColor.RESET);
                    continue;
                }
                prefixes.add(rank.getPrefix() + ChatColor.RESET);
            }
            return String.join((CharSequence)PowerRanks.getInstance().getConfigString("placeholderapi.multi_rank_separator", " "), prefixes);
        }
        if (identifier.equals("suffixes")) {
            List<PRRank> playerRanks = this.getPlayerRanksSorted(player);
            ArrayList<String> suffixes = new ArrayList<String>();
            for (PRRank rank : playerRanks) {
                if (format_colors) {
                    suffixes.add(ChatColor.RESET + PowerRanks.chatColor(rank.getSuffix(), true));
                    continue;
                }
                suffixes.add(ChatColor.RESET + rank.getSuffix());
            }
            return String.join((CharSequence)PowerRanks.getInstance().getConfigString("placeholderapi.multi_rank_separator", " "), suffixes);
        }
        if (identifier.equals("chatcolor")) {
            List<PRRank> playerRanks = this.getPlayerRanksSorted(player);
            return playerRanks.size() > 0 ? (format_colors ? PowerRanks.chatColor(playerRanks.get(0).getChatcolor(), true) : playerRanks.get(0).getChatcolor()) : "";
        }
        if (identifier.equals("namecolor")) {
            List<PRRank> playerRanks = this.getPlayerRanksSorted(player);
            return playerRanks.size() > 0 ? (format_colors ? PowerRanks.chatColor(playerRanks.get(0).getNamecolor(), true) : playerRanks.get(0).getNamecolor()) : "";
        }
        if (identifier.equals("usertag")) {
            return format_colors ? PowerRanks.chatColor(users.getUserTagValue(player), true) : users.getUserTagValue(player);
        }
        if (identifier.equals("world")) {
            return player.getWorld().getName();
        }
        if (identifier.equals("playtime")) {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
            df.setTimeZone(tz);
            String time = df.format(new Date(CacheManager.getPlayer(player.getUniqueId().toString()).getPlaytime() * 1000L));
            return time;
        }
        return null;
    }

    private List<PRRank> getPlayerRanksSorted(Player player) {
        ArrayList<PRRank> playerRanks = new ArrayList<PRRank>();
        for (PRPlayerRank playerRank : CacheManager.getPlayer(player.getUniqueId().toString()).getRanks()) {
            PRRank rank = CacheManager.getRank(playerRank.getName());
            if (rank == null) continue;
            playerRanks.add(rank);
        }
        PRUtil.sortRanksByWeight(playerRanks);
        PRUtil.reverseRanks(playerRanks);
        return playerRanks;
    }
}

