/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.events;

import java.io.File;
import java.util.Date;
import java.util.Map;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.addons.PowerRanksAddon;
import nl.svenar.powerranks.bukkit.addons.PowerRanksPlayer;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.data.PowerRanksVerbose;
import nl.svenar.powerranks.common.structure.PRPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class OnJoin
implements Listener {
    PowerRanks plugin;

    public OnJoin(PowerRanks plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=false)
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        OnJoin.handleJoin(this.plugin, player);
        this.plugin.getTablistManager().onPlayerJoin(player);
        for (Map.Entry<File, PowerRanksAddon> prAddon : this.plugin.addonsManager.addonClasses.entrySet()) {
            PowerRanksPlayer prPlayer = new PowerRanksPlayer(this.plugin, player);
            prAddon.getValue().onPlayerJoin(prPlayer);
            if (prAddon.getValue().onPlayerJoinMessage(prPlayer)) continue;
            e.setJoinMessage("");
        }
    }

    @EventHandler(ignoreCancelled=false)
    public void onPlayerLeave(PlayerQuitEvent e) {
        long leave_time;
        Player player = e.getPlayer();
        OnJoin.validatePlayerData(player);
        this.plugin.getTablistManager().onPlayerLeave(player);
        this.plugin.playerPermissionAttachment.remove(player.getUniqueId());
        long join_time = leave_time = new Date().getTime();
        try {
            join_time = this.plugin.playerPlayTimeCache.get(player.getUniqueId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.plugin.updatePlaytime(player, join_time, leave_time, true);
        for (Map.Entry<File, PowerRanksAddon> prAddon : this.plugin.addonsManager.addonClasses.entrySet()) {
            PowerRanksPlayer prPlayer = new PowerRanksPlayer(this.plugin, player);
            prAddon.getValue().onPlayerLeave(prPlayer);
        }
    }

    public static void handleJoin(PowerRanks plugin, Player player) {
        OnJoin.validatePlayerData(player);
        plugin.playerInjectPermissible(player);
        PRPlayer prPlayer = CacheManager.getPlayer(player);
        prPlayer.setName(player.getName());
        prPlayer.updateTags(player.getLocation().getWorld().getName());
        plugin.updateTablistName(player);
        plugin.getTablistManager().updateSorting(player);
        long time = new Date().getTime();
        plugin.playerPlayTimeCache.put(player.getUniqueId(), time);
        if (PowerRanks.getConfigManager().getBool("general.disable-op", false) && player.isOp()) {
            player.setOp(false);
        }
    }

    private static void validatePlayerData(Player player) {
        boolean exists = CacheManager.getPlayer(player.getUniqueId().toString()) != null;
        PowerRanksVerbose.log("onJoin", "Player " + player.getName() + " (" + player.getUniqueId().toString() + " " + (exists ? "exists" : "does not exist"));
        if (!exists) {
            CacheManager.createPlayer(player);
        }
    }
}

