/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.events;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.data.Users;
import nl.svenar.powerranks.bukkit.external.VaultHook;
import nl.svenar.powerranks.bukkit.gui.GUI;
import nl.svenar.powerranks.bukkit.gui.GUIPage;
import nl.svenar.powerranks.bukkit.util.Util;
import nl.svenar.powerranks.common.structure.PRPlayerRank;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class OnInteract
implements Listener {
    PowerRanks plugin;

    public OnInteract(PowerRanks plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            Sign sign;
            Player player = event.getPlayer();
            Block block = event.getClickedBlock();
            if (block.getState() instanceof Sign && Util.isPowerRanksSign(this.plugin, sign = (Sign)block.getState())) {
                this.handlePowerRanksSign(sign, player);
            }
        }
    }

    private void handlePowerRanksSign(Sign sign, Player player) {
        boolean sign_error;
        String sign_argument2;
        String sign_argument;
        String sign_command;
        Users users = new Users(this.plugin);
        try {
            Class.forName("org.bukkit.block.sign.Side");
            Side signSide = Side.FRONT;
            sign_command = sign.getSide(signSide).getLine(1);
            if (sign_command.length() == 0) {
                signSide = Side.BACK;
                sign_command = sign.getSide(signSide).getLine(1);
            }
            sign_argument = sign.getSide(signSide).getLine(2);
            sign_argument2 = sign.getSide(signSide).getLine(3);
            sign_error = sign.getSide(signSide).getLine(3).toLowerCase().contains("error");
        }
        catch (ClassNotFoundException e) {
            sign_command = sign.getLine(1);
            sign_argument = sign.getLine(2);
            sign_argument2 = sign.getLine(3);
            sign_error = sign.getLine(3).toLowerCase().contains("error");
        }
        if (!sign_error) {
            PRRank rank;
            if (sign_command.equalsIgnoreCase("setrank")) {
                if (player.hasPermission("powerranks.signs.setrank")) {
                    rank = CacheManager.getRank(users.getRankIgnoreCase(sign_argument));
                    if (rank != null) {
                        PRPlayerRank playerRank = new PRPlayerRank(rank.getName());
                        CacheManager.getPlayer(player.getUniqueId().toString()).setRank(playerRank);
                        player.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands.setrank.success-receiver"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)player.getName()).put((Object)"rank", (Object)rank.getName()).build(), '[', ']'));
                    }
                } else {
                    player.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("general.no-permission"));
                }
            } else if (sign_command.equalsIgnoreCase("addrank")) {
                if (player.hasPermission("powerranks.signs.setrank")) {
                    rank = CacheManager.getRank(users.getRankIgnoreCase(sign_argument));
                    if (rank != null) {
                        PRPlayerRank playerRank = new PRPlayerRank(rank.getName());
                        CacheManager.getPlayer(player.getUniqueId().toString()).addRank(playerRank);
                        player.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands.setrank.success-receiver"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)player.getName()).put((Object)"rank", (Object)rank.getName()).build(), '[', ']'));
                    }
                } else {
                    player.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("general.no-permission"));
                }
            } else if (sign_command.equalsIgnoreCase("checkrank")) {
                if (player.hasPermission("powerranks.signs.checkrank")) {
                    ArrayList<String> playerRanks = new ArrayList<String>();
                    for (PRPlayerRank rank2 : CacheManager.getPlayer(player.getUniqueId().toString()).getRanks()) {
                        playerRanks.add(rank2.getName());
                    }
                    if (playerRanks.size() > 0) {
                        player.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands.checkrank.success-self"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)player.getName()).put((Object)"ranks", (Object)String.join((CharSequence)", ", playerRanks)).build(), '[', ']'));
                    } else {
                        player.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands.checkrank.success-self-none"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)player.getName()).build(), '[', ']'));
                    }
                } else {
                    player.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("general.no-permission"));
                }
            } else if (sign_command.equalsIgnoreCase("usertag")) {
                if (player.hasPermission("powerranks.signs.usertag")) {
                    if (users.setUserTag(player, sign_argument)) {
                        if (sign_argument.length() > 0) {
                            player.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands.setusertag.success"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)player.getName()).put((Object)"usertag", (Object)sign_argument).build(), '[', ']'));
                        } else {
                            player.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands.clearusertag.success"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)player.getName()).put((Object)"usertag", (Object)sign_argument).build(), '[', ']'));
                        }
                    } else {
                        player.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands.setusertag.failed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)player.getName()).put((Object)"usertag", (Object)sign_argument).build(), '[', ']'));
                    }
                } else {
                    player.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("general.no-permission"));
                }
            } else if (sign_command.equalsIgnoreCase("rankup")) {
                if (player.hasPermission("powerranks.signs.rankup")) {
                    if (sign_argument.length() == 0) {
                        GUI.openGUI(player, GUIPage.GUI_PAGE_ID.RANKUP);
                    } else if (PowerRanks.vaultEconomyEnabled) {
                        if (sign_argument2.length() > 0) {
                            double player_balance;
                            int cost = Integer.parseInt(sign_argument2);
                            double d = player_balance = VaultHook.getVaultEconomy() != null ? VaultHook.getVaultEconomy().getBalance((OfflinePlayer)player) : 0.0;
                            if (cost >= 0 && player_balance >= (double)cost) {
                                VaultHook.getVaultEconomy().withdrawPlayer((OfflinePlayer)player, (double)cost);
                                PRRank rank3 = CacheManager.getRank(users.getRankIgnoreCase(sign_argument));
                                if (rank3 != null && rank3 != null) {
                                    PRPlayerRank playerRank = new PRPlayerRank(rank3.getName());
                                    CacheManager.getPlayer(player.getUniqueId().toString()).addRank(playerRank);
                                    player.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands.setrank.success-receiver"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)player.getName()).put((Object)"rank", (Object)rank3.getName()).build(), '[', ']'));
                                }
                                player.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands.buyrank.success-buy"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)player.getName()).put((Object)"rank", (Object)sign_argument).build(), '[', ']'));
                            } else {
                                player.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands.buyrank.failed-buy-not-enough-money"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)player.getName()).put((Object)"rank", (Object)sign_argument).build(), '[', ']'));
                            }
                        } else {
                            player.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands.buyrank.failed-buy-not-enough-money"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)player.getName()).put((Object)"rank", (Object)sign_argument).build(), '[', ']'));
                        }
                    } else {
                        player.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands.buyrank.buy-not-available"));
                    }
                } else {
                    player.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("general.no-permission"));
                }
            } else if (player.hasPermission("powerranks.signs.admin")) {
                player.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("messages.signs.unknown-command"));
            }
        }
    }
}

