/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.events;

import java.io.File;
import java.util.Map;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.addons.PowerRanksAddon;
import nl.svenar.powerranks.bukkit.addons.PowerRanksPlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.MoistureChangeEvent;

public class OnBlockChange
implements Listener {
    PowerRanks m;

    public OnBlockChange(PowerRanks m) {
        this.m = m;
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        Player player = e.getPlayer();
        Block block = e.getBlock();
        e.setCancelled(this.handleEvent(player, block, PowerRanksAddon.BlockChangeCause.BREAK));
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent e) {
        Player player = e.getPlayer();
        Block block = e.getBlock();
        e.setCancelled(this.handleEvent(player, block, PowerRanksAddon.BlockChangeCause.PLACE));
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockMoistureChange(MoistureChangeEvent e) {
        Block block = e.getBlock();
        e.setCancelled(this.handleEvent(null, block, PowerRanksAddon.BlockChangeCause.PLACE));
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockFertilize(BlockFertilizeEvent e) {
        Player player = e.getPlayer();
        Block block = e.getBlock();
        e.setCancelled(this.handleEvent(player, block, PowerRanksAddon.BlockChangeCause.PLACE));
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockGrow(BlockGrowEvent e) {
        Block block = e.getBlock();
        e.setCancelled(this.handleEvent(null, block, PowerRanksAddon.BlockChangeCause.PLACE));
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent e) {
        Player player = e.getPlayer();
        Block block = e.getBlock();
        e.setCancelled(this.handleEvent(player, block, PowerRanksAddon.BlockChangeCause.PLACE));
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent e) {
        Block block = e.getBlock();
        e.setCancelled(this.handleEvent(null, block, PowerRanksAddon.BlockChangeCause.PLACE));
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent e) {
        Block block = e.getBlock();
        e.setCancelled(this.handleEvent(null, block, PowerRanksAddon.BlockChangeCause.BURN));
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockRedstoneChange(BlockFertilizeEvent e) {
        Player player = e.getPlayer();
        Block block = e.getBlock();
        e.setCancelled(this.handleEvent(player, block, PowerRanksAddon.BlockChangeCause.PLACE));
    }

    public boolean handleEvent(Player player, Block block, PowerRanksAddon.BlockChangeCause blockChangeCause) {
        boolean cancelled = false;
        try {
            for (Map.Entry<File, PowerRanksAddon> prAddon : this.m.addonsManager.addonClasses.entrySet()) {
                PowerRanksPlayer prPlayer = new PowerRanksPlayer(this.m, player);
                if (!prAddon.getValue().onBlockChange(prPlayer, block, blockChangeCause)) continue;
                cancelled = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cancelled;
    }
}

