/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.common.structure.PRPermission;
import nl.svenar.powerranks.common.structure.PRPlayer;
import nl.svenar.powerranks.common.structure.PRPlayerRank;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class Users
implements Listener {
    PowerRanks m;

    public Users(PowerRanks m) {
        this.m = m;
    }

    public String getPrimaryRank(Player player) {
        if (player == null) {
            return "";
        }
        ArrayList<String> ranknames = new ArrayList<String>();
        for (PRPlayerRank playerRank : CacheManager.getPlayer(player.getUniqueId().toString()).getRanks()) {
            ranknames.add(playerRank.getName());
        }
        ArrayList<PRRank> playerRanks = new ArrayList<PRRank>();
        for (String rankname : ranknames) {
            PRRank rank = CacheManager.getRank(rankname);
            if (rank == null) continue;
            playerRanks.add(rank);
        }
        PRUtil.sortRanksByWeight(playerRanks);
        PRUtil.reverseRanks(playerRanks);
        return playerRanks.size() > 0 ? ((PRRank)playerRanks.get(0)).getName() : "";
    }

    public List<PRRank> getGroups() {
        return CacheManager.getRanks();
    }

    public boolean addPermission(String rank, String permission, boolean allowed) {
        if (permission.contains("/") || permission.contains(":")) {
            return false;
        }
        try {
            if (!rank.equals("*")) {
                ArrayList<PRPermission> list = CacheManager.getRank(rank).getPermissions();
                boolean contains = false;
                for (PRPermission prPermission : list) {
                    if (!prPermission.getName().equals(permission)) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    PRPermission newPermission = new PRPermission();
                    newPermission.setName(permission);
                    newPermission.setValue(allowed);
                    CacheManager.getRank(rank).addPermission(newPermission);
                }
                this.m.updatePlayersWithRank(this, rank);
                return true;
            }
            for (PRRank r : this.getGroups()) {
                ArrayList<PRPermission> list = r.getPermissions();
                boolean contains = false;
                for (PRPermission prPermission : list) {
                    if (!prPermission.getName().equals(permission)) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                PRPermission newPermission = new PRPermission();
                newPermission.setName(permission);
                newPermission.setValue(allowed);
                r.addPermission(newPermission);
                this.m.updatePlayersWithRank(this, r.getName());
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean removePermission(String rank, String permission) {
        block7: {
            try {
                if (!rank.equals("*")) {
                    ArrayList<PRPermission> list = CacheManager.getRank(rank).getPermissions();
                    PRPermission targetPermission = null;
                    for (PRPermission prPermission : list) {
                        if (!prPermission.getName().equals(permission)) continue;
                        targetPermission = prPermission;
                        break;
                    }
                    if (targetPermission != null) {
                        CacheManager.getRank(rank).removePermission(targetPermission);
                        this.m.updatePlayersWithRank(this, rank);
                        return true;
                    }
                    break block7;
                }
                for (PRRank r : this.getGroups()) {
                    ArrayList<PRPermission> list = r.getPermissions();
                    PRPermission targetPermission = null;
                    for (PRPermission prPermission : list) {
                        if (!prPermission.getName().equals(permission)) continue;
                        targetPermission = prPermission;
                        break;
                    }
                    if (targetPermission == null) continue;
                    r.removePermission(targetPermission);
                    this.m.updatePlayersWithRank(this, r.getName());
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean addInheritance(String rank, String inheritance) {
        try {
            if (CacheManager.getRank(rank) != null) {
                CacheManager.getRank(rank).addInheritance(inheritance);
                this.m.updatePlayersWithRank(this, rank);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean setPrefix(String rank, String prefix) {
        try {
            if (CacheManager.getRank(rank) != null) {
                CacheManager.getRank(rank).setPrefix(prefix);
                this.m.updatePlayersWithRank(this, rank);
                this.m.updatePlayersTABlistWithRank(this, rank);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean setSuffix(String rank, String suffix) {
        try {
            if (CacheManager.getRank(rank) != null) {
                CacheManager.getRank(rank).setSuffix(suffix);
                this.m.updatePlayersWithRank(this, rank);
                this.m.updatePlayersTABlistWithRank(this, rank);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean setChatColor(String rank, String color) {
        try {
            if (CacheManager.getRank(rank) != null) {
                CacheManager.getRank(rank).setChatcolor(color);
                this.m.updatePlayersWithRank(this, rank);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean setNameColor(String rank, String color) {
        try {
            if (CacheManager.getRank(rank) != null) {
                CacheManager.getRank(rank).setNamecolor(color);
                this.m.updatePlayersWithRank(this, rank);
                this.m.updatePlayersTABlistWithRank(this, rank);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean removeInheritance(String rank, String inheritance) {
        try {
            if (CacheManager.getRank(rank) != null) {
                CacheManager.getRank(rank).removeInheritance(inheritance);
                this.m.updatePlayersWithRank(this, rank);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean createRank(String rankName) {
        try {
            if (CacheManager.getRank(rankName) == null) {
                PRRank rank = new PRRank();
                rank.setName(rankName);
                rank.setPrefix("[&7" + rankName + "&r]");
                CacheManager.addRank(rank);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean deleteRank(String rankToDelete) {
        if (CacheManager.getRank(rankToDelete) == null) {
            return false;
        }
        for (PRPlayer prPlayer : CacheManager.getPlayers()) {
            ArrayList<String> ranknames = new ArrayList<String>();
            for (PRPlayerRank playerRank : prPlayer.getRanks()) {
                ranknames.add(playerRank.getName());
            }
            ArrayList<PRRank> ranks = new ArrayList<PRRank>();
            for (String rankname : ranknames) {
                PRRank rank = CacheManager.getRank(rankname);
                if (rank == null) continue;
                ranks.add(rank);
            }
            for (PRRank rank : ranks) {
                if (rank != CacheManager.getRank(rankToDelete)) continue;
                PRPlayerRank playerRank = null;
                for (PRPlayerRank targetPlayerRank : prPlayer.getRanks()) {
                    if (!targetPlayerRank.getName().equals(rank.getName())) continue;
                    playerRank = targetPlayerRank;
                    break;
                }
                if (playerRank == null) continue;
                prPlayer.removeRank(playerRank);
            }
        }
        CacheManager.removeRank(CacheManager.getRank(rankToDelete));
        return true;
    }

    public boolean renameRank(String rank, String to) {
        if (CacheManager.getRank(rank) != null && CacheManager.getRank(this.getRankIgnoreCase(to)) == null) {
            CacheManager.getRank(rank).setName(to);
            return true;
        }
        return false;
    }

    public String getRankIgnoreCase(String rankname) {
        String rank = rankname;
        try {
            for (PRRank r : CacheManager.getRanks()) {
                if (!r.getName().equalsIgnoreCase(rankname)) continue;
                rank = r.getName();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rank;
    }

    public ArrayList<PRPermission> getPermissions(String rankname) {
        return CacheManager.getRank(rankname).getPermissions();
    }

    public List<String> getInheritances(String rankname) {
        return CacheManager.getRank(rankname).getInheritances();
    }

    public List<PRPlayer> getCachedPlayers() {
        return CacheManager.getPlayers();
    }

    public String getPrefix(Player player) {
        String prefix = "";
        ArrayList<String> ranknames = new ArrayList<String>();
        for (PRPlayerRank playerRank : CacheManager.getPlayer(player.getUniqueId().toString()).getRanks()) {
            ranknames.add(playerRank.getName());
        }
        ArrayList<PRRank> ranks = new ArrayList<PRRank>();
        for (String rankname : ranknames) {
            PRRank rank = CacheManager.getRank(rankname);
            if (rank == null) continue;
            ranks.add(rank);
        }
        PRUtil.sortRanksByWeight(ranks);
        PRUtil.reverseRanks(ranks);
        for (PRRank rank : ranks) {
            prefix = prefix + rank.getPrefix() + " ";
        }
        if (prefix.endsWith(" ")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    public String getSuffix(Player player) {
        String suffix = "";
        ArrayList<String> ranknames = new ArrayList<String>();
        for (PRPlayerRank playerRank : CacheManager.getPlayer(player.getUniqueId().toString()).getRanks()) {
            ranknames.add(playerRank.getName());
        }
        ArrayList<PRRank> ranks = new ArrayList<PRRank>();
        for (String rankname : ranknames) {
            PRRank rank = CacheManager.getRank(rankname);
            if (rank == null) continue;
            ranks.add(rank);
        }
        PRUtil.sortRanksByWeight(ranks);
        PRUtil.reverseRanks(ranks);
        for (PRRank rank : ranks) {
            suffix = suffix + rank.getSuffix() + " ";
        }
        if (suffix.endsWith(" ")) {
            suffix = suffix.substring(0, suffix.length() - 1);
        }
        return suffix;
    }

    public String getChatColor(Player player) {
        String color = "";
        ArrayList<String> ranknames = new ArrayList<String>();
        for (PRPlayerRank playerRank : CacheManager.getPlayer(player.getUniqueId().toString()).getRanks()) {
            ranknames.add(playerRank.getName());
        }
        ArrayList<PRRank> ranks = new ArrayList<PRRank>();
        for (String rankname : ranknames) {
            PRRank rank = CacheManager.getRank(rankname);
            if (rank == null) continue;
            ranks.add(rank);
        }
        PRUtil.sortRanksByWeight(ranks);
        PRUtil.reverseRanks(ranks);
        color = ranks.size() > 0 ? ((PRRank)ranks.get(0)).getChatcolor() : "&f";
        return color;
    }

    public String getNameColor(Player player) {
        String color = "";
        ArrayList<String> ranknames = new ArrayList<String>();
        for (PRPlayerRank playerRank : CacheManager.getPlayer(player.getUniqueId().toString()).getRanks()) {
            ranknames.add(playerRank.getName());
        }
        ArrayList<PRRank> ranks = new ArrayList<PRRank>();
        for (String rankname : ranknames) {
            PRRank rank = CacheManager.getRank(rankname);
            if (rank == null) continue;
            ranks.add(rank);
        }
        PRUtil.sortRanksByWeight(ranks);
        PRUtil.reverseRanks(ranks);
        color = ranks.size() > 0 ? ((PRRank)ranks.get(0)).getNamecolor() : "&f";
        return color;
    }

    public boolean addBuyableRank(String rankname, String rankname2) {
        rankname = this.getRankIgnoreCase(rankname);
        rankname2 = this.getRankIgnoreCase(rankname2);
        try {
            if (CacheManager.getRank(rankname) != null) {
                CacheManager.getRank(rankname).addBuyableRank(rankname2);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean delBuyableRank(String rankname, String rankname2) {
        rankname = this.getRankIgnoreCase(rankname);
        rankname2 = this.getRankIgnoreCase(rankname2);
        try {
            if (CacheManager.getRank(rankname) != null) {
                CacheManager.getRank(rankname).removeBuyableRank(rankname2);
                this.m.updatePlayersWithRank(this, rankname);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public List<String> getBuyableRanks(String rankname) {
        ArrayList<String> ranks = new ArrayList<String>();
        PRRank rank = CacheManager.getRank(rankname);
        if (rank != null) {
            ranks = rank.getBuyableRanks();
        }
        return ranks;
    }

    public boolean setBuyCost(String rankname, String cost) {
        rankname = this.getRankIgnoreCase(rankname);
        if (!cost.chars().anyMatch(Character::isLetter)) {
            try {
                if (CacheManager.getRank(rankname) != null) {
                    CacheManager.getRank(rankname).setBuyCost(Float.parseFloat(cost));
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public float getRankCost(String rankname) {
        float cost = 0.0f;
        try {
            if (CacheManager.getRank(rankname) != null) {
                cost = CacheManager.getRank(rankname).getBuyCost();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cost;
    }

    public boolean setBuyDescription(String rankname, String description) {
        rankname = this.getRankIgnoreCase(rankname);
        try {
            if (CacheManager.getRank(rankname) != null) {
                CacheManager.getRank(rankname).setBuyDescription(description);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean setBuyCommand(String rankname, String command) {
        rankname = this.getRankIgnoreCase(rankname);
        try {
            if (CacheManager.getRank(rankname) != null) {
                CacheManager.getRank(rankname).setBuyCommand(command);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean addPlayerPermission(String targetPlayerName, String permission, boolean allowed) {
        if (permission.contains("/") || permission.contains(":")) {
            return false;
        }
        PRPlayer targetPlayer = CacheManager.getPlayer(targetPlayerName);
        if (targetPlayer != null) {
            try {
                Set<PRPermission> list = targetPlayer.getPermissions();
                PRPermission targetPermission = null;
                for (PRPermission prPermission : list) {
                    if (!prPermission.getName().equals(permission)) continue;
                    targetPermission = prPermission;
                    break;
                }
                if (targetPermission == null) {
                    PRPermission newPermission = new PRPermission();
                    newPermission.setName(permission);
                    newPermission.setValue(allowed);
                    targetPlayer.addPermission(newPermission);
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean delPlayerPermission(String target_player_name, String permission) {
        if (permission.contains("/") || permission.contains(":")) {
            return false;
        }
        Player target_player = Bukkit.getServer().getPlayer(target_player_name);
        if (target_player != null) {
            try {
                if (CacheManager.getPlayer(target_player.getUniqueId().toString()) != null) {
                    Set<PRPermission> list = CacheManager.getPlayer(target_player.getUniqueId().toString()).getPermissions();
                    PRPermission targetPermission = null;
                    for (PRPermission prPermission : list) {
                        if (!prPermission.getName().equals(permission)) continue;
                        targetPermission = prPermission;
                        break;
                    }
                    if (targetPermission != null) {
                        CacheManager.getPlayer(target_player.getUniqueId().toString()).removePermission(targetPermission);
                    }
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            String uuid = "";
            try {
                for (PRPlayer key : CacheManager.getPlayers()) {
                    if (!key.getName().equalsIgnoreCase(target_player_name)) continue;
                    uuid = key.getUUID().toString();
                }
                if (uuid.length() > 0) {
                    if (CacheManager.getPlayer(uuid) != null) {
                        Set<PRPermission> list = CacheManager.getPlayer(uuid).getPermissions();
                        PRPermission targetPermission = null;
                        for (PRPermission prPermission : list) {
                            if (!prPermission.getName().equals(permission)) continue;
                            targetPermission = prPermission;
                            break;
                        }
                        if (targetPermission != null) {
                            CacheManager.getPlayer(uuid).removePermission(targetPermission);
                        }
                        return true;
                    }
                    return false;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public Set<PRPermission> getPlayerPermissions(String playername) {
        Set<PRPermission> list = new HashSet<PRPermission>();
        Player player = Bukkit.getServer().getPlayer(playername);
        if (player == null) {
            return list;
        }
        String uuid = player.getUniqueId().toString();
        try {
            if (CacheManager.getPlayer(uuid) == null) {
                return list;
            }
            list = CacheManager.getPlayer(uuid).getPermissions();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public boolean createUserTag(String tag, String format) {
        Map<?, ?> availableUsertags = PowerRanks.getUsertagManager().getMap("usertags", new HashMap());
        boolean exists = false;
        for (Map.Entry<?, ?> entry : availableUsertags.entrySet()) {
            if (!entry.getKey().toString().equalsIgnoreCase(tag)) continue;
            exists = true;
        }
        if (exists) {
            return false;
        }
        availableUsertags.put(tag, format);
        PowerRanks.getUsertagManager().setMap("usertags", availableUsertags);
        return true;
    }

    public boolean editUserTag(String tag, String format) {
        Map<?, ?> availableUsertags = PowerRanks.getUsertagManager().getMap("usertags", new HashMap());
        String key = "";
        for (Map.Entry<?, ?> entry : availableUsertags.entrySet()) {
            if (!entry.getKey().toString().equalsIgnoreCase(tag)) continue;
            key = entry.getKey().toString();
        }
        if (key.length() == 0) {
            return false;
        }
        availableUsertags.put(key, format);
        PowerRanks.getUsertagManager().setMap("usertags", availableUsertags);
        return true;
    }

    public boolean removeUserTag(String tag) {
        Map<?, ?> availableUsertags = PowerRanks.getUsertagManager().getMap("usertags", new HashMap());
        String key = "";
        for (Map.Entry<?, ?> entry : availableUsertags.entrySet()) {
            if (!entry.getKey().toString().equalsIgnoreCase(tag)) continue;
            key = entry.getKey().toString();
        }
        if (key.length() == 0) {
            return false;
        }
        availableUsertags.remove(key);
        PowerRanks.getUsertagManager().setMap("usertags", availableUsertags);
        return true;
    }

    public boolean setUserTag(Player player, String tag) {
        Map<?, ?> availableUsertags = PowerRanks.getUsertagManager().getMap("usertags", new HashMap());
        PRPlayer targetPlayer = CacheManager.getPlayer(player.getUniqueId().toString());
        if (Objects.isNull(targetPlayer)) {
            return false;
        }
        String key = "";
        for (Map.Entry<?, ?> entry : availableUsertags.entrySet()) {
            if (!entry.getKey().toString().equalsIgnoreCase(tag)) continue;
            key = entry.getKey().toString();
        }
        if (key.length() == 0) {
            return false;
        }
        targetPlayer.setUsertag(key);
        return true;
    }

    public boolean addUserTag(Player player, String tag) {
        Map<?, ?> availableUsertags = PowerRanks.getUsertagManager().getMap("usertags", new HashMap());
        PRPlayer targetPlayer = CacheManager.getPlayer(player.getUniqueId().toString());
        if (Objects.isNull(targetPlayer)) {
            return false;
        }
        String key = "";
        for (Map.Entry<?, ?> entry : availableUsertags.entrySet()) {
            if (!entry.getKey().toString().equalsIgnoreCase(tag)) continue;
            key = entry.getKey().toString();
        }
        if (key.length() == 0) {
            return false;
        }
        targetPlayer.addUsertag(key);
        return true;
    }

    public boolean delUserTag(Player player, String tag) {
        Map<?, ?> availableUsertags = PowerRanks.getUsertagManager().getMap("usertags", new HashMap());
        PRPlayer targetPlayer = CacheManager.getPlayer(player.getUniqueId().toString());
        if (Objects.isNull(targetPlayer)) {
            return false;
        }
        String key = "";
        for (Map.Entry<?, ?> entry : availableUsertags.entrySet()) {
            if (!entry.getKey().toString().equalsIgnoreCase(tag)) continue;
            key = entry.getKey().toString();
        }
        if (key.length() == 0) {
            return false;
        }
        targetPlayer.removeUsertag(key);
        return true;
    }

    public boolean setUserTag(String playername, String tag) {
        Player player = Bukkit.getServer().getPlayer(playername);
        return this.setUserTag(player, tag);
    }

    public boolean addUserTag(String playername, String tag) {
        Player player = Bukkit.getServer().getPlayer(playername);
        return this.addUserTag(player, tag);
    }

    public boolean delUserTag(String playername, String tag) {
        Player player = Bukkit.getServer().getPlayer(playername);
        return this.delUserTag(player, tag);
    }

    public Set<String> getUserTags() {
        HashSet<String> tags = new HashSet<String>();
        Map<?, ?> availableUsertags = PowerRanks.getUsertagManager().getMap("usertags", new HashMap());
        for (Map.Entry<?, ?> entry : availableUsertags.entrySet()) {
            tags.add((String)entry.getKey());
        }
        return tags;
    }

    public String getUserTagValue(String tag) {
        Map<?, ?> availableUsertags = PowerRanks.getUsertagManager().getMap("usertags", new HashMap());
        String key = "";
        for (Map.Entry<?, ?> entry : availableUsertags.entrySet()) {
            if (!entry.getKey().toString().equalsIgnoreCase(tag)) continue;
            key = entry.getValue().toString();
        }
        if (key.length() == 0) {
            return "";
        }
        return key;
    }

    public String getUserTagValue(Player player) {
        PRPlayer targetPlayer = CacheManager.getPlayer(player.getUniqueId().toString());
        if (Objects.isNull(targetPlayer)) {
            return "";
        }
        if (targetPlayer.getUsertags().size() == 0) {
            return "";
        }
        String usertag = targetPlayer.getUsertags().iterator().next();
        if (usertag.length() > 0) {
            return this.getUserTagValue(usertag);
        }
        return "";
    }

    public boolean clearUserTag(String playername) {
        PRPlayer targetPlayer = CacheManager.getPlayer(playername);
        if (Objects.isNull(targetPlayer)) {
            targetPlayer = CacheManager.getPlayer(Bukkit.getServer().getPlayer(playername).getUniqueId().toString());
        }
        if (Objects.isNull(targetPlayer)) {
            return false;
        }
        targetPlayer.setUsertags(new HashSet<String>());
        return true;
    }

    public List<String> getPlayerNames() {
        ArrayList<String> player_names = new ArrayList<String>();
        List<PRPlayer> players_section = CacheManager.getPlayers();
        for (PRPlayer key : players_section) {
            player_names.add(key.getName());
        }
        return player_names;
    }

    public boolean rankExists(String rankname) {
        return CacheManager.getRank(rankname) != null;
    }
}

