/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.data;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.data.PowerRanksVerbose;
import nl.svenar.powerranks.bukkit.data.TablistAnimation;
import nl.svenar.powerranks.common.structure.PRPlayer;
import nl.svenar.powerranks.common.structure.PRPlayerRank;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class TablistManager {
    private Scoreboard scoreboard;
    private HashMap<UUID, Integer> playerHighestWeight = new HashMap();
    private int numRanks = -1;
    private int totalWeight = -1;
    private BukkitRunnable sortingTask;
    private BukkitRunnable headerFooterTask;
    private ArrayList<String> headerLines = new ArrayList();
    private ArrayList<String> footerLines = new ArrayList();
    private HashMap<String, TablistAnimation> tablistAnimations = new HashMap();
    private int verboseLogInterval = 0;

    public void start() {
        PowerRanksVerbose.log("TablistSort", "Initializing");
        if (PowerRanks.getTablistConfigManager().getBool("sorting.enabled", true)) {
            this.setupSorting();
        }
        if (PowerRanks.getTablistConfigManager().getBool("header-footer.enabled", true)) {
            this.setupHeaderFooter();
        }
    }

    private void setupSorting() {
        this.sortingTask = new BukkitRunnable(){

            public void run() {
                Instant startTime = Instant.now();
                if (TablistManager.this.scoreboard == null) {
                    try {
                        TablistManager.this.scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
                        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                            TablistManager.this.onPlayerJoin(player);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (TablistManager.this.scoreboard == null) {
                    return;
                }
                boolean doUpdateRanks = false;
                List<PRRank> sortedRanks = CacheManager.getRanks();
                PRUtil.sortRanksByWeight(sortedRanks);
                if (!PowerRanks.getTablistConfigManager().getBool("sorting.reverse", false)) {
                    Collections.reverse(sortedRanks);
                }
                if (TablistManager.this.numRanks != CacheManager.getRanks().size()) {
                    TablistManager.this.numRanks = CacheManager.getRanks().size();
                    doUpdateRanks = true;
                }
                int newTotalRankWeight = 0;
                for (PRRank rank : sortedRanks) {
                    if (rank == null) continue;
                    newTotalRankWeight += rank.getWeight();
                }
                if (TablistManager.this.totalWeight != newTotalRankWeight) {
                    TablistManager.this.totalWeight = newTotalRankWeight;
                    doUpdateRanks = true;
                }
                if (doUpdateRanks) {
                    for (Team team : TablistManager.this.scoreboard.getTeams()) {
                        for (String entry : team.getEntries()) {
                            team.removeEntry(entry);
                        }
                        team.unregister();
                    }
                    for (int i = 0; i < sortedRanks.size(); ++i) {
                        TablistManager.this.scoreboard.registerNewTeam(i + "-" + sortedRanks.get(i).getName());
                        PowerRanksVerbose.log("TablistSort", "Creating new scoreboard team: " + i + "-" + sortedRanks.get(i).getName());
                    }
                }
                for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                    TablistManager.this.updateSorting(player);
                }
                PowerRanksVerbose.log("task", "Running task sort tablist in " + Duration.between(startTime, Instant.now()).toMillis() + "ms");
            }
        };
        this.sortingTask.runTaskTimer((Plugin)PowerRanks.getInstance(), 0L, (long)(PowerRanks.getInstance().TASK_TPS * PowerRanks.getTablistConfigManager().getInt("sorting.update-interval", 1)));
    }

    private void setupHeaderFooter() {
        for (String line : (ArrayList)PowerRanks.getTablistConfigManager().getList("header-footer.header", new ArrayList())) {
            this.headerLines.add(line);
        }
        for (String line : (ArrayList)PowerRanks.getTablistConfigManager().getList("header-footer.footer", new ArrayList())) {
            this.footerLines.add(line);
        }
        for (String animationName : PowerRanks.getTablistConfigManager().getKeys("header-footer.animations")) {
            TablistAnimation newAnimation = new TablistAnimation();
            newAnimation.setDelay(PowerRanks.getTablistConfigManager().getInt("header-footer.animations." + animationName + ".delay", 1));
            newAnimation.setFrames((ArrayList)PowerRanks.getTablistConfigManager().getList("header-footer.animations." + animationName + ".frames", new ArrayList()));
            this.tablistAnimations.put(animationName, newAnimation);
        }
        this.headerFooterTask = new BukkitRunnable(){

            public void run() {
                Instant startTime = Instant.now();
                for (TablistAnimation animation : TablistManager.this.tablistAnimations.values()) {
                    animation.update();
                }
                for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                    player.setPlayerListHeader(TablistManager.this.getHeader(player));
                    player.setPlayerListFooter(TablistManager.this.getFooter(player));
                }
                if (TablistManager.this.verboseLogInterval > 100) {
                    PowerRanksVerbose.log("task", "Running task header/footer tablist in " + Duration.between(startTime, Instant.now()).toMillis() + "ms");
                    TablistManager.this.verboseLogInterval = 0;
                }
                TablistManager.this.verboseLogInterval++;
            }
        };
        this.headerFooterTask.runTaskTimer((Plugin)PowerRanks.getInstance(), 0L, (long)PowerRanks.getTablistConfigManager().getInt("header-footer.update-interval", 1));
    }

    private String formatAnimations(String line) {
        Pattern pattern = Pattern.compile("\\{.+:.+\\}");
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            TablistAnimation animation;
            String symbol = line.substring(matcher.start(), matcher.end());
            String replacement = "";
            Matcher keyMatcher = Pattern.compile("\\{.+:").matcher(symbol);
            Matcher valueMatcher = Pattern.compile(":.+\\}").matcher(symbol);
            keyMatcher.find();
            valueMatcher.find();
            String key = symbol.substring(keyMatcher.start(), keyMatcher.end());
            String value = symbol.substring(valueMatcher.start(), valueMatcher.end());
            key = key.substring(1, key.length() - 1);
            value = value.substring(1, value.length() - 1);
            if (key.equalsIgnoreCase("animation") && (animation = this.tablistAnimations.get(value)) != null) {
                replacement = animation.getCurrentFrame();
            }
            line = line.replace(symbol, replacement);
            matcher = pattern.matcher(line);
        }
        return line;
    }

    private String getHeader(Player player) {
        String output = "";
        for (String line : this.headerLines) {
            output = output + line + "\n";
        }
        if (output.length() == 0) {
            return output;
        }
        if (PowerRanks.placeholderapiExpansion != null) {
            output = PlaceholderAPI.setPlaceholders((Player)player, (String)output).replaceAll("\u00a7", "&");
        }
        output = output.substring(0, output.length() - 1);
        output = this.formatAnimations(output);
        output = PowerRanks.chatColor(output, true);
        return output;
    }

    private String getFooter(Player player) {
        String output = "";
        for (String line : this.footerLines) {
            output = output + line + "\n";
        }
        if (output.length() == 0) {
            return output;
        }
        if (PowerRanks.placeholderapiExpansion != null) {
            output = PlaceholderAPI.setPlaceholders((Player)player, (String)output).replaceAll("\u00a7", "&");
        }
        output = output.substring(0, output.length() - 1);
        output = this.formatAnimations(output);
        output = PowerRanks.chatColor(output, true);
        return output;
    }

    public void stop() {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            player.setPlayerListHeader(null);
            player.setPlayerListFooter(null);
        }
        this.headerLines = new ArrayList();
        this.footerLines = new ArrayList();
        this.tablistAnimations = new HashMap();
        for (Map.Entry entry : this.playerHighestWeight.entrySet()) {
            entry.setValue(Integer.MIN_VALUE);
        }
        this.numRanks = -1;
        this.totalWeight = -1;
        PowerRanksVerbose.log("TablistSort", "Stopping");
        if (this.sortingTask != null) {
            try {
                this.sortingTask.cancel();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.sortingTask = null;
        }
        if (this.headerFooterTask != null) {
            try {
                this.headerFooterTask.cancel();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.headerFooterTask = null;
        }
        if (this.scoreboard != null) {
            for (Team team : this.scoreboard.getTeams()) {
                for (String entry : team.getEntries()) {
                    team.removeEntry(entry);
                }
                team.unregister();
            }
            this.scoreboard = null;
        }
    }

    public void updateSorting(Player player) {
        if (PowerRanks.getTablistConfigManager().getBool("sorting.enabled", true) && this.scoreboard != null) {
            if (!this.playerHighestWeight.containsKey(player.getUniqueId())) {
                this.playerHighestWeight.put(player.getUniqueId(), Integer.MIN_VALUE);
            }
            PRPlayer targetPlayer = CacheManager.getPlayer(player.getUniqueId().toString());
            int playerHighestRankWeight = Integer.MIN_VALUE;
            PRRank playerHighestRank = null;
            ArrayList<String> ranknames = new ArrayList<String>();
            for (PRPlayerRank playerRank : targetPlayer.getRanks()) {
                ranknames.add(playerRank.getName());
            }
            for (String rankname : ranknames) {
                PRRank rank = CacheManager.getRank(rankname);
                if (rank == null || rank.getWeight() <= playerHighestRankWeight) continue;
                playerHighestRankWeight = rank.getWeight();
                playerHighestRank = rank;
            }
            if (this.playerHighestWeight.get(player.getUniqueId()) != playerHighestRankWeight) {
                this.playerHighestWeight.put(player.getUniqueId(), playerHighestRankWeight);
                if (playerHighestRank != null) {
                    for (Team team : this.scoreboard.getTeams()) {
                        if (team.getName().contains("-") && team.getName().split("-")[1].equals(playerHighestRank.getName())) {
                            team.addEntry(player.getName());
                            PowerRanksVerbose.log("TablistSort", "Setting " + player.getName() + " to scoreboard team: " + team.getName());
                            continue;
                        }
                        team.removeEntry(player.getName());
                    }
                    PowerRanks.getInstance().updateTablistName(player);
                }
            }
        }
    }

    public void onPlayerJoin(Player player) {
        if (this.scoreboard != null) {
            player.setScoreboard(this.scoreboard);
        }
    }

    public void onPlayerLeave(Player player) {
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }
}

