/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.data;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.data.PowerRanksVerbose;
import nl.svenar.powerranks.common.storage.PermissionRegistry;
import nl.svenar.powerranks.common.structure.PRPermission;
import nl.svenar.powerranks.common.structure.PRPlayer;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;

public class PowerPermissibleBase
extends PermissibleBase {
    private PowerRanks plugin;
    private Player player;
    private PermissionRegistry permissionRegistry;
    private PRPlayer prPlayer;
    public static Map<String, Integer> permissionCallCount = new HashMap<String, Integer>();

    public PowerPermissibleBase(Player player, PowerRanks plugin) {
        super((ServerOperator)player);
        this.player = player;
        this.plugin = plugin;
        this.permissionRegistry = plugin.getPermissionRegistry();
        this.prPlayer = CacheManager.getPlayer(player.getUniqueId().toString());
        if (this.prPlayer == null) {
            CacheManager.createPlayer(player);
            this.prPlayer = CacheManager.getPlayer(player.getUniqueId().toString());
        }
        PowerRanksVerbose.log("PowerPermissibleBase", "attached to player " + (player == null ? "null" : player.getName()));
        this.recalculatePermissions();
    }

    public boolean isOp() {
        PowerRanksVerbose.log("isOp()", "called");
        return super.isOp();
    }

    public void setOp(boolean value) {
        super.setOp(value);
    }

    public boolean isPermissionSet(Permission perm) {
        if (perm == null) {
            throw new IllegalArgumentException("Permission cannot be null");
        }
        return this.isPermissionSet(perm.getName());
    }

    public boolean isPermissionSet(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Permission name cannot be null");
        }
        this.permissionRegistry.queuePermission(name);
        PRPermission prPermission = this.getPRPermission(name);
        if (prPermission == null) {
            String wildCardPermissionName;
            Iterator<String> iterator2 = PRUtil.generateWildcardList(name).iterator();
            while (iterator2.hasNext() && (prPermission = this.getPRPermission(wildCardPermissionName = iterator2.next())) == null) {
            }
        }
        PowerRanksVerbose.log("isPermissionSet(String name)", "called with name: " + name + " (" + super.isPermissionSet(name) + ") - prPermission value: " + (prPermission == null ? "null" : Boolean.valueOf(prPermission.getValue())));
        if (prPermission != null) {
            return prPermission.getValue();
        }
        return super.isPermissionSet(name);
    }

    public boolean hasPermission(Permission perm) {
        if (perm == null) {
            throw new IllegalArgumentException("Permission cannot be null");
        }
        return this.hasPermission(perm.getName());
    }

    public boolean hasPermission(String inName) {
        if (inName == null) {
            throw new IllegalArgumentException("Permission name cannot be null");
        }
        this.permissionRegistry.queuePermission(inName);
        if (permissionCallCount.get(inName) == null) {
            permissionCallCount.put(inName, 0);
        } else {
            permissionCallCount.put(inName, permissionCallCount.get(inName) + 1);
        }
        PRPermission prPermission = this.getPRPermission(inName);
        if (prPermission == null) {
            String wildCardPermissionName;
            Iterator<String> iterator2 = PRUtil.generateWildcardList(inName).iterator();
            while (iterator2.hasNext() && (prPermission = this.getPRPermission(wildCardPermissionName = iterator2.next())) == null) {
            }
        }
        boolean defaultHasPermission = false;
        try {
            defaultHasPermission = super.hasPermission(inName);
        }
        catch (NullPointerException e) {
            PowerRanksVerbose.log("hasPermission(String inName) failed", e.getMessage());
            super.recalculatePermissions();
        }
        PowerRanksVerbose.log("hasPermission(String inName)", "called with inName: " + inName + " (" + defaultHasPermission + ") - prPermission value: " + (prPermission == null ? "null" : Boolean.valueOf(prPermission.getValue())));
        if (prPermission != null) {
            return prPermission.getValue();
        }
        return defaultHasPermission;
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        PowerRanksVerbose.log("addAttachment(Plugin plugin)", "called with plugin: " + plugin.getName() + ", name: " + name + ", value: " + value);
        return super.addAttachment(plugin, name, value);
    }

    public PermissionAttachment addAttachment(Plugin plugin) {
        PowerRanksVerbose.log("addAttachment(Plugin plugin)", "called with plugin: " + plugin.getName());
        return super.addAttachment(plugin);
    }

    public void removeAttachment(PermissionAttachment attachment) {
        PowerRanksVerbose.log("removeAttachment(PermissionAttachment attachment)", "called with attachment permissions: ");
        for (Map.Entry permissionAttachmentInfo : attachment.getPermissions().entrySet()) {
            PowerRanksVerbose.log("", "    " + (String)permissionAttachmentInfo.getKey() + ": " + permissionAttachmentInfo.getValue());
        }
        try {
            super.removeAttachment(attachment);
        }
        catch (Exception e) {
            PowerRanksVerbose.log("removeAttachment(PermissionAttachment attachment) failed", e.getMessage());
        }
    }

    public void recalculatePermissions() {
        PowerRanksVerbose.log("recalculatePermissions()", "called");
        super.recalculatePermissions();
    }

    public synchronized void clearPermissions() {
        PowerRanksVerbose.log("clearPermissions()", "called");
        super.clearPermissions();
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        PowerRanksVerbose.log("addAttachment(Plugin plugin, String name, boolean value, int ticks)", "called with plugin: " + plugin.getName() + ", name: " + name + ", value: " + value + ", ticks: " + ticks);
        return super.addAttachment(plugin, name, value, ticks);
    }

    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        PowerRanksVerbose.log("addAttachment(Plugin plugin, int ticks)", "called with plugin: " + plugin.getName() + ", ticks: " + ticks);
        return super.addAttachment(plugin, ticks);
    }

    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        PowerRanksVerbose.log("getEffectivePermissions()", "called");
        return super.getEffectivePermissions();
    }

    private PRPermission getPRPermission(String name) {
        PRPermission prPermission = null;
        boolean caseSensitive = PowerRanks.getConfigManager().getBool("general.case-sensitive-permissions", false);
        for (PRPermission permission : this.plugin.getEffectivePlayerPermissions(this.player)) {
            if ((!caseSensitive || !permission.getName().equals(name)) && (caseSensitive || !permission.getName().equalsIgnoreCase(name))) continue;
            prPermission = permission;
            break;
        }
        return prPermission;
    }
}

