/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.data;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.data.PowerRanksVerbose;
import nl.svenar.powerranks.common.storage.provided.MySQLStorageManager;
import nl.svenar.powerranks.common.structure.PRPlayer;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BungeecordManager {
    private UUID serverUUID;
    private ArrayList<UUID> onlineServers = new ArrayList();
    private boolean ready = false;
    private BukkitRunnable mainTask;
    private int ranksHashcode;
    private int playersHashcode;
    private int lastRanksHashcode;
    private int lastPlayersHashcode;

    public BungeecordManager(PowerRanks powerRanks) {
        this.serverUUID = UUID.fromString(PowerRanks.getConfigManager().getString("bungeecord.uuid", UUID.randomUUID().toString()));
    }

    public void start() {
        if (!PowerRanks.getConfigManager().getBool("bungeecord.enabled", false)) {
            return;
        }
        if (!(CacheManager.getStorageManager() instanceof MySQLStorageManager)) {
            PowerRanks.log.severe("");
            PowerRanks.log.severe("=== ----------------------------- ===");
            PowerRanks.log.severe("               WARNING               ");
            PowerRanks.log.severe("     Bungeecord is enabled, but      ");
            PowerRanks.log.severe("  storage type is not set to MYSQL!  ");
            PowerRanks.log.severe("");
            PowerRanks.log.severe("Bungeecord functionality is disabled!");
            PowerRanks.log.severe("=== ----------------------------- ===");
            PowerRanks.log.severe("");
            return;
        }
        this.ready = true;
        PowerRanks.log.info("Setting up Bungeecord with ID " + this.serverUUID.toString());
        CacheManager.postDBMessage(UUID.fromString("00000000-0000-0000-0000-000000000000"), this.serverUUID.toString(), "online");
        this.updateHashes();
        this.lastRanksHashcode = this.ranksHashcode;
        this.lastPlayersHashcode = this.playersHashcode;
        this.mainTask = new BukkitRunnable(){

            public void run() {
                boolean playerHashChanged;
                Instant startTime = Instant.now();
                for (Map.Entry<String, String> e : CacheManager.getDBBroadcastMessages().entrySet()) {
                    Iterator targetUUID = UUID.fromString(e.getKey().split("\\.")[1]);
                    if (e.getValue().equalsIgnoreCase("online") && !((UUID)((Object)targetUUID)).toString().equals(BungeecordManager.this.serverUUID.toString())) {
                        if (BungeecordManager.this.onlineServers.contains(targetUUID)) continue;
                        BungeecordManager.this.onlineServers.add(targetUUID);
                        continue;
                    }
                    if (!BungeecordManager.this.onlineServers.contains(targetUUID)) continue;
                    BungeecordManager.this.onlineServers.remove(targetUUID);
                }
                BungeecordManager.this.updateHashes();
                boolean rankHashChanged = BungeecordManager.this.lastRanksHashcode != BungeecordManager.this.ranksHashcode;
                boolean bl = playerHashChanged = BungeecordManager.this.lastPlayersHashcode != BungeecordManager.this.playersHashcode;
                if (rankHashChanged || playerHashChanged) {
                    CacheManager.save();
                }
                if (rankHashChanged) {
                    for (UUID remoteServer : BungeecordManager.this.onlineServers) {
                        CacheManager.postDBMessage(remoteServer, "update.ranks", String.valueOf(Instant.now().getEpochSecond()));
                    }
                }
                if (playerHashChanged) {
                    for (UUID remoteServer : BungeecordManager.this.onlineServers) {
                        CacheManager.postDBMessage(remoteServer, "update.players", String.valueOf(Instant.now().getEpochSecond()));
                    }
                }
                boolean doReloadData = false;
                for (Map.Entry<String, String> newMessage : CacheManager.getDBMessages(BungeecordManager.this.serverUUID).entrySet()) {
                    String command = newMessage.getKey().split("\\.")[1];
                    block3 : switch (command.toLowerCase()) {
                        case "update": {
                            String updateType = newMessage.getKey().split("\\.")[2];
                            switch (updateType.toLowerCase()) {
                                case "ranks": {
                                    doReloadData = true;
                                    break block3;
                                }
                                case "players": {
                                    doReloadData = true;
                                    break block3;
                                }
                            }
                            break;
                        }
                    }
                    CacheManager.removeDBMessage(BungeecordManager.this.serverUUID, newMessage.getKey().replaceAll(BungeecordManager.this.serverUUID.toString() + ".", ""));
                }
                if (doReloadData) {
                    PowerRanks.log.warning("Reloading data from database!");
                    CacheManager.load(PowerRanks.fileLoc);
                    PowerRanks.getInstance().updateAllPlayersTABlist();
                    BungeecordManager.this.updateHashes();
                    BungeecordManager.this.lastRanksHashcode = BungeecordManager.this.ranksHashcode;
                    BungeecordManager.this.lastPlayersHashcode = BungeecordManager.this.playersHashcode;
                }
                PowerRanksVerbose.log("task", "Running task bungeecord mainTask in " + Duration.between(startTime, Instant.now()).toMillis() + "ms");
            }
        };
        this.mainTask.runTaskTimer((Plugin)PowerRanks.getInstance(), 0L, 100L);
    }

    public void stop() {
        if (!PowerRanks.getConfigManager().getBool("bungeecord.enabled", false)) {
            return;
        }
        if (!(CacheManager.getStorageManager() instanceof MySQLStorageManager)) {
            return;
        }
        this.ready = false;
        CacheManager.postDBMessage(UUID.fromString("00000000-0000-0000-0000-000000000000"), this.serverUUID.toString(), "offline");
    }

    public boolean isReady() {
        return this.ready;
    }

    public int getServerCount() {
        return this.onlineServers.size();
    }

    private void updateHashes() {
        this.lastRanksHashcode = this.ranksHashcode;
        this.lastPlayersHashcode = this.playersHashcode;
        this.ranksHashcode = 17;
        List<PRRank> ranks = CacheManager.getRanks();
        PRUtil.sortRanksByWeight(ranks);
        for (PRRank rank : ranks) {
            this.ranksHashcode = 31 * this.ranksHashcode + (rank != null ? rank.hashCode() : 0);
        }
        this.playersHashcode = 0;
        for (PRPlayer player : CacheManager.getPlayers()) {
            this.playersHashcode += player.hashCode();
        }
    }
}

