/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands.webeditor;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.bukkit.data.PowerRanksVerbose;
import nl.svenar.powerranks.common.http.DatabinClient;
import nl.svenar.powerranks.common.storage.PowerStorageManager;
import nl.svenar.powerranks.common.storage.provided.JSONStorageManager;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class cmd_webeditor
extends PowerCommand {
    private String tellraw_url = "tellraw %player% [\"\",{\"text\":\"Web editor is ready \",\"color\":\"dark_green\"},{\"text\":\"[\",\"color\":\"black\",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"%url%\"}},{\"text\":\"click to open\",\"color\":\"dark_green\",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"%url%\"}},{\"text\":\"]\",\"color\":\"black\",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"%url%\"}}]";
    private String powerranks_webeditor_url = "https://editor.powerranks.nl/?id=";

    public cmd_webeditor(PowerRanks plugin, String command_name, PowerCommand.COMMAND_EXECUTOR ce) {
        super(plugin, command_name, ce);
        this.setCommandPermission("powerranks.cmd." + command_name.toLowerCase());
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        if (args2.length != 0) {
            if (args2.length == 1 || args2.length == 2) {
                String webeditorCommand;
                switch (webeditorCommand = args2[0].toLowerCase()) {
                    case "start": {
                        this.startWebeditor(sender, commandName);
                        break;
                    }
                    case "load": {
                        if (args2.length == 2) {
                            this.loadWebeditor(sender, args2[1], commandName);
                            break;
                        }
                        sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
                        break;
                    }
                    default: {
                        sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
                        break;
                    }
                }
            } else {
                sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
            }
        }
        return false;
    }

    private void startWebeditor(final CommandSender sender, final String commandName) {
        sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".preparing-session"));
        JSONStorageManager jsonmanager = new JSONStorageManager(PowerRanks.fileLoc, "dummyRanks.json", "dummyPlayers.json");
        PowerStorageManager powermanager = CacheManager.getStorageManager();
        jsonmanager.setRanks(powermanager.getRanks());
        jsonmanager.setPlayers(powermanager.getPlayers());
        String outputJSON = "";
        outputJSON = outputJSON + "{";
        outputJSON = outputJSON + "\"serverdata\":";
        outputJSON = outputJSON + this.getServerDataAsJSON();
        outputJSON = outputJSON + ",";
        outputJSON = outputJSON + "\"rankdata\":";
        outputJSON = outputJSON + jsonmanager.getRanksAsJSON(false);
        outputJSON = outputJSON + ",";
        outputJSON = outputJSON + "\"playerdata\":";
        outputJSON = outputJSON + jsonmanager.getPlayersAsJSON(false);
        outputJSON = outputJSON + ",";
        outputJSON = outputJSON + "\"usertags\":";
        outputJSON = outputJSON + PowerRanks.getUsertagManager().toJSON("usertags", false);
        outputJSON = outputJSON + ",";
        outputJSON = outputJSON + "\"tablist\":";
        outputJSON = outputJSON + PowerRanks.getTablistConfigManager().toJSON(null, false);
        outputJSON = outputJSON + "}";
        jsonmanager.removeAllData();
        final DatabinClient client = new DatabinClient("https://databin.svenar.nl", "Databinclient/1.0");
        client.postJSON(outputJSON);
        final int uploadSize = outputJSON.length() / 1024;
        final int updateInterval = 5;
        final int timeout2 = 5;
        new BukkitRunnable(){
            int waitTime = 0;

            public void run() {
                PowerRanksVerbose.log("task", "Running task uploading webeditor data");
                if (client.hasResponse()) {
                    String key = client.getResponse().get("key");
                    if (key.length() > 0 && !key.startsWith("[FAILED]")) {
                        sender.sendMessage(ChatColor.DARK_AQUA + "===----------" + ChatColor.DARK_BLUE + PowerRanks.pdf.getName() + ChatColor.DARK_AQUA + "----------===");
                        if (sender instanceof Player) {
                            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), cmd_webeditor.this.tellraw_url.replaceAll("%player%", sender.getName()).replaceAll("%url%", cmd_webeditor.this.powerranks_webeditor_url + key).replaceAll("\n", ""));
                        } else {
                            sender.sendMessage(ChatColor.DARK_GREEN + "Web editor is ready " + ChatColor.BLACK + "[" + ChatColor.GREEN + cmd_webeditor.this.powerranks_webeditor_url + key + ChatColor.BLACK + "]");
                        }
                        sender.sendMessage(ChatColor.DARK_GREEN + "Editor ID: " + ChatColor.GREEN + key);
                        sender.sendMessage(ChatColor.DARK_GREEN + "Uploaded: " + ChatColor.GREEN + uploadSize + "KB");
                        sender.sendMessage(ChatColor.DARK_AQUA + "===------------------------------===");
                    }
                    this.cancel();
                }
                if (this.waitTime / (20 / updateInterval) > timeout2) {
                    this.cancel();
                    sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".timed-out"));
                }
                ++this.waitTime;
            }
        }.runTaskTimer((Plugin)PowerRanks.getInstance(), 0L, (long)updateInterval);
    }

    private void loadWebeditor(final CommandSender sender, String key, final String commandName) {
        sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".downloading-data"));
        final DatabinClient client = new DatabinClient("https://databin.svenar.nl", "Databinclient/1.0");
        client.getJSON(key);
        final int updateInterval = 5;
        final int timeout2 = 5;
        new BukkitRunnable(){
            int waitTime = 0;

            public void run() {
                PowerRanksVerbose.log("task", "Running task downloading webeditor data");
                if (client.hasResponse()) {
                    this.cancel();
                    String rawJSON = client.getRawResponse();
                    Gson gson = new Gson();
                    Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
                    Map jsonData = (Map)gson.fromJson(rawJSON, mapType);
                    cmd_webeditor.this.handleWebeditorDownload(sender, jsonData, commandName);
                }
                if (this.waitTime / (20 / updateInterval) > timeout2) {
                    this.cancel();
                    sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".timed-out"));
                }
                ++this.waitTime;
            }
        }.runTaskTimer((Plugin)PowerRanks.getInstance(), 0L, (long)updateInterval);
    }

    public void handleWebeditorDownload(CommandSender sender, Map<String, Object> jsonData, String commandName) {
        LinkedTreeMap serverData = (LinkedTreeMap)jsonData.get("serverdata");
        if (Objects.isNull(serverData) || !serverData.containsKey((Object)"powerranksVersion")) {
            PowerRanks.getInstance().getLogger().warning(serverData.toString());
            sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".downloaded-invalid-data"));
            return;
        }
        if (!((String)serverData.get((Object)"powerranksVersion")).equals(PowerRanks.getVersion())) {
            sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".incompatible-version"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"version", (Object)PowerRanks.getVersion()).put((Object)"downloaded_version", (Object)((String)serverData.get((Object)"powerranksVersion"))).build(), '[', ']'));
            return;
        }
        LinkedTreeMap rankData = (LinkedTreeMap)jsonData.get("rankdata");
        LinkedTreeMap playerData = (LinkedTreeMap)jsonData.get("playerdata");
        LinkedTreeMap usertags = (LinkedTreeMap)jsonData.get("usertags");
        LinkedTreeMap tablist = (LinkedTreeMap)jsonData.get("tablist");
        JSONStorageManager jsonmanager = new JSONStorageManager(PowerRanks.fileLoc, "dummyRanks.json", "dummyPlayers.json");
        if (!(rankData instanceof LinkedTreeMap) || !(playerData instanceof LinkedTreeMap)) {
            sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".failed-downloaded"));
            return;
        }
        CacheManager.setRanks(jsonmanager.getRanksFromJSON(rankData));
        CacheManager.setPlayers(jsonmanager.getPlayersFromJSON(playerData));
        CacheManager.save();
        jsonmanager.removeAllData();
        PowerRanks.getUsertagManager().fromJSON("usertags", usertags);
        PowerRanks.getTablistConfigManager().fromJSON(null, tablist);
        sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".success-downloaded"));
        sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".download-stats"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"rank_count", (Object)String.valueOf(CacheManager.getRanks().size())).put((Object)"player_count", (Object)String.valueOf(CacheManager.getPlayers().size())).build(), '[', ']'));
    }

    @Override
    public ArrayList<String> tabCompleteEvent(CommandSender sender, String[] args2) {
        ArrayList<String> tabcomplete = new ArrayList<String>();
        if (args2.length == 1) {
            tabcomplete.add("start");
            tabcomplete.add("load");
        }
        return tabcomplete;
    }

    private String getServerDataAsJSON() {
        String output = "";
        ArrayList<String> server_permissions = new ArrayList<String>();
        for (String perm : this.plugin.getPermissionRegistry().getPermissions()) {
            server_permissions.add("\"" + perm + "\"");
        }
        output = output + "{";
        output = output + "\"powerranksVersion\":";
        output = output + "\"" + PowerRanks.getVersion() + "\"";
        output = output + ",\"serverPermissions\":";
        output = output + "[" + String.join((CharSequence)",", server_permissions) + "]";
        output = output + "}";
        return output;
    }
}

