/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands.usertags;

import java.util.ArrayList;
import java.util.Set;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.bukkit.data.Users;
import nl.svenar.powerranks.bukkit.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class cmd_listusertags
extends PowerCommand {
    private Users users;

    public cmd_listusertags(PowerRanks plugin, String command_name, PowerCommand.COMMAND_EXECUTOR ce) {
        super(plugin, command_name, ce);
        this.users = new Users(plugin);
        this.setCommandPermission("powerranks.cmd." + command_name.toLowerCase());
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        if (!PowerRanks.plugin_hook_deluxetags) {
            if (args2.length == 0) {
                this.displayList(sender, commandLabel, 0);
            } else if (args2.length == 1) {
                int page = Integer.parseInt(args2[0].replaceAll("[a-zA-Z]", ""));
                this.displayList(sender, commandLabel, page);
            } else {
                sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
            }
        } else {
            sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("general.no-permission"));
        }
        return false;
    }

    private void displayList(CommandSender sender, String commandLabel, int page) {
        ArrayList<String> output_messages = new ArrayList<String>();
        output_messages.add(ChatColor.BLUE + "===" + ChatColor.DARK_AQUA + "----------" + ChatColor.AQUA + this.plugin.getDescription().getName() + ChatColor.DARK_AQUA + "----------" + ChatColor.BLUE + "===");
        Set<String> items = this.users.getUserTags();
        int lines_per_page = sender instanceof Player ? 5 : 10;
        int last_page = items.size() / lines_per_page;
        if (!(sender instanceof Player)) {
            --page;
        }
        page = page < 0 ? 0 : page;
        int n = page = page > last_page ? last_page : page;
        if (sender instanceof Player) {
            String page_selector_tellraw = "tellraw " + sender.getName() + " [\"\",{\"text\":\"Page \",\"color\":\"aqua\"},{\"text\":\"%next_page%\",\"color\":\"blue\"},{\"text\":\"/\",\"color\":\"aqua\"},{\"text\":\"%last_page%\",\"color\":\"blue\"},{\"text\":\": \",\"color\":\"aqua\"},{\"text\":\"[\",\"color\":\"aqua\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/%commandlabel% listusertags %previous_page%\"}},{\"text\":\"<\",\"color\":\"blue\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/%commandlabel% listusertags %previous_page%\"}},{\"text\":\"]\",\"color\":\"aqua\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/%commandlabel% listusertags %previous_page%\"}},{\"text\":\" \",\"color\":\"aqua\"},{\"text\":\"[\",\"color\":\"aqua\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/%commandlabel% listusertags%next_page%\"}},{\"text\":\">\",\"color\":\"blue\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/%commandlabel% listusertags %next_page%\"}},{\"text\":\"]\",\"color\":\"aqua\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/%commandlabel% listusertags %next_page%\"}}]";
            page_selector_tellraw = Util.replaceAll(page_selector_tellraw, "%next_page%", String.valueOf(page + 1));
            page_selector_tellraw = Util.replaceAll(page_selector_tellraw, "%previous_page%", String.valueOf(page - 1));
            page_selector_tellraw = Util.replaceAll(page_selector_tellraw, "%last_page%", String.valueOf(last_page + 1));
            page_selector_tellraw = Util.replaceAll(page_selector_tellraw, "%commandlabel%", commandLabel);
            output_messages.add(page_selector_tellraw);
            output_messages.add(ChatColor.AQUA + "Usertags:");
        } else {
            output_messages.add(ChatColor.AQUA + "Page " + ChatColor.BLUE + (page + 1) + ChatColor.AQUA + "/" + ChatColor.BLUE + (last_page + 1));
            output_messages.add(ChatColor.AQUA + "Next page " + ChatColor.BLUE + "/" + commandLabel + " listusertags  " + ChatColor.BLUE + (page + 2 > last_page + 1 ? last_page + 1 : page + 2));
        }
        int line_index = 0;
        for (String item : items) {
            if (line_index >= page * lines_per_page && line_index < page * lines_per_page + lines_per_page) {
                String usertagValue = this.users.getUserTagValue(item);
                output_messages.add(ChatColor.DARK_GREEN + "#" + (line_index + 1) + ". " + ChatColor.GREEN + item + " " + ChatColor.RESET + PowerRanks.chatColor(usertagValue, true));
            }
            ++line_index;
        }
        output_messages.add(ChatColor.BLUE + "===" + ChatColor.DARK_AQUA + "------------------------------" + ChatColor.BLUE + "===");
        if (this.plugin != null) {
            for (String msg : output_messages) {
                if (msg.startsWith("tellraw")) {
                    this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), msg);
                    continue;
                }
                sender.sendMessage(msg);
            }
        }
    }

    @Override
    public ArrayList<String> tabCompleteEvent(CommandSender sender, String[] args2) {
        ArrayList<String> tabcomplete = new ArrayList<String>();
        return tabcomplete;
    }
}

