/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands.usertags;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.bukkit.data.Users;
import nl.svenar.powerranks.bukkit.util.Util;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class cmd_delusertag
extends PowerCommand {
    private Users users;

    public cmd_delusertag(PowerRanks plugin, String command_name, PowerCommand.COMMAND_EXECUTOR ce) {
        super(plugin, command_name, ce);
        this.users = new Users(plugin);
        this.setCommandPermission("powerranks.cmd." + command_name.toLowerCase());
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        if (args2.length == 1) {
            if (!PowerRanks.plugin_hook_deluxetags) {
                String tag;
                String playername = sender.getName();
                boolean result = this.users.delUserTag(playername, tag = args2[0]);
                if (result) {
                    Player targetPlayer = Bukkit.getServer().getPlayer(playername);
                    if (targetPlayer != null) {
                        PowerRanks.getInstance().updateTablistName(targetPlayer);
                    }
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".success"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"target", (Object)playername).put((Object)"usertag", (Object)tag).build(), '[', ']'));
                } else {
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".failed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"target", (Object)playername).put((Object)"usertag", (Object)tag).build(), '[', ']'));
                }
            } else {
                sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".disabled"));
            }
        } else if (args2.length == 2) {
            if (sender.hasPermission("powerranks.cmd." + commandName.toLowerCase() + ".other")) {
                if (!PowerRanks.plugin_hook_deluxetags) {
                    String playername = args2[0];
                    String tag = args2[1];
                    boolean result = this.users.delUserTag(playername, tag);
                    if (result) {
                        Player targetPlayer = Bukkit.getServer().getPlayer(playername);
                        if (targetPlayer != null) {
                            PowerRanks.getInstance().updateTablistName(targetPlayer);
                        }
                        sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".success"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"target", (Object)playername).put((Object)"usertag", (Object)tag).build(), '[', ']'));
                    } else {
                        sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".failed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"target", (Object)playername).put((Object)"usertag", (Object)tag).build(), '[', ']'));
                    }
                } else {
                    sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".disabled"));
                }
            } else {
                sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("general.no-permission"));
            }
        } else {
            sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
        }
        return false;
    }

    @Override
    public ArrayList<String> tabCompleteEvent(CommandSender sender, String[] args2) {
        Player target_player;
        ArrayList<String> tabcomplete = new ArrayList<String>();
        if (args2.length == 1) {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                tabcomplete.add(player.getName());
            }
        }
        if (args2.length == 2 && (target_player = Util.getPlayerByName(args2[0])) != null) {
            for (String tag : CacheManager.getPlayer(target_player.getUniqueId().toString()).getUsertags()) {
                tabcomplete.add(tag);
            }
        }
        return tabcomplete;
    }
}

