/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands.rank;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.bukkit.data.Users;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class cmd_setweight
extends PowerCommand {
    private Users users;

    public cmd_setweight(PowerRanks plugin, String command_name, PowerCommand.COMMAND_EXECUTOR ce) {
        super(plugin, command_name, ce);
        this.users = new Users(plugin);
        this.setCommandPermission("powerranks.cmd." + command_name.toLowerCase());
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        if (args2.length == 2) {
            String rankname = this.users.getRankIgnoreCase(args2[0]);
            PRRank rank = CacheManager.getRank(rankname);
            if (Objects.isNull(rank)) {
                sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("general.rank-not-found"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"rank", (Object)rankname).build(), '[', ']'));
            }
            int weight = 0;
            try {
                weight = Integer.parseInt(args2[1]);
            }
            catch (Exception e) {
                sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".numbers-only"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"rank", (Object)rankname).put((Object)"weight", (Object)args2[1]).build(), '[', ']'));
            }
            if (rank != null) {
                rank.setWeight(weight);
                sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".success"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"rank", (Object)rankname).put((Object)"weight", (Object)String.valueOf(weight)).build(), '[', ']'));
            }
        } else {
            sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
        }
        return false;
    }

    @Override
    public ArrayList<String> tabCompleteEvent(CommandSender sender, String[] args2) {
        ArrayList<String> tabcomplete = new ArrayList<String>();
        if (args2.length == 1) {
            for (PRRank rank : this.users.getGroups()) {
                tabcomplete.add(rank.getName());
            }
        }
        return tabcomplete;
    }
}

