/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands.rank;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.bukkit.data.Messages;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class cmd_rankinfo
extends PowerCommand {
    public cmd_rankinfo(PowerRanks plugin, String command_name, PowerCommand.COMMAND_EXECUTOR ce) {
        super(plugin, command_name, ce);
        this.setCommandPermission("powerranks.cmd." + command_name.toLowerCase());
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        if (args2.length == 1) {
            String target_rank_name = args2[0];
            PRRank target_rank = CacheManager.getRank(target_rank_name);
            if (target_rank != null) {
                Messages.messageRankInfo(sender, target_rank, 0);
            } else {
                sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("general.rank-not-found"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"rank", (Object)target_rank_name).build(), '[', ']'));
            }
        } else if (args2.length == 2) {
            String target_rank_name = args2[0];
            int page = Integer.parseInt(args2[1].replaceAll("[a-zA-Z]", ""));
            PRRank target_rank = CacheManager.getRank(target_rank_name);
            if (target_rank != null) {
                Messages.messageRankInfo(sender, target_rank, page);
            } else {
                sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("general.rank-not-found"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"rank", (Object)target_rank_name).build(), '[', ']'));
            }
        } else {
            sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
        }
        return false;
    }

    @Override
    public ArrayList<String> tabCompleteEvent(CommandSender sender, String[] args2) {
        ArrayList<String> tabcomplete = new ArrayList<String>();
        if (args2.length == 1) {
            for (PRRank rank : CacheManager.getRanks()) {
                tabcomplete.add(rank.getName());
            }
        }
        return tabcomplete;
    }
}

