/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands.rank;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.bukkit.textcomponents.DefaultFontInfo;
import nl.svenar.powerranks.bukkit.textcomponents.PageNavigationManager;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRCache;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class cmd_listdefaultranks
extends PowerCommand {
    public cmd_listdefaultranks(PowerRanks plugin, String command_name, PowerCommand.COMMAND_EXECUTOR ce) {
        super(plugin, command_name, ce);
        this.setCommandPermission("powerranks.cmd." + command_name.toLowerCase());
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        int page = 1;
        if (args2.length > 0) {
            try {
                page = Integer.parseInt(args2[0]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(ChatColor.RED + "Invalid page number.");
                return false;
            }
        }
        PageNavigationManager pageNavigationManager = new PageNavigationManager();
        pageNavigationManager.setItemsPerPage(sender instanceof Player ? 5 : 10);
        pageNavigationManager.setMonospace(sender instanceof ConsoleCommandSender);
        pageNavigationManager.setFancyPageControls(sender instanceof Player);
        pageNavigationManager.setBaseCommand("pr listranks");
        pageNavigationManager.setItems(this.formatRankList(PRCache.getDefaultRanks(), sender instanceof ConsoleCommandSender));
        for (Object line : pageNavigationManager.getPage(page).generate()) {
            if (line instanceof String) {
                sender.sendMessage((String)line);
                continue;
            }
            if (line instanceof TextComponent) {
                sender.spigot().sendMessage((BaseComponent)((TextComponent)line));
                continue;
            }
            sender.spigot().sendMessage((BaseComponent[])line);
        }
        return false;
    }

    @Override
    public ArrayList<String> tabCompleteEvent(CommandSender sender, String[] args2) {
        ArrayList<String> tabcomplete = new ArrayList<String>();
        return tabcomplete;
    }

    private List<String> formatRankList(Set<PRRank> ranksSet, boolean hasMonospaceFont) {
        String value;
        String key;
        int longestSuffix;
        int longestPrefix;
        int longestWeight;
        int longestName;
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<PRRank> ranks = new ArrayList<PRRank>();
        for (PRRank rank : ranksSet) {
            ranks.add(rank);
        }
        PRUtil.sortRanksByWeight(ranks);
        HashMap<String, String> nameBuffer = new HashMap<String, String>();
        HashMap<String, String> weightBuffer = new HashMap<String, String>();
        HashMap<String, String> prefixBuffer = new HashMap<String, String>();
        HashMap<String, String> unformattedPrefixBuffer = new HashMap<String, String>();
        HashMap<String, String> suffixBuffer = new HashMap<String, String>();
        HashMap<String, String> unformattedSuffixBuffer = new HashMap<String, String>();
        for (PRRank prrank : ranks) {
            nameBuffer.put(prrank.getName(), prrank.getName());
            weightBuffer.put(prrank.getName(), String.valueOf(prrank.getWeight()));
            prefixBuffer.put(prrank.getName(), prrank.getPrefix());
            unformattedPrefixBuffer.put(prrank.getName(), PowerRanks.getPowerColor().removeFormat('&', prrank.getPrefix()));
            suffixBuffer.put(prrank.getName(), prrank.getSuffix());
            unformattedSuffixBuffer.put(prrank.getName(), PowerRanks.getPowerColor().removeFormat('&', prrank.getSuffix()));
        }
        if (!hasMonospaceFont) {
            int currentLength;
            int currentLength2;
            longestName = nameBuffer.values().stream().mapToInt(name -> name.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum()).max().orElse(0);
            longestWeight = weightBuffer.values().stream().mapToInt(name -> name.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum()).max().orElse(0);
            longestPrefix = unformattedPrefixBuffer.values().stream().mapToInt(name -> name.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum()).max().orElse(0);
            longestSuffix = unformattedSuffixBuffer.values().stream().mapToInt(name -> name.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum()).max().orElse(0);
            for (Map.Entry entry : nameBuffer.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                currentLength2 = value.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum();
                while (currentLength2 < longestName) {
                    value = value + " ";
                    currentLength2 = value.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum();
                }
                nameBuffer.put(key, value);
            }
            for (Map.Entry entry : weightBuffer.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                currentLength2 = value.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum();
                while (currentLength2 < longestWeight) {
                    value = " " + value;
                    currentLength2 = value.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum();
                }
                weightBuffer.put(key, value);
            }
            for (Map.Entry entry : unformattedPrefixBuffer.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                String targetValue = (String)prefixBuffer.get(key);
                currentLength = value.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum();
                while (currentLength < longestPrefix) {
                    value = value + " ";
                    targetValue = targetValue + " ";
                    currentLength = value.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum();
                }
                prefixBuffer.put(key, targetValue);
            }
            for (Map.Entry entry : unformattedSuffixBuffer.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                String targetValue = (String)suffixBuffer.get(key);
                currentLength = value.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum();
                while (currentLength < longestSuffix) {
                    value = value + " ";
                    targetValue = targetValue + " ";
                    currentLength = value.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum();
                }
                suffixBuffer.put(key, targetValue);
            }
        } else {
            String targetValue;
            int currentLength;
            longestName = nameBuffer.values().stream().mapToInt(name -> name.length()).max().orElse(0);
            longestWeight = weightBuffer.values().stream().mapToInt(name -> name.length()).max().orElse(0);
            longestPrefix = unformattedPrefixBuffer.values().stream().mapToInt(name -> name.length()).max().orElse(0);
            longestSuffix = unformattedSuffixBuffer.values().stream().mapToInt(name -> name.length()).max().orElse(0);
            for (Map.Entry entry : nameBuffer.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                currentLength = value.length();
                while (currentLength < longestName) {
                    value = value + " ";
                    currentLength = value.length();
                }
                nameBuffer.put(key, value);
            }
            for (Map.Entry entry : weightBuffer.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                currentLength = value.length();
                while (currentLength < longestWeight) {
                    value = " " + value;
                    currentLength = value.length();
                }
                weightBuffer.put(key, value);
            }
            for (Map.Entry entry : unformattedPrefixBuffer.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                currentLength = value.length();
                targetValue = (String)prefixBuffer.get(key);
                while (currentLength < longestPrefix) {
                    value = value + " ";
                    targetValue = targetValue + " ";
                    currentLength = value.length();
                }
                prefixBuffer.put(key, targetValue);
            }
            for (Map.Entry entry : unformattedSuffixBuffer.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                currentLength = value.length();
                targetValue = (String)suffixBuffer.get(key);
                while (currentLength < longestSuffix) {
                    value = value + " ";
                    targetValue = targetValue + " ";
                    currentLength = value.length();
                }
                suffixBuffer.put(key, targetValue);
            }
        }
        for (PRRank prrank : ranks) {
            String line = this.prepareMessage("list.list-rank-item", (ImmutableMap<String, String>)ImmutableMap.of((Object)"rank", (Object)((String)nameBuffer.get(prrank.getName())), (Object)"prefix", (Object)((String)prefixBuffer.get(prrank.getName())), (Object)"suffix", (Object)((String)suffixBuffer.get(prrank.getName())), (Object)"weight", (Object)((String)weightBuffer.get(prrank.getName()))), false);
            while (line.endsWith(" ") || line.toLowerCase().endsWith("\u00a7") || line.toLowerCase().endsWith("\u00a7r")) {
                line = line.substring(0, line.length() - 1);
            }
            list.add(line);
        }
        return list;
    }
}

