/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands.rank;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.bukkit.data.Users;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class cmd_addperm
extends PowerCommand {
    private Users users;

    public cmd_addperm(PowerRanks plugin, String command_name, PowerCommand.COMMAND_EXECUTOR ce) {
        super(plugin, command_name, ce);
        this.users = new Users(plugin);
        this.setCommandPermission("powerranks.cmd." + command_name.toLowerCase());
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        if (args2.length == 2) {
            boolean result;
            String rankname = args2[0].equals("*") ? args2[0] : this.users.getRankIgnoreCase(args2[0]);
            String permission = args2[1];
            boolean allowed = true;
            if (permission.startsWith("-")) {
                permission = permission.replaceFirst("-", "");
                allowed = false;
            }
            if (result = this.users.addPermission(rankname, permission, allowed)) {
                if (rankname.equals("*")) {
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".success-all"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"rank", (Object)rankname).put((Object)"permission", (Object)permission).build(), '[', ']'));
                } else {
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".success"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"rank", (Object)rankname).put((Object)"permission", (Object)permission).build(), '[', ']'));
                }
            } else {
                sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".failed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"rank", (Object)rankname).put((Object)"permission", (Object)permission).build(), '[', ']'));
            }
        } else {
            sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
        }
        return false;
    }

    @Override
    public ArrayList<String> tabCompleteEvent(CommandSender sender, String[] args2) {
        ArrayList<String> tabcomplete = new ArrayList<String>();
        if (args2.length == 1) {
            for (PRRank rank : this.users.getGroups()) {
                tabcomplete.add(rank.getName());
            }
        }
        if (args2.length == 2) {
            for (String perm : this.plugin.getPermissionRegistry().getPermissions()) {
                String userInput = args2[1];
                String autocompletePermission = "";
                if (userInput.contains(".")) {
                    CharSequence[] permSplit = perm.split("\\.");
                    for (int i = 0; i < permSplit.length; ++i) {
                        String targetPerm = String.join((CharSequence)".", permSplit);
                        while (targetPerm.endsWith(".")) {
                            targetPerm = targetPerm.substring(0, targetPerm.length() - 1);
                        }
                        if (targetPerm.contains(userInput)) {
                            autocompletePermission = targetPerm;
                            permSplit[permSplit.length - 1 - i] = "";
                            continue;
                        }
                        break;
                    }
                } else {
                    autocompletePermission = perm.split("\\.")[0];
                }
                while (autocompletePermission.endsWith(".")) {
                    autocompletePermission = autocompletePermission.substring(0, autocompletePermission.length() - 1);
                }
                if (tabcomplete.contains(autocompletePermission)) continue;
                tabcomplete.add(autocompletePermission);
            }
        }
        return tabcomplete;
    }
}

