/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands.player;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.bukkit.util.Util;
import nl.svenar.powerranks.common.structure.PRPlayer;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class cmd_nick
extends PowerCommand {
    public cmd_nick(PowerRanks plugin, String command_name, PowerCommand.COMMAND_EXECUTOR ce) {
        super(plugin, command_name, ce);
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        if (args2.length == 1) {
            if (sender instanceof Player) {
                Player targetPlayer = (Player)sender;
                String nickname = args2[0];
                if (sender.hasPermission("powerranks.cmd." + commandName.toLowerCase() + ".setown")) {
                    if (this.updateNickname(targetPlayer, nickname)) {
                        sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".setown.success"), (Map<String, String>)ImmutableMap.builder().put((Object)"target", (Object)targetPlayer.getName()).put((Object)"nickname", (Object)nickname).build(), '[', ']'));
                    } else {
                        sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".setown.failed"), (Map<String, String>)ImmutableMap.builder().put((Object)"target", (Object)targetPlayer.getName()).put((Object)"nickname", (Object)nickname).build(), '[', ']'));
                    }
                } else {
                    sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("general.no-permission"));
                }
            }
        } else if (args2.length == 2) {
            String targetPlayername = args2[0];
            Player targetPlayer = Util.getPlayerByName(targetPlayername);
            if (targetPlayer != null) {
                String nickname = args2[1];
                if (sender.hasPermission("powerranks.cmd." + commandName.toLowerCase() + ".setother")) {
                    if (this.updateNickname(targetPlayer, nickname)) {
                        targetPlayer.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".setown.success"), (Map<String, String>)ImmutableMap.builder().put((Object)"target", (Object)targetPlayer.getName()).put((Object)"nickname", (Object)nickname).build(), '[', ']'));
                        sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".setother.success"), (Map<String, String>)ImmutableMap.builder().put((Object)"target", (Object)targetPlayer.getName()).put((Object)"nickname", (Object)nickname).build(), '[', ']'));
                    } else {
                        sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".setother.failed"), (Map<String, String>)ImmutableMap.builder().put((Object)"target", (Object)targetPlayer.getName()).put((Object)"nickname", (Object)nickname).build(), '[', ']'));
                    }
                } else {
                    sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("general.no-permission"));
                }
            }
        } else if (sender.hasPermission("powerranks.cmd." + commandName.toLowerCase()) || sender.hasPermission("powerranks.cmd." + commandName.toLowerCase() + ".*")) {
            sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
        } else {
            sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("general.no-permission"));
        }
        return false;
    }

    private boolean updateNickname(Player targetPlayer, String nickname) {
        PRPlayer prPlayer = CacheManager.getPlayer(targetPlayer);
        if (prPlayer == null) {
            return false;
        }
        prPlayer.setNickname(nickname);
        return true;
    }

    @Override
    public ArrayList<String> tabCompleteEvent(CommandSender sender, String[] args2) {
        PRPlayer targetPlayer;
        ArrayList<String> tabcomplete = new ArrayList<String>();
        if (args2.length == 1) {
            for (PRPlayer prPlayer : CacheManager.getPlayers()) {
                tabcomplete.add(prPlayer.getName());
            }
        }
        if (args2.length == 2 && (targetPlayer = CacheManager.getPlayer(args2[0])) != null) {
            for (PRRank rank : CacheManager.getRanks()) {
                if (targetPlayer.hasRank(rank.getName())) continue;
                tabcomplete.add(rank.getName());
            }
        }
        return tabcomplete;
    }
}

