/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands.player;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.bukkit.data.Users;
import nl.svenar.powerranks.common.structure.PRPlayer;
import nl.svenar.powerranks.common.structure.PRPlayerRank;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class cmd_addownrank
extends PowerCommand {
    private Users users;

    public cmd_addownrank(PowerRanks plugin, String command_name, PowerCommand.COMMAND_EXECUTOR ce) {
        super(plugin, command_name, ce);
        this.users = new Users(plugin);
        this.setCommandPermission("powerranks.cmd." + command_name.toLowerCase());
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        if (args2.length == 1) {
            String target_rank = this.users.getRankIgnoreCase(args2[0]);
            boolean commandAllowed = false;
            commandAllowed = sender instanceof Player ? sender.hasPermission("powerranks.cmd." + commandName.toLowerCase() + "." + target_rank) : true;
            if (commandAllowed) {
                PRRank rank = CacheManager.getRank(this.users.getRankIgnoreCase(target_rank));
                PRPlayer targetPlayer = CacheManager.getPlayer(sender.getName());
                if (rank != null && targetPlayer != null) {
                    PRPlayerRank playerRank = new PRPlayerRank(rank.getName());
                    targetPlayer.addRank(playerRank);
                    if (Bukkit.getPlayer((UUID)targetPlayer.getUUID()) != null) {
                        PowerRanks.getInstance().updateTablistName(Bukkit.getPlayer((UUID)targetPlayer.getUUID()));
                        PowerRanks.getInstance().getTablistManager().updateSorting(Bukkit.getPlayer((UUID)targetPlayer.getUUID()));
                    }
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".success-executor"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)targetPlayer.getName()).put((Object)"rank", (Object)rank.getName()).build(), '[', ']'));
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".success-receiver"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"rank", (Object)rank.getName()).build(), '[', ']'));
                } else if (targetPlayer != null && rank != null) {
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".failed-executor"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)targetPlayer.getName()).put((Object)"rank", (Object)rank.getName()).build(), '[', ']'));
                }
            } else {
                sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("general.no-permission"));
            }
        } else {
            sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
        }
        return false;
    }

    @Override
    public ArrayList<String> tabCompleteEvent(CommandSender sender, String[] args2) {
        ArrayList<String> tabcomplete = new ArrayList<String>();
        if (args2.length == 1 && sender instanceof Player) {
            PRPlayer targetPlayer = CacheManager.getPlayer(sender.getName());
            for (PRRank rank : CacheManager.getRanks()) {
                if (targetPlayer.hasRank(rank.getName())) continue;
                tabcomplete.add(rank.getName());
            }
        }
        return tabcomplete;
    }
}

