/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands.core;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class cmd_tablist
extends PowerCommand {
    public cmd_tablist(PowerRanks plugin, String command_name, PowerCommand.COMMAND_EXECUTOR ce) {
        super(plugin, command_name, ce);
        this.setCommandPermission("powerranks.cmd." + command_name.toLowerCase());
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        if (args2.length >= 1 && args2[0].equalsIgnoreCase("animation")) {
            this.handleAnimationCommand(sender, cmd, commandLabel, commandName, Arrays.copyOfRange(args2, 1, args2.length));
        }
        if (args2.length == 2) {
            if (args2[0].equalsIgnoreCase("enable") || args2[0].equalsIgnoreCase("disable")) {
                boolean enable = args2[0].equalsIgnoreCase("enable");
                if (args2[1].equalsIgnoreCase("tablist_sorting")) {
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".state-changed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"config_target", (Object)"Tablist sorting").put((Object)"old_state", (Object)String.valueOf(PowerRanks.getTablistConfigManager().getBool("sorting.enabled", true))).put((Object)"new_state", (Object)String.valueOf(enable)).build(), '[', ']'));
                    PowerRanks.getTablistConfigManager().setBool("sorting.enabled", enable);
                    PowerRanks.getTablistConfigManager().save();
                    PowerRanks.getInstance().getTablistManager().stop();
                    PowerRanks.getInstance().getTablistManager().start();
                } else if (args2[1].equalsIgnoreCase("reverse_tablist_sorting")) {
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".state-changed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"config_target", (Object)"Reverse tablist sorting").put((Object)"old_state", (Object)String.valueOf(PowerRanks.getTablistConfigManager().getBool("sorting.reverse", true))).put((Object)"new_state", (Object)String.valueOf(enable)).build(), '[', ']'));
                    PowerRanks.getTablistConfigManager().setBool("sorting.reverse", enable);
                    PowerRanks.getTablistConfigManager().save();
                    PowerRanks.getInstance().getTablistManager().stop();
                    PowerRanks.getInstance().getTablistManager().start();
                } else if (args2[1].equalsIgnoreCase("header_footer")) {
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".state-changed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"config_target", (Object)"Header & Footer").put((Object)"old_state", (Object)String.valueOf(PowerRanks.getTablistConfigManager().getBool("header-footer.enabled", true))).put((Object)"new_state", (Object)String.valueOf(enable)).build(), '[', ']'));
                    PowerRanks.getTablistConfigManager().setBool("header-footer.enabled", enable);
                    PowerRanks.getTablistConfigManager().save();
                    PowerRanks.getInstance().getTablistManager().stop();
                    PowerRanks.getInstance().getTablistManager().start();
                } else {
                    sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
                }
            } else {
                sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
            }
        } else if (args2.length == 3) {
            if (args2[0].equalsIgnoreCase("set")) {
                if (args2[1].equalsIgnoreCase("sorting_update_interval")) {
                    try {
                        int time = Integer.parseInt(args2[2]);
                        sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".state-changed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"config_target", (Object)"Player playtime update interval").put((Object)"old_state", (Object)String.valueOf(PowerRanks.getTablistConfigManager().getInt("sorting.update-interval", 60))).put((Object)"new_state", (Object)String.valueOf(time)).build(), '[', ']'));
                        PowerRanks.getTablistConfigManager().setInt("sorting.update-interval", time);
                        PowerRanks.getTablistConfigManager().save();
                        PowerRanks.getInstance().getTablistManager().stop();
                        PowerRanks.getInstance().getTablistManager().start();
                    }
                    catch (Exception e) {
                        sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".numbers-only"));
                    }
                } else if (args2[1].equalsIgnoreCase("header_footer_update_interval")) {
                    try {
                        int time = Integer.parseInt(args2[2]);
                        sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".state-changed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"config_target", (Object)"Player playtime update interval").put((Object)"old_state", (Object)String.valueOf(PowerRanks.getTablistConfigManager().getInt("header-footer.update-interval", 60))).put((Object)"new_state", (Object)String.valueOf(time)).build(), '[', ']'));
                        PowerRanks.getTablistConfigManager().setInt("header-footer.update-interval", time);
                        PowerRanks.getTablistConfigManager().save();
                        PowerRanks.getInstance().getTablistManager().stop();
                        PowerRanks.getInstance().getTablistManager().start();
                    }
                    catch (Exception e) {
                        sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".numbers-only"));
                    }
                }
            }
        } else {
            sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
        }
        return false;
    }

    private void handleAnimationCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        if (args2.length >= 1) {
            if (args2[0].equalsIgnoreCase("list")) {
                List<String> animationNames = PowerRanks.getTablistConfigManager().getKeys("header-footer.animations");
                sender.sendMessage(ChatColor.BLUE + "===" + ChatColor.DARK_AQUA + "----------" + ChatColor.AQUA + this.plugin.getDescription().getName() + ChatColor.DARK_AQUA + "----------" + ChatColor.BLUE + "===");
                sender.sendMessage(ChatColor.AQUA + "Animations (" + animationNames.size() + "):");
                int index = 0;
                for (String animationName : animationNames) {
                    sender.sendMessage(ChatColor.DARK_GREEN + "#" + ++index + ". " + ChatColor.GRAY + animationName);
                }
                sender.sendMessage(ChatColor.BLUE + "===" + ChatColor.DARK_AQUA + "------------------------------" + ChatColor.BLUE + "===");
            } else if (args2[0].equalsIgnoreCase("create")) {
                if (args2.length == 2) {
                    String animationName = args2[1];
                    if (PRUtil.containsIgnoreCase(PowerRanks.getTablistConfigManager().getKeys("header-footer.animations"), animationName)) {
                        sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".animation.already-exists", sender instanceof Player));
                        return;
                    }
                    PowerRanks.getTablistConfigManager().setKV("header-footer.animations" + animationName + ".delay", 20);
                    PowerRanks.getTablistConfigManager().setKV("header-footer.animations" + animationName + ".frames", new ArrayList());
                    PowerRanks.getTablistConfigManager().save();
                    sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".animation.created", sender instanceof Player));
                }
            } else if (args2[0].equalsIgnoreCase("delete")) {
                if (args2.length == 2) {
                    String animationName = args2[1];
                    if (!PRUtil.containsIgnoreCase(PowerRanks.getTablistConfigManager().getKeys("header-footer.animations"), animationName)) {
                        sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".animation.does-not-exists", sender instanceof Player));
                        return;
                    }
                    PowerRanks.getTablistConfigManager().setKV("header-footer.animations" + animationName, null);
                    PowerRanks.getTablistConfigManager().save();
                    sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".animation.deleted", sender instanceof Player));
                }
            } else if (args2[0].equalsIgnoreCase("delay") && args2.length == 3) {
                try {
                    String animationName = args2[1];
                    if (!PRUtil.containsIgnoreCase(PowerRanks.getTablistConfigManager().getKeys("header-footer.animations"), animationName)) {
                        sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".animation.unknown-animation", sender instanceof Player));
                        return;
                    }
                    int time = Integer.parseInt(args2[2]);
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".state-changed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"config_target", (Object)"Tablist animation update interval").put((Object)"old_state", (Object)String.valueOf(PowerRanks.getTablistConfigManager().getInt("header-footer.animations" + animationName + ".delay", 20))).put((Object)"new_state", (Object)String.valueOf(time)).build(), '[', ']'));
                    PowerRanks.getTablistConfigManager().setInt("header-footer.animations" + animationName + ".delay", time);
                    PowerRanks.getInstance().getTablistManager().stop();
                    PowerRanks.getInstance().getTablistManager().start();
                }
                catch (Exception e) {
                    sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".numbers-only"));
                }
            }
        } else {
            sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".animation.arguments", sender instanceof Player));
        }
    }

    @Override
    public ArrayList<String> tabCompleteEvent(CommandSender sender, String[] args2) {
        ArrayList<String> tabcomplete = new ArrayList<String>();
        if (args2.length == 1) {
            tabcomplete.add("enable");
            tabcomplete.add("disable");
            tabcomplete.add("set");
            tabcomplete.add("animation");
        }
        if (args2.length == 2) {
            if (args2[0].equalsIgnoreCase("enable") || args2[0].equalsIgnoreCase("disable")) {
                tabcomplete.add("tablist_sorting");
                tabcomplete.add("reverse_tablist_sorting");
                tabcomplete.add("header_footer");
            }
            if (args2[0].equalsIgnoreCase("animation")) {
                tabcomplete.add("list");
                tabcomplete.add("create");
                tabcomplete.add("delete");
                tabcomplete.add("delay");
            }
            if (args2[0].equalsIgnoreCase("set")) {
                tabcomplete.add("sorting_update_interval");
                tabcomplete.add("header_footer_update_interval");
            }
        }
        if (args2.length == 3) {
            if (args2[0].equalsIgnoreCase("set")) {
                if (args2[1].equalsIgnoreCase("sorting_update_interval")) {
                    tabcomplete.add("1");
                    tabcomplete.add("5");
                    tabcomplete.add("10");
                }
                if (args2[1].equalsIgnoreCase("header_footer_update_interval")) {
                    tabcomplete.add("1");
                    tabcomplete.add("5");
                    tabcomplete.add("20");
                    tabcomplete.add("100");
                    tabcomplete.add("200");
                }
            }
            if (args2[0].equalsIgnoreCase("animation")) {
                if (args2[1].equalsIgnoreCase("delete")) {
                    for (String key : PowerRanks.getTablistConfigManager().getKeys("header-footer.animations")) {
                        tabcomplete.add(key);
                    }
                }
                if (args2[1].equalsIgnoreCase("delay")) {
                    tabcomplete.add("1");
                    tabcomplete.add("5");
                    tabcomplete.add("10");
                }
            }
        }
        return tabcomplete;
    }
}

