/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands.core;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.bukkit.data.PowerPermissibleBase;
import nl.svenar.powerranks.bukkit.textcomponents.DefaultFontInfo;
import nl.svenar.powerranks.bukkit.textcomponents.PageNavigationManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class cmd_permissionlookups
extends PowerCommand {
    private final int maxResultsConsole = 20;
    private final int maxResultsPlayer = 10;

    public cmd_permissionlookups(PowerRanks plugin, String command_name, PowerCommand.COMMAND_EXECUTOR ce) {
        super(plugin, command_name, ce);
        this.setCommandPermission("powerranks.cmd." + command_name.toLowerCase());
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        int page = 1;
        if (args2.length > 0) {
            try {
                page = Integer.parseInt(args2[0]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(ChatColor.RED + "Invalid page number.");
                return false;
            }
        }
        Map<String, Integer> permissionCallCount = PowerPermissibleBase.permissionCallCount;
        permissionCallCount = this.sortByValue(permissionCallCount, false);
        ArrayList<PRCallCount> callCounts = new ArrayList<PRCallCount>();
        for (Map.Entry<String, Integer> entry : permissionCallCount.entrySet()) {
            callCounts.add(new PRCallCount(entry.getKey(), entry.getValue()));
        }
        PageNavigationManager pageNavigationManager = new PageNavigationManager();
        pageNavigationManager.setItemsPerPage(sender instanceof Player ? 10 : 20);
        pageNavigationManager.setMonospace(sender instanceof ConsoleCommandSender);
        pageNavigationManager.setFancyPageControls(sender instanceof Player);
        pageNavigationManager.setBaseCommand("pr permissionlookups");
        pageNavigationManager.setItems(this.formatPermissionCountList(callCounts, sender instanceof ConsoleCommandSender));
        for (Object line : pageNavigationManager.getPage(page).generate()) {
            if (line instanceof String) {
                sender.sendMessage((String)line);
                continue;
            }
            if (line instanceof TextComponent) {
                sender.spigot().sendMessage((BaseComponent)((TextComponent)line));
                continue;
            }
            sender.spigot().sendMessage((BaseComponent[])line);
        }
        sender.sendMessage(PowerRanks.chatColor("&7callcount &apermissio&2.&anode", true));
        sender.sendMessage(PowerRanks.chatColor("&7Total called permissions: " + permissionCallCount.size(), true));
        return false;
    }

    private Map<String, Integer> sortByValue(Map<String, Integer> permissionCallCount, boolean asc) {
        LinkedList<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(permissionCallCount.entrySet());
        Collections.sort(list, (o1, o2) -> {
            if (asc) {
                return ((Integer)o1.getValue()).compareTo((Integer)o2.getValue());
            }
            return ((Integer)o2.getValue()).compareTo((Integer)o1.getValue());
        });
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : list) {
            result.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return result;
    }

    @Override
    public ArrayList<String> tabCompleteEvent(CommandSender sender, String[] args2) {
        ArrayList<String> tabcomplete = new ArrayList<String>();
        return tabcomplete;
    }

    private List<String> formatPermissionCountList(List<PRCallCount> prCallCounts, boolean hasMonospaceFont) {
        int currentLength;
        String value;
        String key;
        int longestCount;
        int longestName;
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, String> permissionNameBuffer = new HashMap<String, String>();
        HashMap<String, String> countBuffer = new HashMap<String, String>();
        for (PRCallCount prcc : prCallCounts) {
            permissionNameBuffer.put(prcc.getName(), prcc.getName());
            countBuffer.put(prcc.getName(), String.valueOf(prcc.getCount()));
        }
        if (!hasMonospaceFont) {
            longestName = permissionNameBuffer.values().stream().mapToInt(name -> name.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum()).max().orElse(0);
            longestCount = countBuffer.values().stream().mapToInt(name -> name.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum()).max().orElse(0);
            for (Map.Entry entry : permissionNameBuffer.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                currentLength = value.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum();
                while (currentLength < longestName) {
                    value = value + " ";
                    currentLength = value.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum();
                }
                permissionNameBuffer.put(key, value);
            }
            for (Map.Entry entry : countBuffer.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                currentLength = value.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum();
                while (currentLength < longestCount) {
                    value = " " + value;
                    currentLength = value.chars().map(c -> DefaultFontInfo.getDefaultFontInfo((char)c).getLength()).sum();
                }
                countBuffer.put(key, value);
            }
        } else {
            longestName = permissionNameBuffer.values().stream().mapToInt(name -> name.length()).max().orElse(0);
            longestCount = countBuffer.values().stream().mapToInt(name -> name.length()).max().orElse(0);
            for (Map.Entry entry : permissionNameBuffer.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                currentLength = value.length();
                while (currentLength < longestName) {
                    value = value + " ";
                    currentLength = value.length();
                }
                permissionNameBuffer.put(key, value);
            }
            for (Map.Entry entry : countBuffer.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                currentLength = value.length();
                while (currentLength < longestCount) {
                    value = " " + value;
                    currentLength = value.length();
                }
                countBuffer.put(key, value);
            }
        }
        for (PRCallCount prcc : prCallCounts) {
            String line = this.prepareMessage("list.list-permissioncallcount-item", (ImmutableMap<String, String>)ImmutableMap.of((Object)"permission", (Object)("&a" + ((String)permissionNameBuffer.get(prcc.getName())).replaceAll("\\.", "&2.&a")), (Object)"callcount", (Object)((String)countBuffer.get(prcc.getName()))), false);
            while (line.endsWith(" ") || line.toLowerCase().endsWith("\u00a7") || line.toLowerCase().endsWith("\u00a7r")) {
                line = line.substring(0, line.length() - 1);
            }
            list.add(line);
        }
        return list;
    }

    private class PRCallCount {
        private final String name;
        private final int count;

        public PRCallCount(String name, int count) {
            this.name = name;
            this.count = count;
        }

        public String getName() {
            return this.name;
        }

        public int getCount() {
            return this.count;
        }
    }
}

