/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands.core;

import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.svenar.lib.fasterxml.jackson.core.JsonProcessingException;
import nl.svenar.lib.fasterxml.jackson.databind.ObjectMapper;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.bukkit.data.PowerRanksVerbose;
import nl.svenar.powerranks.common.http.DatabinClient;
import nl.svenar.powerranks.common.storage.PowerStorageManager;
import nl.svenar.powerranks.common.storage.provided.JSONStorageManager;
import nl.svenar.powerranks.common.utils.AsyncReadFile;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class cmd_dump
extends PowerCommand {
    private String databin_url = "https://databin.svenar.nl";
    private String logs_powerranks_url = "https://logs.powerranks.nl/dump/?id=";
    ArrayList<String> serverLog = new ArrayList();
    Map<String, Object> coreData = new HashMap<String, Object>();

    public cmd_dump(PowerRanks plugin, String command_name, PowerCommand.COMMAND_EXECUTOR ce) {
        super(plugin, command_name, ce);
        this.setCommandPermission("powerranks.cmd." + command_name.toLowerCase());
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        if (sender instanceof Player) {
            sender.sendMessage(ChatColor.DARK_AQUA + "--------" + ChatColor.DARK_BLUE + PowerRanks.pdf.getName() + ChatColor.DARK_AQUA + "--------");
            sender.sendMessage(ChatColor.GREEN + "Dump has started collecting data!");
            sender.sendMessage(ChatColor.GREEN + "Check the server console for more information.");
            sender.sendMessage(ChatColor.DARK_AQUA + "--------------------------");
        }
        this.prepareLog(sender, commandName);
        return false;
    }

    @Override
    public ArrayList<String> tabCompleteEvent(CommandSender sender, String[] args2) {
        ArrayList<String> tabcomplete = new ArrayList<String>();
        return tabcomplete;
    }

    private void readServerLog() {
        this.serverLog.clear();
        String serverPath = this.plugin.getServer().getWorldContainer().getAbsolutePath();
        File serverLogFile = new File(serverPath.substring(0, serverPath.length() - 1), "logs/latest.log");
        final AsyncReadFile arf = new AsyncReadFile();
        arf.setFile(serverLogFile.getPath());
        final long totalLength = arf.getFileLength();
        arf.read();
        new BukkitRunnable(){
            Instant startTime = Instant.now();
            int progressTimerIndex = Integer.MAX_VALUE;

            public void run() {
                if (!arf.isReady()) {
                    if (this.progressTimerIndex > 200) {
                        this.progressTimerIndex = 0;
                        int currentLength = arf.getData().length();
                        PowerRanks.getInstance().getLogger().info("Reading server log... (" + (long)(100 * currentLength) / totalLength + "%)");
                    }
                    ++this.progressTimerIndex;
                    return;
                }
                PowerRanks.getInstance().getLogger().info("Server log:");
                PowerRanks.getInstance().getLogger().info("- Removing sensitive information from server log...");
                for (String line : arf.getData().split("\n")) {
                    cmd_dump.this.serverLog.add(cmd_dump.this.removeIP(line).replaceAll("\"", "'"));
                }
                PowerRanks.getInstance().getLogger().info("- Reading took " + Duration.between(this.startTime, Instant.now()).toMillis() + "ms");
                PowerRanks.getInstance().getLogger().info("- Read " + arf.getData().split("\n").length + " lines (" + arf.getData().length() + " characters)!");
                this.cancel();
                PowerRanks.getInstance().getLogger().info("");
            }
        }.runTaskTimer((Plugin)PowerRanks.getInstance(), 0L, 1L);
    }

    private void readCoreData() {
        this.coreData = new HashMap<String, Object>();
        new BukkitRunnable(){
            Instant startTime = Instant.now();

            public void run() {
                PowerRanks.getInstance().getLogger().info("Plugin data:");
                JSONStorageManager jsonmanager = new JSONStorageManager(PowerRanks.fileLoc, "dummyRanks.json", "dummyPlayers.json");
                PowerStorageManager powermanager = CacheManager.getStorageManager();
                jsonmanager.setRanks(powermanager.getRanks());
                jsonmanager.setPlayers(powermanager.getPlayers());
                cmd_dump.this.coreData.put("rankdata", jsonmanager.getRanksAsMap());
                cmd_dump.this.coreData.put("playerdata", jsonmanager.getPlayersAsMap());
                cmd_dump.this.coreData.put("config", PowerRanks.getConfigManager().getRawData());
                cmd_dump.this.coreData.put("usertags", PowerRanks.getUsertagManager().getRawData().get("usertags"));
                PowerRanks.getInstance().getLogger().info("- Reading took " + Duration.between(this.startTime, Instant.now()).toMillis() + "ms");
                PowerRanks.getInstance().getLogger().info("- Read " + jsonmanager.getRanks().size() + " ranks and " + jsonmanager.getPlayers().size() + " players!");
                PowerRanks.getInstance().getLogger().info("- Adding configuration & usertags");
                jsonmanager.removeAllData();
                PowerRanks.getInstance().getLogger().info("");
                this.cancel();
            }
        }.runTaskTimer((Plugin)PowerRanks.getInstance(), 0L, 1L);
    }

    private void prepareLog(CommandSender sender, String commandName) {
        PowerRanks.getInstance().getLogger().info("");
        PowerRanks.getInstance().getLogger().info("=== -------------------------------- ===");
        PowerRanks.getInstance().getLogger().info("     PowerRanks is collecting data!     ");
        PowerRanks.getInstance().getLogger().info("=== -------------------------------- ===");
        this.readServerLog();
        this.readCoreData();
        new BukkitRunnable(){
            Instant startTime = Instant.now();
            int progressIndex = 0;
            Map<String, Object> elements = new HashMap<String, Object>();
            boolean serverLogDone = false;
            boolean coreDataDone = false;

            public void run() {
                if (cmd_dump.this.serverLog.size() > 0) {
                    Plugin[] plugins;
                    PowerRanks.getInstance().getLogger().info("Server log found!");
                    this.elements.put("type", "dump");
                    this.elements.put("version", new HashMap());
                    ((Map)this.elements.get("version")).put("powerranks", PowerRanks.pdf.getVersion());
                    ((Map)this.elements.get("version")).put("server", Bukkit.getVersion() + " | " + Bukkit.getServer().getBukkitVersion());
                    String pluginData = "";
                    for (Plugin plugin : plugins = Bukkit.getPluginManager().getPlugins()) {
                        pluginData = pluginData + plugin.getName() + "(" + plugin.getDescription().getVersion() + "),";
                    }
                    pluginData = pluginData.substring(0, pluginData.length() - 1);
                    this.elements.put("plugins", pluginData);
                    this.elements.put("serverlog", Arrays.asList(cmd_dump.this.serverLog));
                    cmd_dump.this.serverLog = new ArrayList();
                    this.serverLogDone = true;
                }
                if (cmd_dump.this.coreData.keySet().size() > 0) {
                    PowerRanks.getInstance().getLogger().info("Core data found!");
                    this.elements.put("coredata", cmd_dump.this.coreData);
                    cmd_dump.this.coreData = new HashMap<String, Object>();
                    this.coreDataDone = true;
                }
                if (this.serverLogDone && this.coreDataDone) {
                    PowerRanks.getInstance().getLogger().info("Data collected successfully in " + Duration.between(this.startTime, Instant.now()).toMillis() + "ms, uploading...");
                    this.startTime = Instant.now();
                    try {
                        ObjectMapper objectMapper = new ObjectMapper();
                        String json = objectMapper.writeValueAsString(this.elements);
                        cmd_dump.this.uploadDump(json);
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                    PowerRanks.getInstance().getLogger().info("Done! Uploading took " + Duration.between(this.startTime, Instant.now()).toMillis() + "ms");
                    this.cancel();
                } else {
                    ++this.progressIndex;
                    if (this.progressIndex > 1200) {
                        PowerRanks.getInstance().getLogger().info("Failed to dump data!");
                        PowerRanks.getInstance().getLogger().info("Timed out after " + Duration.between(this.startTime, Instant.now()).toMillis() + "ms!");
                        this.cancel();
                    }
                }
            }
        }.runTaskTimer((Plugin)PowerRanks.getInstance(), 0L, 1L);
    }

    private void uploadDump(String outputJSON) {
        final DatabinClient client = new DatabinClient(this.databin_url, "Databinclient/1.0");
        final int uploadSize = outputJSON.length() / 1024;
        PowerRanks.getInstance().getLogger().info("Uploading " + uploadSize + "KB, please wait...");
        client.postJSON(outputJSON);
        final int updateInterval = 5;
        final int timeout2 = 5;
        new BukkitRunnable(){
            int waitTime = 0;

            public void run() {
                PowerRanksVerbose.log("task", "Running task uploading dump data");
                if (client.hasResponse()) {
                    Map<String, String> response = client.getResponse();
                    if (response.keySet().contains("key")) {
                        String key = response.get("key");
                        if (key.length() > 0 && !key.startsWith("[FAILED]")) {
                            PowerRanks.getInstance().getLogger().info("");
                            PowerRanks.getInstance().getLogger().info("===----------" + PowerRanks.pdf.getName() + "----------===");
                            PowerRanks.getInstance().getLogger().info("Data upload is ready [" + cmd_dump.this.logs_powerranks_url + key + "]");
                            PowerRanks.getInstance().getLogger().info("ID: " + key);
                            PowerRanks.getInstance().getLogger().info("Uploaded: " + uploadSize + "KB");
                            PowerRanks.getInstance().getLogger().info("===------------------------------===");
                        } else {
                            PowerRanks.getInstance().getLogger().info("Uploading dump failed, received server error!");
                        }
                    }
                    this.cancel();
                }
                if (this.waitTime / (20 / updateInterval) > timeout2) {
                    PowerRanks.getInstance().getLogger().info("Uploading dump timed-out!");
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)PowerRanks.getInstance(), 0L, (long)updateInterval);
    }

    private String removeIP(String line) {
        String output = line;
        String ipExp = "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}";
        Pattern ipPattern = Pattern.compile(ipExp);
        Matcher matcher = ipPattern.matcher(output);
        output = matcher.replaceAll("<<IP_HIDDEN>>");
        return output;
    }
}

