/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands.core;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class cmd_config
extends PowerCommand {
    public cmd_config(PowerRanks plugin, String command_name, PowerCommand.COMMAND_EXECUTOR ce) {
        super(plugin, command_name, ce);
        this.setCommandPermission("powerranks.cmd." + command_name.toLowerCase());
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        if (args2.length == 1) {
            if (args2[0].equalsIgnoreCase("removeworldtag")) {
                int end;
                int start;
                String world_tag_regex = "[ ]{0,1}([&][a-fA-F0-9k-oK-OrR]){0,1}((&){0,1}[#][a-fA-F0-9]{6}){0,1}[ ]{0,1}[\\[]world[\\]][ ]{0,1}([&][a-fA-F0-9k-oK-OrR]){0,1}((&){0,1}[#][a-fA-F0-9]{6}){0,1}[ ]{0,1}";
                Pattern world_tag_pattern = Pattern.compile(world_tag_regex);
                Matcher world_tag_matcher_chat = world_tag_pattern.matcher(PowerRanks.getConfigManager().getString("chat.format", "").toLowerCase());
                Matcher world_tag_matcher_tab = world_tag_pattern.matcher(PowerRanks.getConfigManager().getString("tablist_modification.format", "").toLowerCase());
                while (world_tag_matcher_chat.find()) {
                    start = world_tag_matcher_chat.start();
                    end = world_tag_matcher_chat.end();
                    PowerRanks.getConfigManager().setString("chat.format", PowerRanks.getConfigManager().getString("chat.format", "").replace(PowerRanks.getConfigManager().getString("chat.format", "").substring(start, end), ""));
                }
                while (world_tag_matcher_tab.find()) {
                    start = world_tag_matcher_tab.start();
                    end = world_tag_matcher_tab.end();
                    PowerRanks.getConfigManager().setString("tablist_modification.format", PowerRanks.getConfigManager().getString("tablist_modification.format", "").replace(PowerRanks.getConfigManager().getString("tablist_modification.format", "").substring(start, end), ""));
                }
                this.plugin.updateAllPlayersTABlist();
                sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".removed-world-tag"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).build(), '[', ']'));
            } else {
                sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
            }
        } else if (args2.length == 2) {
            if (args2[0].equalsIgnoreCase("enable") || args2[0].equalsIgnoreCase("disable")) {
                boolean enable = args2[0].equalsIgnoreCase("enable");
                if (args2[1].equalsIgnoreCase("chat_formatting")) {
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".state-changed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"config_target", (Object)"Chat formatting").put((Object)"old_state", (Object)String.valueOf(PowerRanks.getConfigManager().getBool("chat.enabled", true))).put((Object)"new_state", (Object)String.valueOf(enable)).build(), '[', ']'));
                    PowerRanks.getConfigManager().setBool("chat.enabled", enable);
                } else if (args2[1].equalsIgnoreCase("tablist_formatting")) {
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".state-changed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"config_target", (Object)"Tablist formatting").put((Object)"old_state", (Object)String.valueOf(PowerRanks.getConfigManager().getBool("tablist_modification.enabled", true))).put((Object)"new_state", (Object)String.valueOf(enable)).build(), '[', ']'));
                    PowerRanks.getConfigManager().setBool("tablist_modification.enabled", enable);
                } else if (args2[1].equalsIgnoreCase("casesensitive_permissions")) {
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".state-changed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"config_target", (Object)"Case Sensitive Permissions").put((Object)"old_state", (Object)String.valueOf(PowerRanks.getConfigManager().getBool("general.case-sensitive-permissions", true))).put((Object)"new_state", (Object)String.valueOf(enable)).build(), '[', ']'));
                    PowerRanks.getConfigManager().setBool("general.case-sensitive-permissions", enable);
                } else if (args2[1].equalsIgnoreCase("op")) {
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".state-changed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"config_target", (Object)"Op command").put((Object)"old_state", (Object)String.valueOf(!PowerRanks.getConfigManager().getBool("general.disable-op", true))).put((Object)"new_state", (Object)String.valueOf(enable)).build(), '[', ']'));
                    PowerRanks.getConfigManager().setBool("general.disable-op", !enable);
                } else if (args2[1].equalsIgnoreCase("bungeecord")) {
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".state-changed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"config_target", (Object)"Bungeecord integration").put((Object)"old_state", (Object)String.valueOf(PowerRanks.getConfigManager().getBool("bungeecord.enabled", false))).put((Object)"new_state", (Object)String.valueOf(enable)).build(), '[', ']'));
                    PowerRanks.getConfigManager().setBool("bungeecord.enabled", enable);
                } else {
                    sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
                }
            } else {
                sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
            }
        } else if (args2.length == 3) {
            if (args2[0].equalsIgnoreCase("set")) {
                if (args2[1].equalsIgnoreCase("playtime_update_interval")) {
                    try {
                        int time = Integer.parseInt(args2[2]);
                        sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".state-changed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"config_target", (Object)"Player playtime update interval").put((Object)"old_state", (Object)String.valueOf(PowerRanks.getConfigManager().getInt("general.playtime-update-interval", 60))).put((Object)"new_state", (Object)String.valueOf(time)).build(), '[', ']'));
                        PowerRanks.getConfigManager().setInt("general.playtime-update-interval", time);
                    }
                    catch (Exception e) {
                        sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".numbers-only"));
                    }
                }
            } else if (args2[1].equalsIgnoreCase("language")) {
                sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".state-changed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"config_target", (Object)"PowerRanks language (lang.yml)").put((Object)"old_state", (Object)String.valueOf(PowerRanks.getConfigManager().getString("general.language", "en"))).put((Object)"new_state", (Object)args2[2]).build(), '[', ']'));
                PowerRanks.getConfigManager().setString("general.language", args2[2]);
            } else if (args2[1].equalsIgnoreCase("bungeecord_server_name")) {
                sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".state-changed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"config_target", (Object)"PowerRanks Bungeecord server name").put((Object)"old_state", (Object)String.valueOf(PowerRanks.getConfigManager().getString("bungeecors.server-name", "Global"))).put((Object)"new_state", (Object)args2[2]).build(), '[', ']'));
                PowerRanks.getConfigManager().setString("bungeecors.server-name", args2[2]);
            } else if (args2[1].equalsIgnoreCase("autosave_files_interval")) {
                try {
                    int time = Integer.parseInt(args2[2]);
                    sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".state-changed"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"config_target", (Object)"Data autosave interval").put((Object)"old_state", (Object)String.valueOf(PowerRanks.getConfigManager().getInt("general.autosave-files-interval", 600))).put((Object)"new_state", (Object)String.valueOf(time)).build(), '[', ']'));
                    PowerRanks.getConfigManager().setInt("general.autosave-files-interval", time);
                }
                catch (Exception e) {
                    sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".numbers-only"));
                }
            }
        } else {
            sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
        }
        return false;
    }

    @Override
    public ArrayList<String> tabCompleteEvent(CommandSender sender, String[] args2) {
        ArrayList<String> tabcomplete = new ArrayList<String>();
        if (args2.length == 1) {
            tabcomplete.add("removeworldtag");
            tabcomplete.add("enable");
            tabcomplete.add("disable");
            tabcomplete.add("set");
        }
        if (args2.length == 2 && (args2[0].equalsIgnoreCase("enable") || args2[0].equalsIgnoreCase("disable"))) {
            tabcomplete.add("chat_formatting");
            tabcomplete.add("tablist_formatting");
            tabcomplete.add("casesensitive_permissions");
            tabcomplete.add("op");
            tabcomplete.add("bungeecord");
        }
        if (args2.length == 2 && args2[0].equalsIgnoreCase("set")) {
            tabcomplete.add("language");
            tabcomplete.add("autosave_files_interval");
            tabcomplete.add("playtime_update_interval");
            tabcomplete.add("bungeecord_server_name");
        }
        if (args2.length == 3 && args2[1].equalsIgnoreCase("language")) {
            for (String key : PowerRanks.getLanguageManager().getInstance().getKeys("lang")) {
                tabcomplete.add(key);
            }
        }
        if (args2.length == 3 && args2[1].equalsIgnoreCase("autosave_files_interval")) {
            tabcomplete.add("60");
            tabcomplete.add("300");
            tabcomplete.add("600");
            tabcomplete.add("1800");
            tabcomplete.add("3600");
        }
        if (args2.length == 3 && args2[1].equalsIgnoreCase("playtime_update_interval")) {
            tabcomplete.add("1");
            tabcomplete.add("5");
            tabcomplete.add("10");
            tabcomplete.add("60");
        }
        return tabcomplete;
    }
}

