/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands.buyable;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.bukkit.data.Messages;
import nl.svenar.powerranks.bukkit.data.Users;
import nl.svenar.powerranks.bukkit.external.VaultHook;
import nl.svenar.powerranks.common.structure.PRPlayerRank;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class cmd_buyrank
extends PowerCommand {
    private Users users;

    public cmd_buyrank(PowerRanks plugin, String command_name, PowerCommand.COMMAND_EXECUTOR ce) {
        super(plugin, command_name, ce);
        this.users = new Users(plugin);
        this.setCommandPermission("powerranks.cmd." + command_name.toLowerCase());
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        Player player = (Player)sender;
        if (PowerRanks.vaultEconomyEnabled) {
            if (args2.length == 0) {
                Messages.messageCommandBuyrank(sender, this.users, null);
            } else if (args2.length == 1) {
                String rankname = this.users.getRankIgnoreCase(args2[0]);
                Messages.messageCommandBuyrank(sender, this.users, rankname);
            } else if (args2.length == 2) {
                String rankname = this.users.getRankIgnoreCase(args2[0]);
                boolean confirm = args2[1].equalsIgnoreCase("confirm");
                if (confirm) {
                    double player_balance;
                    float cost = CacheManager.getRank(rankname).getBuyCost();
                    double d = player_balance = VaultHook.getVaultEconomy() != null ? VaultHook.getVaultEconomy().getBalance((OfflinePlayer)player) : 0.0;
                    if (cost >= 0.0f && player_balance >= (double)cost) {
                        VaultHook.getVaultEconomy().withdrawPlayer((OfflinePlayer)player, (double)cost);
                        PRRank rank = CacheManager.getRank(this.users.getRankIgnoreCase(rankname));
                        if (rank != null && rank != null) {
                            PRPlayerRank playerRank = new PRPlayerRank(rank.getName());
                            CacheManager.getPlayer(player.getUniqueId().toString()).setRank(playerRank);
                            sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".success-buy"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"rank", (Object)rank.getName()).build(), '[', ']'));
                        }
                        if (PowerRanks.getConfigManager().getBool("rankup.buy_command.enabled", false) && PowerRanks.getConfigManager().getString("rankup.buy_command.command", "").length() > 0) {
                            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), PowerRanks.getConfigManager().getString("rankup.buy_command.command", "").replaceAll("%playername%", sender.getName()).replaceAll("%rankname%", rankname));
                        }
                    } else {
                        sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".failed-buy-not-enough-money"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"rank", (Object)rankname).build(), '[', ']'));
                    }
                }
            } else {
                sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
            }
        } else {
            sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".buy-not-available"));
        }
        return false;
    }

    @Override
    public ArrayList<String> tabCompleteEvent(CommandSender sender, String[] args2) {
        ArrayList<String> tabcomplete = new ArrayList<String>();
        if (args2.length == 1) {
            for (String rank : this.users.getBuyableRanks(this.users.getPrimaryRank((Player)sender))) {
                tabcomplete.add(rank);
            }
        }
        if (args2.length == 2) {
            tabcomplete.add("confirm");
        }
        return tabcomplete;
    }
}

