/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands.addons;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.addons.PowerRanksAddon;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class cmd_addoninfo
extends PowerCommand {
    public cmd_addoninfo(PowerRanks plugin, String command_name, PowerCommand.COMMAND_EXECUTOR ce) {
        super(plugin, command_name, ce);
        this.setCommandPermission("powerranks.cmd." + command_name.toLowerCase());
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String commandName, String[] args2) {
        if (args2.length == 1) {
            String addon_name = args2[0];
            PowerRanksAddon addon = null;
            for (Map.Entry<File, PowerRanksAddon> a : this.plugin.addonsManager.addonClasses.entrySet()) {
                if (!a.getValue().getIdentifier().equalsIgnoreCase(addon_name)) continue;
                addon = a.getValue();
            }
            if (addon != null) {
                sender.sendMessage(ChatColor.BLUE + "===" + ChatColor.DARK_AQUA + "----------" + ChatColor.AQUA + this.plugin.getDescription().getName() + ChatColor.DARK_AQUA + "----------" + ChatColor.BLUE + "===");
                sender.sendMessage(ChatColor.DARK_GREEN + "Add-on name: " + ChatColor.GREEN + addon.getIdentifier());
                sender.sendMessage(ChatColor.DARK_GREEN + "Author: " + ChatColor.GREEN + addon.getAuthor());
                sender.sendMessage(ChatColor.DARK_GREEN + "Version: " + ChatColor.GREEN + addon.getVersion());
                sender.sendMessage(ChatColor.DARK_GREEN + "Registered Commands:");
                for (String command : addon.getRegisteredCommands()) {
                    sender.sendMessage(ChatColor.GREEN + "- /" + commandLabel + " " + command);
                }
                sender.sendMessage(ChatColor.DARK_GREEN + "Registered Permissions:");
                for (String permission : addon.getRegisteredPermissions()) {
                    sender.sendMessage(ChatColor.GREEN + "- " + permission);
                }
                sender.sendMessage(ChatColor.BLUE + "===" + ChatColor.DARK_AQUA + "------------------------------" + ChatColor.BLUE + "===");
            } else {
                sender.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("commands." + commandName.toLowerCase() + ".failed-addon-not-found"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)sender.getName()).put((Object)"addon", (Object)addon_name).build(), '[', ']'));
            }
        } else {
            sender.sendMessage(PowerRanks.getLanguageManager().getFormattedUsageMessage(commandLabel, commandName, "commands." + commandName.toLowerCase() + ".arguments", sender instanceof Player));
        }
        return false;
    }

    @Override
    public ArrayList<String> tabCompleteEvent(CommandSender sender, String[] args2) {
        ArrayList<String> tabcomplete = new ArrayList<String>();
        for (Map.Entry<File, PowerRanksAddon> addon : this.plugin.addonsManager.addonClasses.entrySet()) {
            tabcomplete.add(addon.getValue().getIdentifier());
        }
        return tabcomplete;
    }
}

