/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.addons.PowerRanksAddon;
import nl.svenar.powerranks.bukkit.addons.PowerRanksPlayer;
import nl.svenar.powerranks.bukkit.commands.PowerCommand;
import nl.svenar.powerranks.bukkit.commands.addons.cmd_addoninfo;
import nl.svenar.powerranks.bukkit.commands.addons.cmd_addonmanager;
import nl.svenar.powerranks.bukkit.commands.addons.cmd_listaddons;
import nl.svenar.powerranks.bukkit.commands.buyable.cmd_addbuyablerank;
import nl.svenar.powerranks.bukkit.commands.buyable.cmd_buyrank;
import nl.svenar.powerranks.bukkit.commands.buyable.cmd_delbuyablerank;
import nl.svenar.powerranks.bukkit.commands.buyable.cmd_rankup;
import nl.svenar.powerranks.bukkit.commands.buyable.cmd_setbuycommand;
import nl.svenar.powerranks.bukkit.commands.buyable.cmd_setbuycost;
import nl.svenar.powerranks.bukkit.commands.buyable.cmd_setbuydescription;
import nl.svenar.powerranks.bukkit.commands.core.cmd_config;
import nl.svenar.powerranks.bukkit.commands.core.cmd_dump;
import nl.svenar.powerranks.bukkit.commands.core.cmd_factoryreset;
import nl.svenar.powerranks.bukkit.commands.core.cmd_help;
import nl.svenar.powerranks.bukkit.commands.core.cmd_permissionlookups;
import nl.svenar.powerranks.bukkit.commands.core.cmd_pluginhook;
import nl.svenar.powerranks.bukkit.commands.core.cmd_reload;
import nl.svenar.powerranks.bukkit.commands.core.cmd_stats;
import nl.svenar.powerranks.bukkit.commands.core.cmd_tablist;
import nl.svenar.powerranks.bukkit.commands.core.cmd_verbose;
import nl.svenar.powerranks.bukkit.commands.player.cmd_addownrank;
import nl.svenar.powerranks.bukkit.commands.player.cmd_addplayerperm;
import nl.svenar.powerranks.bukkit.commands.player.cmd_addrank;
import nl.svenar.powerranks.bukkit.commands.player.cmd_checkrank;
import nl.svenar.powerranks.bukkit.commands.player.cmd_delplayerperm;
import nl.svenar.powerranks.bukkit.commands.player.cmd_delrank;
import nl.svenar.powerranks.bukkit.commands.player.cmd_haspermission;
import nl.svenar.powerranks.bukkit.commands.player.cmd_listplayerpermissions;
import nl.svenar.powerranks.bukkit.commands.player.cmd_nick;
import nl.svenar.powerranks.bukkit.commands.player.cmd_playerinfo;
import nl.svenar.powerranks.bukkit.commands.player.cmd_setownrank;
import nl.svenar.powerranks.bukkit.commands.player.cmd_setrank;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_addinheritance;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_addperm;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_createrank;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_deleterank;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_delinheritance;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_delperm;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_listdefaultranks;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_listpermissions;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_listranks;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_rankinfo;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_renamerank;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_setchatcolor;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_setdefault;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_setnamecolor;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_setprefix;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_setsuffix;
import nl.svenar.powerranks.bukkit.commands.rank.cmd_setweight;
import nl.svenar.powerranks.bukkit.commands.test.cmd_test;
import nl.svenar.powerranks.bukkit.commands.usertags.cmd_addusertag;
import nl.svenar.powerranks.bukkit.commands.usertags.cmd_clearusertag;
import nl.svenar.powerranks.bukkit.commands.usertags.cmd_createusertag;
import nl.svenar.powerranks.bukkit.commands.usertags.cmd_delusertag;
import nl.svenar.powerranks.bukkit.commands.usertags.cmd_editusertag;
import nl.svenar.powerranks.bukkit.commands.usertags.cmd_listusertags;
import nl.svenar.powerranks.bukkit.commands.usertags.cmd_removeusertag;
import nl.svenar.powerranks.bukkit.commands.usertags.cmd_setusertag;
import nl.svenar.powerranks.bukkit.commands.webeditor.cmd_webeditor;
import org.bukkit.ChatColor;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class PowerCommandHandler
implements CommandExecutor {
    private static HashMap<String, PowerCommand> power_commands = new HashMap();
    private PowerRanks plugin;

    public PowerCommandHandler(PowerRanks plugin) {
        this.plugin = plugin;
        new cmd_help(plugin, "help", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_reload(plugin, "reload", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_verbose(plugin, "verbose", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_pluginhook(plugin, "pluginhook", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_config(plugin, "config", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_tablist(plugin, "tablist", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_stats(plugin, "stats", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_factoryreset(plugin, "factoryreset", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_addoninfo(plugin, "addoninfo", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_addonmanager(plugin, "addonmanager", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_playerinfo(plugin, "playerinfo", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_haspermission(plugin, "haspermission", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_permissionlookups(plugin, "permissionlookups", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_dump(plugin, "dump", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_setrank(plugin, "setrank", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_setownrank(plugin, "setownrank", PowerCommand.COMMAND_EXECUTOR.PLAYER);
        new cmd_addrank(plugin, "addrank", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_addownrank(plugin, "addownrank", PowerCommand.COMMAND_EXECUTOR.PLAYER);
        new cmd_delrank(plugin, "delrank", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_listranks(plugin, "listranks", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_listpermissions(plugin, "listpermissions", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_listplayerpermissions(plugin, "listplayerpermissions", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_listaddons(plugin, "listaddons", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_listusertags(plugin, "listusertags", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_checkrank(plugin, "checkrank", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_nick(plugin, "nick", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_createrank(plugin, "createrank", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_deleterank(plugin, "deleterank", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_renamerank(plugin, "renamerank", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_setdefault(plugin, "setdefault", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_listdefaultranks(plugin, "listdefaultranks", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_addperm(plugin, "addperm", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_delperm(plugin, "delperm", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_setprefix(plugin, "setprefix", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_setsuffix(plugin, "setsuffix", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_setchatcolor(plugin, "setchatcolor", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_setnamecolor(plugin, "setnamecolor", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_addinheritance(plugin, "addinheritance", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_delinheritance(plugin, "delinheritance", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_setweight(plugin, "setweight", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_rankinfo(plugin, "rankinfo", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_buyrank(plugin, "buyrank", PowerCommand.COMMAND_EXECUTOR.PLAYER);
        new cmd_rankup(plugin, "rankup", PowerCommand.COMMAND_EXECUTOR.PLAYER);
        new cmd_addbuyablerank(plugin, "addbuyablerank", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_delbuyablerank(plugin, "delbuyablerank", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_setbuycost(plugin, "setbuycost", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_setbuydescription(plugin, "setbuydescription", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_setbuycommand(plugin, "setbuycommand", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_addplayerperm(plugin, "addplayerperm", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_delplayerperm(plugin, "delplayerperm", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_createusertag(plugin, "createusertag", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_editusertag(plugin, "editusertag", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_removeusertag(plugin, "removeusertag", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_addusertag(plugin, "addusertag", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_setusertag(plugin, "setusertag", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_delusertag(plugin, "delusertag", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_clearusertag(plugin, "clearusertag", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_webeditor(plugin, "webeditor", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_webeditor(plugin, "we", PowerCommand.COMMAND_EXECUTOR.ALL);
        new cmd_test(plugin, "test", PowerCommand.COMMAND_EXECUTOR.ALL);
    }

    private static boolean canExecuteCommand(CommandSender sender, PowerCommand command_handler) {
        return sender instanceof Player && (command_handler.getCommandExecutor() == PowerCommand.COMMAND_EXECUTOR.PLAYER || command_handler.getCommandExecutor() == PowerCommand.COMMAND_EXECUTOR.ALL) || sender instanceof ConsoleCommandSender && (command_handler.getCommandExecutor() == PowerCommand.COMMAND_EXECUTOR.CONSOLE || command_handler.getCommandExecutor() == PowerCommand.COMMAND_EXECUTOR.ALL) || sender instanceof BlockCommandSender && (command_handler.getCommandExecutor() == PowerCommand.COMMAND_EXECUTOR.COMMANDBLOCK || command_handler.getCommandExecutor() == PowerCommand.COMMAND_EXECUTOR.ALL);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args2) {
        if (args2.length == 0) {
            sender.sendMessage(ChatColor.BLUE + "===" + ChatColor.DARK_AQUA + "----------" + ChatColor.AQUA + this.plugin.getDescription().getName() + ChatColor.DARK_AQUA + "----------" + ChatColor.BLUE + "===");
            sender.sendMessage(ChatColor.GREEN + "/" + commandLabel + " help" + ChatColor.DARK_GREEN + " - For the command list.");
            sender.sendMessage("");
            sender.sendMessage(ChatColor.DARK_GREEN + "Author: " + ChatColor.GREEN + (String)this.plugin.getDescription().getAuthors().get(0));
            sender.sendMessage(ChatColor.DARK_GREEN + "Version: " + ChatColor.GREEN + this.plugin.getDescription().getVersion());
            sender.sendMessage(ChatColor.DARK_GREEN + "Website: " + ChatColor.GREEN + this.plugin.getDescription().getWebsite());
            sender.sendMessage(ChatColor.DARK_GREEN + "Documentation: " + ChatColor.GREEN + "https://docs.powerranks.nl");
            sender.sendMessage(ChatColor.DARK_GREEN + "Support me: " + ChatColor.YELLOW + "https://ko-fi.com/svenar");
            sender.sendMessage(ChatColor.BLUE + "===" + ChatColor.DARK_AQUA + "------------------------------" + ChatColor.BLUE + "===");
        } else {
            String command = args2[0];
            PowerCommand command_handler = PowerCommandHandler.get_power_command(command);
            if (command_handler != null) {
                boolean is_allowed = PowerCommandHandler.canExecuteCommand(sender, command_handler);
                boolean hasPermission = this.hasPermission(sender, command_handler);
                if (is_allowed) {
                    if (hasPermission) {
                        return command_handler.onCommand(sender, cmd, commandLabel, command, Arrays.copyOfRange(args2, 1, args2.length));
                    }
                    sender.sendMessage(PowerRanks.getLanguageManager().getFormattedMessage("general.no-permission"));
                } else {
                    sender.sendMessage(this.plugin.plp + ChatColor.DARK_RED + "You can't execute this command here");
                }
            } else {
                boolean addonCommandFound = false;
                PowerRanksPlayer prPlayer = null;
                prPlayer = sender instanceof Player ? new PowerRanksPlayer(this.plugin, (Player)sender) : new PowerRanksPlayer(this.plugin, "CONSOLE");
                if (prPlayer != null) {
                    for (Map.Entry<File, PowerRanksAddon> prAddon : this.plugin.addonsManager.addonClasses.entrySet()) {
                        if (!prAddon.getValue().onPowerRanksCommand(prPlayer, sender instanceof Player, args2[0], args2)) continue;
                        addonCommandFound = true;
                    }
                }
                if (!addonCommandFound) {
                    sender.sendMessage(this.plugin.plp + ChatColor.DARK_RED + "Unknown Command");
                }
            }
        }
        return false;
    }

    private boolean hasPermission(CommandSender sender, PowerCommand command_handler) {
        if (command_handler.getCommandPermission().length() == 0) {
            return true;
        }
        return sender.hasPermission(command_handler.getCommandPermission());
    }

    public static PowerCommand get_power_command(String command_name) {
        return power_commands.get(command_name.toLowerCase());
    }

    public static void add_power_command(String command_name, PowerCommand command_handler) {
        power_commands.put(command_name.toLowerCase(), command_handler);
    }

    private static boolean hasCommandPermission(CommandSender sender, String cmd) {
        boolean hasPermission = sender instanceof Player ? ((Player)sender).hasPermission("powerranks.cmd." + cmd.toLowerCase()) : true;
        return hasPermission;
    }

    public static ArrayList<String> handle_tab_complete(CommandSender sender, String cmd, String[] args2) {
        ArrayList<String> output = new ArrayList<String>();
        if (args2.length == 0) {
            for (Map.Entry<String, PowerCommand> entry : power_commands.entrySet()) {
                boolean is_allowed;
                if (cmd.length() != 0 && !entry.getKey().toLowerCase().contains(cmd.toLowerCase()) || !(is_allowed = PowerCommandHandler.canExecuteCommand(sender, entry.getValue()) && PowerCommandHandler.hasCommandPermission(sender, cmd))) continue;
                output.add(entry.getKey());
            }
        } else if (power_commands.containsKey(cmd.toLowerCase()) && PowerCommandHandler.hasCommandPermission(sender, cmd)) {
            output = power_commands.get(cmd.toLowerCase()).tabCompleteEvent(sender, args2);
        }
        return output;
    }
}

