/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.commands;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.commands.PowerCommandHandler;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public abstract class PowerCommand {
    protected PowerRanks plugin;
    private String commandPermission = "";
    private COMMAND_EXECUTOR ce = COMMAND_EXECUTOR.NONE;

    public PowerCommand(PowerRanks plugin, String command_name, COMMAND_EXECUTOR ce) {
        PowerCommandHandler.add_power_command(command_name, this);
        this.plugin = plugin;
        this.ce = ce;
    }

    public abstract boolean onCommand(CommandSender var1, Command var2, String var3, String var4, String[] var5);

    public COMMAND_EXECUTOR getCommandExecutor() {
        return this.ce;
    }

    public abstract ArrayList<String> tabCompleteEvent(CommandSender var1, String[] var2);

    protected void setCommandPermission(String permission) {
        this.commandPermission = permission;
    }

    public String getCommandPermission() {
        return this.commandPermission;
    }

    protected String prepareMessage(String langArg, boolean addPluginPrefix) {
        return this.prepareMessage(langArg, (ImmutableMap<String, String>)ImmutableMap.of(), addPluginPrefix);
    }

    protected String prepareMessage(String langArg, ImmutableMap<String, @NotNull String> data, boolean addPluginPrefix) {
        String langLine = PowerRanks.getLanguageManager().getFormattedMessage(langArg, false);
        if (addPluginPrefix) {
            String langPrefix = PowerRanks.getLanguageManager().getFormattedMessage("prefix", false);
            return PRUtil.powerFormatter(langPrefix + " " + langLine, data, '[', ']');
        }
        return PRUtil.powerFormatter(langLine, data, '[', ']');
    }

    public static enum COMMAND_EXECUTOR {
        NONE,
        PLAYER,
        CONSOLE,
        COMMANDBLOCK,
        ALL;

    }
}

