/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.common.storage.PowerConfigManager;
import nl.svenar.powerranks.common.storage.provided.YAMLConfigManager;

public class LanguageManager {
    private PowerConfigManager languageManager = new YAMLConfigManager(PowerRanks.fileLoc, "lang.yml", "lang.yml");
    private String language = "en";

    public LanguageManager() {
        if (!this.languageManager.hasKey("lang")) {
            this.languageManager.destroyFile();
            this.languageManager = new YAMLConfigManager(PowerRanks.fileLoc, "lang.yml", "lang.yml");
        }
    }

    public List<String> getKeys(String path) {
        String targetPath = "lang." + this.language + "." + path;
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<?, ?> entry : this.languageManager.getMap(targetPath, new HashMap()).entrySet()) {
            keys.add(String.valueOf(entry.getKey()));
        }
        return keys;
    }

    public String getMessage(String path) {
        return this.getMessage(path, true);
    }

    public String getMessage(String path, boolean addPrefix) {
        path = "lang." + this.language + "." + path;
        String output = this.languageManager.getString(path);
        output = output == null ? path : output;
        output = (addPrefix ? this.languageManager.getString("lang." + this.language + ".general.prefix") + " " : "") + output;
        return output;
    }

    public String getUnformattedMessage(String path) {
        String targetPath = "lang." + this.language + "." + path;
        String output = this.languageManager.getString(targetPath);
        output = output == null ? targetPath : output;
        return output;
    }

    public String getFormattedMessage(String path) {
        return PowerRanks.chatColor(this.getMessage(path), true);
    }

    public String getFormattedMessage(String path, boolean addPrefix) {
        return PowerRanks.chatColor(this.getMessage(path, addPrefix), true);
    }

    public String getUsageMessage(String commandLabel, String commandName, String path, boolean isPlayer) {
        String targetPath = "lang." + this.language + "." + path;
        String output = this.languageManager.getString(targetPath);
        output = output == null ? targetPath : output;
        output = (isPlayer ? "/" : "") + commandLabel + " " + commandName + " " + output;
        return output;
    }

    public String getFormattedUsageMessage(String commandLabel, String commandName, String path, boolean isPlayer) {
        return PowerRanks.chatColor(this.getUsageMessage(commandLabel, commandName, path, isPlayer), true);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void save() {
        this.languageManager.save();
    }

    public void reload() {
        this.languageManager.reload();
    }

    public PowerConfigManager getInstance() {
        return this.languageManager;
    }
}

