/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.addons;

import java.util.ArrayList;
import java.util.List;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.addons.PowerRanksConfig;
import nl.svenar.powerranks.bukkit.addons.PowerRanksPlayer;
import nl.svenar.powerranks.bukkit.events.ChatTabExecutor;
import nl.svenar.powerranks.common.storage.PowerStorageManager;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public abstract class PowerRanksAddon {
    private PowerRanksConfig powerranksConfig = null;
    private ArrayList<String> registeredCommands = new ArrayList();
    private ArrayList<String> registeredPermissions = new ArrayList();
    private List<String> storageManagers = new ArrayList<String>();

    public final void setupConfigfile() {
        this.powerranksConfig = new PowerRanksConfig(this.getIdentifier());
    }

    public final PowerRanksConfig getConfig() {
        return this.powerranksConfig;
    }

    public final void registerCommandAutocomplete(String command) {
        ChatTabExecutor.addAddonCommand(command);
        if (!this.registeredCommands.contains(command.toLowerCase())) {
            this.registeredCommands.add(command.toLowerCase());
        }
    }

    public final void registerPermission(String permission) {
        if (!this.registeredPermissions.contains(permission.toLowerCase())) {
            this.registeredPermissions.add(permission.toLowerCase());
        }
    }

    public final ArrayList<String> getRegisteredCommands() {
        return this.registeredCommands;
    }

    public final ArrayList<String> getRegisteredPermissions() {
        return this.registeredPermissions;
    }

    public abstract String getAuthor();

    public abstract String getIdentifier();

    public abstract String getVersion();

    public abstract String minimalPowerRanksVersion();

    public void setup(PowerRanks powerranks) {
    }

    public void setup() {
    }

    public void unload() {
    }

    public void onPlayerJoin(PowerRanksPlayer prPlayer) {
    }

    public boolean onPlayerJoinMessage(PowerRanksPlayer prPlayer) {
        return true;
    }

    public void onPlayerLeave(PowerRanksPlayer prPlayer) {
    }

    public boolean onPlayerMove(PowerRanksPlayer prPlayer, Location from, Location to) {
        return false;
    }

    public void onPlayerRankChange(PowerRanksPlayer prPlayer, String oldRank, String newRank, RankChangeCause cause, boolean isPlayerOnline) {
    }

    public String onPlayerChat(PowerRanksPlayer prPlayer, String chatFormat, String message) {
        return chatFormat;
    }

    public boolean onPowerRanksCommand(PowerRanksPlayer prPlayer, boolean sendAsPlayer, String command, String[] arguments) {
        return false;
    }

    public void onPlayerWorldChange(PowerRanksPlayer prPlayer, World world, World world2) {
    }

    public boolean onBlockChange(PowerRanksPlayer prPlayer, Block block, BlockChangeCause blockChangeCause) {
        return false;
    }

    public void registerStorageManager(String name) {
        this.storageManagers.add(name);
    }

    public List<String> getStorageManagerNames() {
        return this.storageManagers;
    }

    public PowerStorageManager getStorageManager(String name) {
        return null;
    }

    public void setupStorageManager(String name) {
    }

    public static enum BlockChangeCause {
        BREAK,
        PLACE,
        MOISTURE,
        FERTILIZE,
        GROW,
        IGNITE,
        EXPLODE,
        BURN,
        REDSTONE;

    }

    public static enum RankChangeCause {
        SET,
        PROMOTE,
        DEMOTE;

    }
}

