/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.addons;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.addons.AddonDownloader;
import nl.svenar.powerranks.bukkit.util.Util;

public class DownloadableAddon {
    private AddonDownloader.Addon addon;

    public DownloadableAddon(AddonDownloader.Addon addon) {
        this.addon = addon;
    }

    public String getName() {
        return this.addon.name;
    }

    public boolean isDownloadable() {
        return this.addon.autoDownloadable;
    }

    public boolean isCompatible() {
        return Util.calculateVersionFromString(PowerRanks.pdf.getVersion().replaceAll("[a-zA-Z ]", "")) >= Util.calculateVersionFromString(this.addon.powerranksVersion.replaceAll("[a-zA-Z ]", ""));
    }

    public String getAuthor() {
        return this.addon.author;
    }

    public String getVersion() {
        return this.addon.version;
    }

    public String getURL() {
        return (this.addon.download.toLowerCase().endsWith(".jar") && !this.addon.download.toLowerCase().startsWith("https://") ? "https://addons.powerranks.nl/" : "") + this.addon.download;
    }

    public String getMinPowerRanksVersion() {
        return this.addon.powerranksVersion;
    }

    public ArrayList<String> getDescription() {
        return this.addon.description;
    }

    public boolean download() {
        File targetDirectory = new File(PowerRanks.fileLoc + File.separator + "Addons" + File.separator);
        try {
            int size;
            URLConnection urlConnection = Util.getURL(this.getURL());
            String filePathName = urlConnection.getURL().getFile();
            String fileName = filePathName.substring(filePathName.lastIndexOf(File.separatorChar) + 1);
            File targetFile = new File(targetDirectory, fileName);
            InputStream inputStream2 = urlConnection.getInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream2);
            FileOutputStream outputStream2 = new FileOutputStream(targetFile);
            byte[] buf = new byte[1024];
            while ((size = bufferedInputStream.read(buf)) != -1) {
                ((OutputStream)outputStream2).write(buf, 0, size);
            }
            ((OutputStream)outputStream2).close();
            bufferedInputStream.close();
            inputStream2.close();
            this.reloadAddons();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void reloadAddons() {
        PowerRanks.getInstance().addonsManager.disable();
        PowerRanks.getInstance().addonsManager.setup();
    }

    private File getFile() {
        try {
            URLConnection urlConnection = Util.getURL(this.getURL());
            String filePathName = urlConnection.getURL().getFile();
            String fileName = filePathName.substring(filePathName.lastIndexOf(File.separatorChar) + 1);
            File target = new File(PowerRanks.fileLoc + File.separator + "Addons", fileName);
            return target;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isInstalled() {
        return this.getFile().exists();
    }

    public void uninstall() {
        File file = this.getFile();
        if (file.exists()) {
            file.delete();
            this.reloadAddons();
        }
    }
}

