/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.addons;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.svenar.powerranks.bukkit.PowerRanks;
import nl.svenar.powerranks.bukkit.addons.AddonDownloader;
import nl.svenar.powerranks.bukkit.addons.PowerRanksAddon;
import nl.svenar.powerranks.bukkit.addons.PowerRanksFileUtil;
import nl.svenar.powerranks.bukkit.util.Util;

public class AddonsManager {
    public static HashMap<File, Boolean> loadedAddons = new HashMap();
    public HashMap<File, PowerRanksAddon> addonClasses = new HashMap();
    private PowerRanks powerranks;
    private AddonDownloader addonDownloader;

    public AddonsManager(PowerRanks powerranks) {
        this.powerranks = powerranks;
        if (PowerRanks.getConfigManager().getBool("addon_manager.accepted_terms", false)) {
            this.setupAddonDownloader();
        }
    }

    public void setupAddonDownloader() {
        this.addonDownloader = new AddonDownloader();
    }

    /*
     * WARNING - void declaration
     */
    public void setup() {
        void var3_8;
        File folder = new File(PowerRanks.fileLoc + File.separator + "Addons");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        for (String fileName : folder.list()) {
            File file = new File(folder.getAbsolutePath() + File.separator + fileName);
            if (!this.isJar(file)) continue;
            loadedAddons.put(file, false);
        }
        for (Map.Entry entry : loadedAddons.entrySet()) {
            List<Class<?>> classes = PowerRanksFileUtil.getClasses((File)entry.getKey(), PowerRanksAddon.class);
            if (classes == null || classes.isEmpty()) {
                PowerRanks.log.info("Addon " + ((File)entry.getKey()).getName() + " is invalid");
                continue;
            }
            PowerRanksAddon pra = null;
            for (Class<?> c : classes) {
                if (!PowerRanksAddon.class.isAssignableFrom(c)) continue;
                try {
                    pra = (PowerRanksAddon)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.addonClasses.put((File)entry.getKey(), pra);
                    entry.setValue(true);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList<File> tmp_prAddon = new ArrayList<File>();
        for (Map.Entry<File, PowerRanksAddon> prAddon : this.addonClasses.entrySet()) {
            if (Util.calculateVersionFromString(PowerRanks.pdf.getVersion().replaceAll("[a-zA-Z ]", "")) >= Util.calculateVersionFromString(prAddon.getValue().minimalPowerRanksVersion().replaceAll("[a-zA-Z ]", ""))) {
                PowerRanks.log.info("PowerRanks addon: " + prAddon.getValue().getIdentifier() + " v" + prAddon.getValue().getVersion() + " by: " + prAddon.getValue().getAuthor() + " loaded!");
                prAddon.getValue().setup(this.powerranks);
                prAddon.getValue().setup();
                continue;
            }
            PowerRanks.log.info("PowerRanks addon: " + prAddon.getValue().getIdentifier() + " requires PowerRanks v" + prAddon.getValue().minimalPowerRanksVersion().replaceAll("[a-zA-Z ]", "") + " or higher");
            tmp_prAddon.add(prAddon.getKey());
            loadedAddons.put(prAddon.getKey(), false);
        }
        for (File addon_file : tmp_prAddon) {
            this.addonClasses.remove(addon_file);
        }
        boolean bl = false;
        for (Map.Entry<File, Boolean> prAddon : loadedAddons.entrySet()) {
            if (!prAddon.getValue().booleanValue()) continue;
            ++var3_8;
        }
        PowerRanks.log.info("Loaded " + (int)var3_8 + " add-on(s)!");
    }

    public void disable() {
        for (Map.Entry<File, Boolean> prAddonLoaded : loadedAddons.entrySet()) {
            if (!prAddonLoaded.getKey().exists() || !prAddonLoaded.getValue().booleanValue()) continue;
            PowerRanksAddon addon = null;
            for (Map.Entry<File, PowerRanksAddon> prAddon : this.addonClasses.entrySet()) {
                if (!prAddon.getKey().getAbsolutePath().equals(prAddonLoaded.getKey().getAbsolutePath())) continue;
                addon = prAddon.getValue();
                break;
            }
            if (addon == null) continue;
            addon.unload();
        }
        loadedAddons.clear();
        this.addonClasses.clear();
    }

    private boolean isJar(File path) {
        String extension = ".jar";
        return path.getName().toLowerCase().endsWith(extension);
    }

    public Collection<PowerRanksAddon> getAddons() {
        return this.addonClasses.values();
    }

    public AddonDownloader getAddonDownloader() {
        return this.addonDownloader;
    }
}

