/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit.addons;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import nl.svenar.powerranks.bukkit.addons.DownloadableAddon;
import nl.svenar.powerranks.bukkit.util.Util;

public class AddonDownloader {
    private String addonsURL = "http://addons.powerranks.nl/addons.json";
    private Addons addonlist;

    public AddonDownloader() {
        try {
            String rawJSON = Util.readUrl(this.addonsURL);
            Gson gson = new Gson();
            this.addonlist = (Addons)gson.fromJson(rawJSON, Addons.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<DownloadableAddon> getDownloadableAddons() {
        ArrayList<DownloadableAddon> addons = new ArrayList<DownloadableAddon>();
        for (Addon addon : this.addonlist.addons) {
            DownloadableAddon downloadableAddon = new DownloadableAddon(addon);
            addons.add(downloadableAddon);
        }
        return addons;
    }

    static class Addons {
        List<Addon> addons;

        Addons() {
        }
    }

    static class Addon {
        String name;
        String version;
        String powerranksVersion;
        ArrayList<String> description;
        String download;
        boolean autoDownloadable;
        String author;

        Addon() {
        }
    }
}

