/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.bukkit;

import com.google.common.collect.ImmutableMap;
import com.nametagedit.plugin.NametagEdit;
import com.nametagedit.plugin.api.INametagApi;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import nl.svenar.powerranks.api.PowerRanksAPI;
import nl.svenar.powerranks.bukkit.addons.AddonsManager;
import nl.svenar.powerranks.bukkit.cache.CacheManager;
import nl.svenar.powerranks.bukkit.cache.LanguageManager;
import nl.svenar.powerranks.bukkit.commands.PowerCommandHandler;
import nl.svenar.powerranks.bukkit.data.BungeecordManager;
import nl.svenar.powerranks.bukkit.data.Messages;
import nl.svenar.powerranks.bukkit.data.PowerPermissibleBase;
import nl.svenar.powerranks.bukkit.data.PowerRanksVerbose;
import nl.svenar.powerranks.bukkit.data.TablistManager;
import nl.svenar.powerranks.bukkit.data.Users;
import nl.svenar.powerranks.bukkit.events.ChatTabExecutor;
import nl.svenar.powerranks.bukkit.events.OnBlockChange;
import nl.svenar.powerranks.bukkit.events.OnChat;
import nl.svenar.powerranks.bukkit.events.OnInteract;
import nl.svenar.powerranks.bukkit.events.OnInventory;
import nl.svenar.powerranks.bukkit.events.OnJoin;
import nl.svenar.powerranks.bukkit.events.OnMove;
import nl.svenar.powerranks.bukkit.events.OnPreCommand;
import nl.svenar.powerranks.bukkit.events.OnSignChanged;
import nl.svenar.powerranks.bukkit.events.OnWorldChange;
import nl.svenar.powerranks.bukkit.external.DeluxeTagsHook;
import nl.svenar.powerranks.bukkit.external.PowerRanksExpansion;
import nl.svenar.powerranks.bukkit.external.VaultHook;
import nl.svenar.powerranks.bukkit.gui.GUI;
import nl.svenar.powerranks.bukkit.metrics.Metrics;
import nl.svenar.powerranks.bukkit.update.ConfigFilesUpdater;
import nl.svenar.powerranks.bukkit.update.Updater;
import nl.svenar.powerranks.bukkit.util.BukkitPowerColor;
import nl.svenar.powerranks.bukkit.util.Util;
import nl.svenar.powerranks.common.PowerLogger;
import nl.svenar.powerranks.common.storage.PermissionRegistry;
import nl.svenar.powerranks.common.storage.PowerConfigManager;
import nl.svenar.powerranks.common.storage.provided.YAMLConfigManager;
import nl.svenar.powerranks.common.structure.PRPermission;
import nl.svenar.powerranks.common.structure.PRPlayer;
import nl.svenar.powerranks.common.structure.PRPlayerRank;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;

public class PowerRanks
extends JavaPlugin
implements Listener {
    public String bukkit_dev_url_powerranks = "https://dev.bukkit.org/projects/powerranks";
    public ArrayList<String> donation_urls = new ArrayList<String>(Arrays.asList("https://ko-fi.com/svenar"));
    public int TASK_TPS = 20;
    private static PowerRanks instance;
    public static PluginDescriptionFile pdf;
    public AddonsManager addonsManager;
    private TablistManager tablistManager;
    private static BukkitPowerColor powerColor;
    public String plp;
    public static Logger log;
    public static String fileLoc;
    public static String factoryresetid;
    public static Instant powerranks_start_time;
    private String update_available = "";
    private static PowerConfigManager configManager;
    private static LanguageManager languageManager;
    private static PowerConfigManager usertagManager;
    private static PowerConfigManager tablistConfigManager;
    private BungeecordManager bungeecordManager;
    private PermissionRegistry permissionRegistry;
    private VaultHook vaultHook;
    private DeluxeTagsHook deluxeTagsHook;
    public static boolean vaultEconomyEnabled;
    public static boolean vaultPermissionsEnabled;
    public static PowerRanksExpansion placeholderapiExpansion;
    public static boolean plugin_hook_deluxetags;
    public static boolean plugin_hook_nametagedit;
    public String updatemsg;
    public Map<UUID, PermissionAttachment> playerPermissionAttachment = new HashMap<UUID, PermissionAttachment>();
    public Map<UUID, String> playerTablistNameBackup = new HashMap<UUID, String>();
    public Map<UUID, Long> playerPlayTimeCache = new HashMap<UUID, Long>();

    public PowerRanks() {
        pdf = this.getDescription();
        this.plp = ChatColor.BLACK + "[" + ChatColor.AQUA + pdf.getName() + ChatColor.BLACK + "]" + ChatColor.RESET + " ";
        fileLoc = this.getDataFolder() + File.separator;
        this.updatemsg = "";
    }

    public void onEnable() {
        instance = this;
        new PowerLogger(this.getLogger());
        Instant startTime = Instant.now();
        log = this.getLogger();
        ConfigFilesUpdater.updateOldDataFiles();
        if (new File(fileLoc, "config.yml").exists() && new File(fileLoc, "lang.yml").exists()) {
            ConfigFilesUpdater.updateConfigFiles();
        }
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new OnJoin(this), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new OnChat(this), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new OnInteract(this), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new OnSignChanged(this), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new OnInventory(this), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new OnMove(this), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new OnWorldChange(this), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new OnBlockChange(this), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new OnPreCommand(this), (Plugin)this);
        Bukkit.getServer().getPluginCommand("powerranks").setExecutor((CommandExecutor)new PowerCommandHandler(this));
        Bukkit.getServer().getPluginCommand("powerranks").setTabCompleter((TabCompleter)new ChatTabExecutor(this));
        log.info("");
        log.info("=== ------- LOADING CONFIGURATION ------ ===");
        powerColor = new BukkitPowerColor();
        new Messages(this);
        new PowerRanksVerbose(this);
        PRUtil.createDir(fileLoc);
        log.info("Loading config file");
        configManager = new YAMLConfigManager(fileLoc, "config.yml", "config.yml");
        log.info("Loading language file");
        languageManager = new LanguageManager();
        languageManager.setLanguage(configManager.getString("general.language", "en"));
        log.info("Loading usertags file");
        usertagManager = new YAMLConfigManager(fileLoc, "usertags.yml");
        log.info("Loading tablist file");
        tablistConfigManager = new YAMLConfigManager(fileLoc, "tablist.yml", "tablist.yml");
        log.info("");
        log.info("=== ---------- LOADING ADDONS ---------- ===");
        this.addonsManager = new AddonsManager(this);
        this.addonsManager.setup();
        this.permissionRegistry = new PermissionRegistry();
        for (PermissionAttachmentInfo pai : Bukkit.getConsoleSender().getEffectivePermissions()) {
            this.permissionRegistry.queuePermission(pai.getPermission());
        }
        log.info("");
        log.info("=== ----------- LOADING DATA ----------- ===");
        log.info("Loading player & rank data");
        CacheManager.load(fileLoc);
        this.loadDefaultRanks();
        for (Player player : this.getServer().getOnlinePlayers()) {
            this.playerInjectPermissible(player);
        }
        log.info("");
        log.info("=== ------- LOADING PLUGIN HOOKS ------- ===");
        this.setupSoftDependencies();
        GUI.setPlugin(this);
        this.bungeecordManager = new BungeecordManager(this);
        this.bungeecordManager.start();
        this.tablistManager = new TablistManager();
        this.tablistManager.start();
        this.setupCheckRankTagsTask();
        log.info("");
        log.info(ChatColor.AQUA + "  \u2588\u2588\u2588\u2588\u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588 " + ChatColor.GREEN + "  PowerRanks v" + pdf.getVersion());
        log.info(ChatColor.AQUA + "  \u2588\u2588   \u2588\u2588 \u2588\u2588   \u2588\u2588" + ChatColor.GREEN + "  Running on " + Util.getServerType(this.getServer()) + " v" + Util.getServerVersion(this.getServer()));
        log.info(ChatColor.AQUA + "  \u2588\u2588\u2588\u2588\u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588 " + ChatColor.GREEN + "  Startup time: " + Duration.between(startTime, Instant.now()).toMillis() + "ms");
        log.info(ChatColor.AQUA + "  \u2588\u2588      \u2588\u2588   \u2588\u2588" + ChatColor.GREEN + "  Loaded " + CacheManager.getRanks().size() + " ranks and " + CacheManager.getPlayers().size() + " players (" + PowerRanks.getConfigManager().getString("storage.type", "yaml").toUpperCase() + ") " + this.update_available);
        log.info(ChatColor.AQUA + "  \u2588\u2588      \u2588\u2588   \u2588\u2588" + ChatColor.RED + "  " + (System.getProperty("POWERRANKSRUNNING", "").equals("TRUE") ? "Reload detected, why do you hate yourself :C" : ""));
        log.info("");
        System.setProperty("POWERRANKSRUNNING", "TRUE");
        log.info("If you'd like to donate, please visit " + this.donation_urls.get(0));
        if (this.handle_update_checking()) {
            return;
        }
        this.setupMetrics();
        this.setupTasks();
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            OnJoin.handleJoin(this, player);
        }
    }

    public void onDisable() {
        if (this.tablistManager != null) {
            this.tablistManager.stop();
        }
        if (this.bungeecordManager != null) {
            this.bungeecordManager.stop();
        }
        Bukkit.getServer().getScheduler().cancelTasks((Plugin)this);
        CacheManager.save();
        this.saveConfigurationFiles();
        if (Objects.nonNull(this.addonsManager)) {
            this.addonsManager.disable();
        }
        for (Map.Entry<UUID, PermissionAttachment> entry : this.playerPermissionAttachment.entrySet()) {
            entry.getValue().remove();
        }
        this.playerPermissionAttachment.clear();
        for (Map.Entry<UUID, Object> entry : this.playerTablistNameBackup.entrySet()) {
            Player player = this.getPlayerFromUUID(entry.getKey());
            if (player == null) continue;
            player.setPlayerListName((String)entry.getValue());
        }
        this.playerTablistNameBackup.clear();
        if (log != null && pdf != null) {
            log.info("Disabled " + pdf.getName() + " v" + pdf.getVersion());
        }
    }

    private void saveConfigurationFiles() {
        boolean hasErrorInSaving = false;
        if (Objects.nonNull(PowerRanks.getConfigManager())) {
            PowerRanks.getConfigManager().save();
        } else {
            this.getLogger().warning("Failed to save configuration file!");
            hasErrorInSaving = true;
        }
        if (Objects.nonNull(PowerRanks.getLanguageManager())) {
            PowerRanks.getLanguageManager().save();
        } else {
            this.getLogger().warning("Failed to save language file!");
            hasErrorInSaving = true;
        }
        if (Objects.nonNull(PowerRanks.getUsertagManager())) {
            PowerRanks.getUsertagManager().save();
        } else {
            this.getLogger().warning("Failed to save usertags file!");
            hasErrorInSaving = true;
        }
        if (Objects.nonNull(PowerRanks.getTablistConfigManager())) {
            PowerRanks.getTablistConfigManager().save();
        } else {
            this.getLogger().warning("Failed to save tablist config file!");
            hasErrorInSaving = true;
        }
        if (hasErrorInSaving) {
            this.getLogger().warning("This could occur when PowerRanks restarted on a reload in your server.");
        }
    }

    private void loadDefaultRanks() {
        if (CacheManager.getRanks().size() > 0) {
            return;
        }
        PRRank rankMember = new PRRank();
        rankMember.setName("Member");
        rankMember.setDefault(true);
        rankMember.setWeight(0);
        rankMember.setPrefix("[gradient=#127e00,#3eaf18]MEMBER[/gradient]");
        PRRank rankModerator = new PRRank();
        rankModerator.setName("Moderator");
        rankModerator.setDefault(false);
        rankModerator.setWeight(50);
        rankModerator.setPrefix("[gradient=#9d1dff,#e22581]MODERATOR[/gradient]");
        PRRank rankAdmin = new PRRank();
        rankAdmin.setName("Admin");
        rankAdmin.setDefault(false);
        rankAdmin.setWeight(75);
        rankAdmin.setPrefix("[gradient=#ffff00,#ef3300]ADMIN[/gradient]");
        PRRank rankOwner = new PRRank();
        rankOwner.setName("Owner");
        rankOwner.setDefault(false);
        rankOwner.setWeight(100);
        rankOwner.setPrefix("[gradient=#ff00ff,#33ccff]OWNER[/gradient]");
        CacheManager.addRank(rankMember);
        CacheManager.addRank(rankModerator);
        CacheManager.addRank(rankAdmin);
        CacheManager.addRank(rankOwner);
        CacheManager.save();
    }

    private void setupTasks() {
        int playtime_interval = 60;
        int autosave_interval = 600;
        try {
            playtime_interval = configManager.getInt("general.playtime-update-interval", (int)configManager.getFloat("general.playtime-update-interval", playtime_interval));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            playtime_interval = configManager.getInt("general.autosave-files-interval", (int)configManager.getFloat("general.autosave-files-interval", autosave_interval));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (playtime_interval > 0) {
            new BukkitRunnable(){

                public void run() {
                    PowerRanksVerbose.log("task", "Running task update player playtime");
                    for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                        long current_time;
                        long last_time = current_time = new Date().getTime();
                        try {
                            last_time = PowerRanks.this.playerPlayTimeCache.get(player.getUniqueId()) - 1000L;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        PowerRanks.this.updatePlaytime(player, last_time, current_time, true);
                        long time = new Date().getTime();
                        PowerRanks.this.playerPlayTimeCache.put(player.getUniqueId(), time);
                    }
                }
            }.runTaskTimer((Plugin)this, 0L, (long)(playtime_interval * this.TASK_TPS));
        }
        if (autosave_interval > 0) {
            new BukkitRunnable(){

                public void run() {
                    PowerRanksVerbose.log("task", "Running task auto-save files");
                    CacheManager.save();
                }
            }.runTaskTimer((Plugin)this, (long)(autosave_interval * this.TASK_TPS), (long)(autosave_interval * this.TASK_TPS));
        }
        new BukkitRunnable(){
            int retryCount = 0;

            public void run() {
                if (Objects.nonNull(PowerRanks.this.vaultHook)) {
                    if (Objects.isNull(VaultHook.getVaultEconomy())) {
                        boolean has_vault_economy = PowerRanks.getInstance().getServer().getPluginManager().getPlugin("Vault") != null && PowerRanks.this.getConfigBool("plugin_hook.vault_economy", false);
                        PowerRanks.this.vaultHook.hook(PowerRanks.getInstance(), false, false, has_vault_economy);
                    } else {
                        this.cancel();
                    }
                } else {
                    this.cancel();
                }
                ++this.retryCount;
                if (this.retryCount >= 30) {
                    log.warning("No Vault compatible economy plugin found! Giving up.");
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this, 0L, (long)(10 * this.TASK_TPS));
        int update_check_interval = 43200 * this.TASK_TPS;
        new BukkitRunnable(){

            public void run() {
                PowerRanks.this.handle_update_checking();
            }
        }.runTaskTimer((Plugin)this, (long)update_check_interval, (long)update_check_interval);
        new BukkitRunnable(){

            public void run() {
                PowerRanks.this.permissionRegistry.tick();
            }
        }.runTaskTimer((Plugin)this, 1L, 1L);
    }

    private Player getPlayerFromUUID(UUID uuid) {
        Player player = null;
        for (Player online_player : Bukkit.getServer().getOnlinePlayers()) {
            if (!uuid.equals(online_player.getUniqueId())) continue;
            player = online_player;
            break;
        }
        return player;
    }

    private void setupSoftDependencies() {
        boolean has_vault_economy = this.getServer().getPluginManager().getPlugin("Vault") != null && this.getConfigBool("plugin_hook.vault_economy", false);
        boolean has_vault_permissions = this.getServer().getPluginManager().getPlugin("Vault") != null && this.getConfigBool("plugin_hook.vault_permissions", false);
        boolean has_vault_experimental_permissions = this.getServer().getPluginManager().getPlugin("Vault") != null && this.getConfigBool("plugin_hook.vault_permissions_experimental", false);
        boolean has_placeholderapi = this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null && this.getConfigBool("plugin_hook.placeholderapi", false);
        boolean has_deluxetags = this.getServer().getPluginManager().getPlugin("DeluxeTags") != null && this.getConfigBool("plugin_hook.deluxetags", false);
        boolean has_nametagedit = this.getServer().getPluginManager().getPlugin("NametagEdit") != null && this.getConfigBool("plugin_hook.nametagedit", false);
        log.info("Checking for plugins to hook in to:");
        if (has_vault_economy || has_vault_permissions) {
            log.info("Vault found!");
            if (Bukkit.getPluginManager().isPluginEnabled("Vault")) {
                if (has_vault_economy) {
                    log.info("Enabling Vault Economy integration.");
                }
                if (has_vault_permissions) {
                    log.info("Enabling Vault Permission integration.");
                }
                if (has_vault_experimental_permissions) {
                    log.info("Enabling Vault Permission integration (experimental).");
                }
                this.vaultHook = new VaultHook();
                this.vaultHook.hook(this, has_vault_permissions, has_vault_experimental_permissions, has_vault_economy);
                vaultEconomyEnabled = has_vault_economy;
                vaultPermissionsEnabled = has_vault_permissions;
            }
        }
        if (has_placeholderapi) {
            log.info("PlaceholderAPI found!");
            placeholderapiExpansion = new PowerRanksExpansion(this);
            placeholderapiExpansion.register();
        } else {
            placeholderapiExpansion = null;
        }
        if (has_deluxetags) {
            log.info("DeluxeTags found!");
            plugin_hook_deluxetags = true;
            this.deluxeTagsHook = new DeluxeTagsHook();
        }
        if (has_nametagedit) {
            log.info("NametagEdit found!");
            plugin_hook_nametagedit = true;
            this.setup_nte();
        }
        if (!(has_vault_economy || has_vault_permissions || has_placeholderapi || has_deluxetags || has_nametagedit)) {
            log.info("No other plugins found! Working stand-alone.");
        }
    }

    private void setup_nte() {
        new BukkitRunnable(){

            public void run() {
                if (PowerRanks.this.getServer().getPluginManager().isPluginEnabled("NametagEdit")) {
                    this.cancel();
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        PowerRanks.this.updateTablistName(player);
                    }
                }
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
    }

    private void setupCheckRankTagsTask() {
        new BukkitRunnable(){

            public void run() {
                for (PRPlayer prPlayer : CacheManager.getPlayers()) {
                    ArrayList<PRPlayerRank> ranksToRemove = new ArrayList<PRPlayerRank>();
                    ArrayList<PRPlayerRank> ranksToAdd = new ArrayList<PRPlayerRank>();
                    for (PRPlayerRank rank : prPlayer.getRanks()) {
                        for (Map.Entry<String, Object> entry : rank.getTags().entrySet()) {
                            long expires;
                            long currentTimeMillis;
                            if (entry.getKey().equalsIgnoreCase("expires") && (currentTimeMillis = System.currentTimeMillis()) >= (expires = Util.convertToLong(entry.getValue()).longValue())) {
                                ranksToRemove.add(rank);
                            }
                            if (!entry.getKey().equalsIgnoreCase("expiry-return-ranks")) continue;
                            try {
                                List expiryReturnRanks = (List)entry.getValue();
                                if (expiryReturnRanks.size() > 0) {
                                    ranksToRemove = new ArrayList();
                                    for (PRPlayerRank prPlayerRank : prPlayer.getRanks()) {
                                        ranksToRemove.add(prPlayerRank);
                                    }
                                }
                                for (String rankObject : expiryReturnRanks) {
                                    PRRank prRank;
                                    ArrayList<String> rankTags;
                                    String rankName = rankObject.contains(";") ? rankObject.split(";")[0] : rankObject;
                                    ArrayList<String> arrayList = rankTags = rankObject.contains(";") ? new ArrayList<String>(Arrays.asList(rankObject.split(";"))) : new ArrayList();
                                    if (!rankTags.isEmpty()) {
                                        rankTags.remove(0);
                                    }
                                    if ((prRank = CacheManager.getRank(rankName)) == null) continue;
                                    PRPlayerRank prPlayerRank = new PRPlayerRank(prRank.getName());
                                    for (String rankTag : rankTags) {
                                        prPlayerRank.addTagRaw(rankTag.split(":")[0], Util.formatStringToType(rankTag.split(":")[1]));
                                    }
                                    ranksToAdd.add(prPlayerRank);
                                }
                            }
                            catch (Exception e) {
                                log.warning("Failed to parse expiry-return-ranks for rank " + rank.getName() + " for player " + prPlayer.getName());
                            }
                        }
                    }
                    for (PRPlayerRank rank : ranksToRemove) {
                        prPlayer.removeRank(rank);
                        String prPlayername = prPlayer.getName();
                        if (prPlayername.length() == 0) {
                            prPlayername = Util.getNameFromAPI(prPlayer.getUUID().toString());
                        }
                        PowerRanks.this.getServer().getConsoleSender().sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("general.player-rank-expired-console"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)prPlayername).put((Object)"rank", (Object)rank.getName()).build(), '[', ']'));
                        Player player = PowerRanks.this.getPlayerFromUUID(prPlayer.getUUID());
                        if (player == null) continue;
                        PowerRanks.getInstance().updateTablistName(player);
                        PowerRanks.getInstance().getTablistManager().updateSorting(player);
                        player.sendMessage(PRUtil.powerFormatter(PowerRanks.getLanguageManager().getFormattedMessage("general.player-rank-has-expired"), (Map<String, String>)ImmutableMap.builder().put((Object)"player", (Object)player.getName()).put((Object)"rank", (Object)rank.getName()).build(), '[', ']'));
                    }
                    for (PRPlayerRank rank : ranksToAdd) {
                        if (prPlayer.hasRank(rank.getName())) continue;
                        prPlayer.addRank(rank);
                        Player player = PowerRanks.this.getPlayerFromUUID(prPlayer.getUUID());
                        if (player == null) continue;
                        PowerRanks.getInstance().updateTablistName(player);
                        PowerRanks.getInstance().getTablistManager().updateSorting(player);
                    }
                }
            }
        }.runTaskTimer((Plugin)this, 20L, 200L);
    }

    public DeluxeTagsHook getDeluxeTagsHook() {
        return this.deluxeTagsHook;
    }

    private boolean handle_update_checking() {
        if (this.getConfigBool("updates.enable_update_checking", false)) {
            log.info("Checking for updates...");
            Updater updater = new Updater((Plugin)this, 79251, this.getFile(), this.getConfigBool("updates.automatic_download_updates", false) ? Updater.UpdateType.DEFAULT : Updater.UpdateType.NO_DOWNLOAD, true);
            if (updater.getResult() == Updater.UpdateResult.UPDATE_AVAILABLE) {
                if (!this.getConfigBool("updates.automatic_download_updates", false)) {
                    this.update_available = "Update available! (v" + updater.getLatestName().replaceAll("[a-zA-Z\" ]", "") + ")";
                } else {
                    log.info("Plugin will now be updated!");
                    this.update_available = "Update complete! Please restart your server";
                }
            } else {
                this.update_available = "No update available";
            }
            if (updater.getResult() == Updater.UpdateResult.SUCCESS) {
                log.info("------------------------------------");
                log.info(pdf.getName() + " updated successfully!");
                log.warning(pdf.getName() + " will be disabled until the next server load!");
                log.info("------------------------------------");
                PluginManager plg = Bukkit.getPluginManager();
                Plugin plgname = plg.getPlugin(pdf.getName());
                plg.disablePlugin(plgname);
                return true;
            }
            if (updater.getResult() == Updater.UpdateResult.FAIL_DOWNLOAD) {
                log.info("Update found but failed to download!");
            }
        }
        return false;
    }

    private void setupMetrics() {
        int pluginId = 7565;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("number_of_installed_addons", new Callable<String>(){

            @Override
            public String call() throws Exception {
                int addonCount = 0;
                for (Map.Entry<File, Boolean> prAddon : AddonsManager.loadedAddons.entrySet()) {
                    if (!prAddon.getValue().booleanValue()) continue;
                    ++addonCount;
                }
                return String.valueOf(addonCount);
            }
        }));
        metrics.addCustomChart(new Metrics.SimplePie("accepted_addon_manager_terms", new Callable<String>(){

            @Override
            public String call() throws Exception {
                boolean accepterAddonManagerTerms = configManager.getBool("addon_manager.accepted_terms", false);
                return String.valueOf(accepterAddonManagerTerms ? "true" : "false");
            }
        }));
        metrics.addCustomChart(new Metrics.SimplePie("number_of_registered_players", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return String.valueOf(PowerRanks.this.generateNumber(CacheManager.getPlayers().size()));
            }
        }));
        metrics.addCustomChart(new Metrics.SimplePie("number_of_registered_ranks", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return String.valueOf(CacheManager.getRanks().size());
            }
        }));
        metrics.addCustomChart(new Metrics.SimplePie("storage_method", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return PowerRanks.getConfigManager().getString("storage.type", "yaml").toUpperCase();
            }
        }));
    }

    private int generateNumber(int input) {
        int rounded = Math.round((float)input / 50.0f) * 50;
        return rounded;
    }

    public boolean getConfigBool(String path, boolean defaultValue) {
        if (configManager != null) {
            return configManager.getBool(path, defaultValue);
        }
        File configFile = new File(this.getDataFolder() + File.separator + "config.yml");
        YamlConfiguration configYaml = new YamlConfiguration();
        try {
            configYaml.load(configFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        return configYaml.getBoolean(path, defaultValue);
    }

    public String getConfigString(String path, String defaultValue) {
        if (configManager != null) {
            return configManager.getString(path, defaultValue);
        }
        File configFile = new File(this.getDataFolder() + File.separator + "config.yml");
        YamlConfiguration configYaml = new YamlConfiguration();
        try {
            configYaml.load(configFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        return configYaml.getString(path, defaultValue);
    }

    public boolean configContainsKey(String path) {
        if (configManager != null) {
            return configManager.hasKey(path);
        }
        File configFile = new File(this.getDataFolder() + File.separator + "config.yml");
        YamlConfiguration configYaml = new YamlConfiguration();
        try {
            configYaml.load(configFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        return configYaml.isSet(path);
    }

    public void factoryReset(CommandSender sender) {
        CacheManager.setRanks(new ArrayList<PRRank>());
        CacheManager.setPlayers(new ArrayList<PRPlayer>());
        PRUtil.deleteDir(new File(fileLoc));
        PRUtil.createDir(fileLoc);
        configManager = new YAMLConfigManager(fileLoc, "config.yml", "config.yml");
        languageManager = new LanguageManager();
        languageManager.setLanguage(configManager.getString("general.language", "en"));
        YAMLConfigManager ranksManager = new YAMLConfigManager(fileLoc, "ranks.yml");
        YAMLConfigManager playersManager = new YAMLConfigManager(fileLoc, "players.yml");
        ((PowerConfigManager)ranksManager).save();
        ((PowerConfigManager)playersManager).save();
        CacheManager.load(fileLoc);
        this.loadDefaultRanks();
        for (Player player : this.getServer().getOnlinePlayers()) {
            this.playerInjectPermissible(player);
        }
        Messages.messageCommandFactoryResetDone(sender);
    }

    public void printVersionError(String fileName, boolean auto_update) {
        if (!auto_update) {
            log.warning("===------------------------------===");
            log.warning("              WARNING!");
            log.warning("Version mismatch detected in:");
            log.warning(fileName);
            log.warning(pdf.getName() + " may not work with this config.");
            log.warning("Manual verification is required.");
            log.warning("Visit " + pdf.getWebsite() + " for more info.");
            log.warning("===------------------------------===");
        } else {
            log.info("Updating " + fileName);
        }
    }

    public void copy(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void playerInjectPermissible(Player player) {
        if (this.isMockBukkitLoaded()) {
            return;
        }
        try {
            Field f = Util.obcClass("entity.CraftHumanEntity").getDeclaredField("perm");
            f.setAccessible(true);
            f.set(player, (Object)new PowerPermissibleBase(player, this));
            f.setAccessible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateNametagEditData(final Player player, final String prefix, final String suffix, final String usertag, final String nameColor) {
        if (plugin_hook_nametagedit) {
            PowerRanksVerbose.log("updateNametagEditData", "Updating " + player.getName() + "'s nametag format");
            BukkitScheduler scheduler = this.getServer().getScheduler();
            scheduler.scheduleSyncDelayedTask((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    String prefix_format = configManager.getString("nametagedit.prefix", "");
                    String suffix_format = configManager.getString("nametagedit.suffix", "");
                    if (prefix_format == null || suffix_format == null) {
                        if (prefix_format == null) {
                            PowerRanksVerbose.log("updateNametagEditData", "prefix_format is NULL");
                        }
                        if (suffix_format == null) {
                            PowerRanksVerbose.log("updateNametagEditData", "suffix_format is NULL");
                        }
                        return;
                    }
                    prefix_format = prefix.length() == 0 ? prefix_format.replaceAll("\\[prefix\\]( )?", "") : prefix_format;
                    prefix_format = PRUtil.powerFormatter(prefix_format, (Map<String, String>)ImmutableMap.builder().put((Object)"prefix", (Object)prefix).put((Object)"usertag", (Object)(!plugin_hook_deluxetags ? usertag : PowerRanks.this.getDeluxeTagsHook().getPlayerDisplayTag(player))).build(), '[', ']');
                    suffix_format = suffix.length() == 0 ? suffix_format.replaceAll("( )?\\[suffix\\]", "") : suffix_format;
                    suffix_format = PRUtil.powerFormatter(suffix_format, (Map<String, String>)ImmutableMap.builder().put((Object)"suffix", (Object)suffix).put((Object)"usertag", (Object)(!plugin_hook_deluxetags ? usertag : PowerRanks.this.getDeluxeTagsHook().getPlayerDisplayTag(player))).build(), '[', ']');
                    prefix_format = prefix_format + nameColor;
                    prefix_format = PowerRanks.getPowerColor().format('&', prefix_format, true, false, true);
                    suffix_format = PowerRanks.getPowerColor().format('&', suffix_format, true, false, true);
                    INametagApi nteAPI = NametagEdit.getApi();
                    if (nteAPI != null) {
                        nteAPI.setNametag(player, prefix_format + (prefix_format.length() > 0 ? " " : ""), (suffix_format.length() > 0 ? " " : "") + suffix_format);
                        PowerRanks.this.updateTablistName(player, prefix, suffix, usertag, nameColor, false);
                    }
                }
            }, 20L);
        }
    }

    public void updateTablistName(Player player) {
        if (!this.isMockBukkitLoaded()) {
            try {
                player.updateCommands();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        PRPlayer prPlayer = CacheManager.getPlayer(player);
        Set<PRPlayerRank> playerRanks = prPlayer.getRanks();
        ArrayList<PRRank> ranks = new ArrayList<PRRank>();
        for (PRPlayerRank playerRank : playerRanks) {
            PRRank rank;
            if (playerRank.isDisabled() || (rank = CacheManager.getRank(playerRank.getName())) == null) continue;
            ranks.add(rank);
        }
        PRUtil.sortRanksByWeight(ranks);
        PRUtil.reverseRanks(ranks);
        String formatted_prefix = "";
        String formatted_suffix = "";
        String nameColor = ranks.size() > 0 ? ((PRRank)ranks.get(0)).getNamecolor() : "&f";
        String usertag = "";
        try {
            for (PRRank rank : ranks) {
                formatted_prefix = formatted_prefix + rank.getPrefix() + " ";
                formatted_suffix = formatted_suffix + rank.getSuffix() + " ";
            }
            if (formatted_prefix.endsWith(" ")) {
                formatted_prefix = formatted_prefix.substring(0, formatted_prefix.length() - 1);
            }
            if (formatted_suffix.endsWith(" ")) {
                formatted_suffix = formatted_suffix.substring(0, formatted_suffix.length() - 1);
            }
            if (formatted_prefix.replaceAll(" ", "").length() == 0) {
                formatted_prefix = "";
            }
            if (formatted_suffix.replaceAll(" ", "").length() == 0) {
                formatted_suffix = "";
            }
            Map<?, ?> availableUsertags = PowerRanks.getUsertagManager().getMap("usertags", new HashMap());
            Set<String> playerUsertags = prPlayer.getUsertags();
            for (String playerUsertag : playerUsertags) {
                String value = "";
                for (Map.Entry<?, ?> entry : availableUsertags.entrySet()) {
                    if (!entry.getKey().toString().equalsIgnoreCase(playerUsertag)) continue;
                    value = entry.getValue().toString();
                }
                if (value.length() <= 0) continue;
                usertag = usertag + (usertag.length() > 0 ? " " : "") + value;
            }
            this.updateTablistName(player, formatted_prefix, formatted_suffix, usertag, nameColor, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateTablistName(Player player, String prefix, String suffix, String usertag, String nameColor, boolean updateNTE) {
        PowerRanksVerbose.log("updateTablistName", "Updating " + player.getName() + "'s tablist format");
        PRPlayer prPlayer = CacheManager.getPlayer(player);
        if (prPlayer.getNickname().length() > 0) {
            player.setDisplayName(prPlayer.getNickname().length() > 0 ? prPlayer.getNickname() : player.getName());
        }
        String player_formatted_name = (nameColor.length() == 0 ? "&r" : "") + PowerRanks.applyMultiColorFlow(nameColor, player.getDisplayName());
        try {
            if (updateNTE) {
                this.updateNametagEditData(player, prefix, suffix, usertag, nameColor);
            }
            if (!configManager.getBool("tablist_modification.enabled", true)) {
                return;
            }
            player.setPlayerListName(this.playerTablistNameBackup.get(player.getUniqueId()));
            this.playerTablistNameBackup.put(player.getUniqueId(), player.getPlayerListName());
            String format = configManager.getString("tablist_modification.format", "");
            if (format.contains("[name]")) {
                String tmp_format = configManager.getString("tablist_modification.format", "");
                tmp_format = tmp_format.replace("[name]", "[player]");
                configManager.setString("tablist_modification.format", tmp_format);
                format = tmp_format;
            }
            format = PRUtil.powerFormatter(format, (Map<String, String>)ImmutableMap.builder().put((Object)"prefix", (Object)prefix).put((Object)"suffix", (Object)suffix).put((Object)"usertag", (Object)usertag).put((Object)"player", (Object)player_formatted_name).put((Object)"world", (Object)player.getWorld().getName()).build(), '[', ']');
            while (format.endsWith(" ")) {
                format = format.substring(0, format.length() - 1);
            }
            if (placeholderapiExpansion != null) {
                format = PlaceholderAPI.setPlaceholders((Player)player, (String)format).replaceAll("\u00a7", "&");
            }
            format = PowerRanks.chatColor(format, true);
            player.setPlayerListName(format);
            PowerRanksVerbose.log("updateTablistName", "Updated " + player.getName() + "'s tablist format to: " + player.getPlayerListName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String chatColor(String textToTranslate, boolean custom_colors) {
        return PowerRanks.getPowerColor().format('&', textToTranslate, custom_colors, false, true);
    }

    public static String chatColorAlt(String textToTranslate, boolean custom_colors) {
        return PowerRanks.getPowerColor().format('&', textToTranslate, custom_colors, false, false);
    }

    public static String applyMultiColorFlow(String rawColors, String text) {
        String regexColors = "(&[a-fA-F0-9])|(&?#[a-fA-F0-9]{6})";
        String output = "";
        Pattern p = Pattern.compile(regexColors);
        Matcher m = p.matcher(rawColors);
        ArrayList<String> colors = new ArrayList<String>();
        while (m.find()) {
            String color = m.group(0);
            colors.add(color);
        }
        String[] textSplit = text.split("");
        if (colors.size() > 1) {
            int index = 0;
            for (String character : textSplit) {
                output = output + (String)colors.get(index % colors.size()) + character;
                ++index;
            }
        } else {
            output = rawColors + text;
        }
        return output;
    }

    public void updatePlaytime(Player player, long join_time, long leave_time, boolean write_to_file) {
        long current_playtime = CacheManager.getPlayer(player.getUniqueId().toString()).getPlaytime();
        CacheManager.getPlayer(player.getUniqueId().toString()).setPlaytime(current_playtime + (leave_time - join_time) / 1000L);
    }

    public void updatePlayersWithRank(Users users, String rank) {
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            this.updateTablistName(p);
        }
    }

    public void updatePlayersTABlistWithRank(Users users, String rank) {
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (!users.getPrimaryRank(p).equalsIgnoreCase(rank)) continue;
            this.updateTablistName(p);
        }
    }

    public void updateAllPlayersTABlist() {
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            this.updateTablistName(p);
        }
    }

    public static PowerRanksExpansion getPlaceholderapiExpansion() {
        return placeholderapiExpansion;
    }

    public List<PRPermission> getEffectivePlayerPermissions(Player player) {
        PRPlayer prPlayer = CacheManager.getPlayer(player.getUniqueId().toString());
        if (prPlayer == null) {
            return new ArrayList<PRPermission>();
        }
        return prPlayer.getEffectivePermissions();
    }

    public TablistManager getTablistManager() {
        return this.tablistManager;
    }

    public static PowerConfigManager getConfigManager() {
        return configManager;
    }

    public static LanguageManager getLanguageManager() {
        return languageManager;
    }

    public static PowerConfigManager getUsertagManager() {
        return usertagManager;
    }

    public static PowerConfigManager getTablistConfigManager() {
        return tablistConfigManager;
    }

    public BungeecordManager getBungeecordManager() {
        return this.bungeecordManager;
    }

    public static BukkitPowerColor getPowerColor() {
        return powerColor;
    }

    public static PowerRanksAPI getAPI() {
        return new PowerRanksAPI();
    }

    public static PowerRanks getInstance() {
        return instance;
    }

    public static String getVersion() {
        return instance.getDescription().getVersion();
    }

    private boolean isMockBukkitLoaded() {
        try {
            Class.forName("be.seeseemelk.mockbukkit.MockBukkit");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public PermissionRegistry getPermissionRegistry() {
        return this.permissionRegistry;
    }

    static {
        factoryresetid = null;
        powerranks_start_time = Instant.now();
        vaultEconomyEnabled = false;
        vaultPermissionsEnabled = false;
        plugin_hook_deluxetags = false;
        plugin_hook_nametagedit = false;
    }
}

