/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.api;

import java.util.ArrayList;
import java.util.List;
import nl.svenar.powerranks.common.structure.PRPermission;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRCache;

public class RanksAPI {
    public PRRank create(String name) {
        return PRCache.createRank(name);
    }

    public PRRank get(String name) {
        return PRCache.getRank(name);
    }

    public List<PRRank> getRanks() {
        return PRCache.getRanks();
    }

    public boolean delete(String name) {
        try {
            PRRank rank = this.get(name);
            PRCache.removeRank(rank);
            return true;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public boolean exists(String name) {
        return this.get(name) != null;
    }

    public boolean rename(String oldname, String newname) {
        if (!this.exists(oldname) || this.exists(newname)) {
            return false;
        }
        PRRank rank = this.get(oldname);
        rank.setName(newname);
        return true;
    }

    public boolean setPrefix(String name, String prefix) {
        return this.setPrefix(this.get(name), prefix);
    }

    public boolean setPrefix(PRRank rank, String prefix) {
        if (rank == null) {
            return false;
        }
        rank.setPrefix(prefix);
        return true;
    }

    public String getPrefix(String name) {
        return this.getPrefix(this.get(name));
    }

    public String getPrefix(PRRank rank) {
        if (rank == null) {
            return null;
        }
        return rank.getPrefix();
    }

    public boolean setSuffix(String name, String suffix) {
        return this.setSuffix(this.get(name), suffix);
    }

    public boolean setSuffix(PRRank rank, String suffix) {
        if (rank == null) {
            return false;
        }
        rank.setSuffix(suffix);
        return true;
    }

    public String getSuffix(String name) {
        return this.getSuffix(this.get(name));
    }

    public String getSuffix(PRRank rank) {
        if (rank == null) {
            return null;
        }
        return rank.getSuffix();
    }

    public boolean setWeight(String name, int weight) {
        return this.setWeight(this.get(name), weight);
    }

    public boolean setWeight(PRRank rank, int weight) {
        if (rank == null) {
            return false;
        }
        rank.setWeight(weight);
        return true;
    }

    public int getWeight(String name) {
        return this.getWeight(this.get(name));
    }

    public int getWeight(PRRank rank) {
        if (rank == null) {
            return -1;
        }
        return rank.getWeight();
    }

    public boolean setDefault(String name, boolean isDefault) {
        return this.setDefault(this.get(name), isDefault);
    }

    public boolean setDefault(PRRank rank, boolean isDefault) {
        if (rank == null) {
            return false;
        }
        rank.setDefault(isDefault);
        return true;
    }

    public boolean isDefault(String name) {
        return this.isDefault(this.get(name));
    }

    public boolean isDefault(PRRank rank) {
        if (rank == null) {
            return false;
        }
        return rank.isDefault();
    }

    public boolean setNameColor(String name, String nameColor) {
        return this.setNameColor(this.get(name), nameColor);
    }

    public boolean setNameColor(PRRank rank, String nameColor) {
        if (rank == null) {
            return false;
        }
        rank.setNamecolor(nameColor);
        return true;
    }

    public String getNameColor(String name) {
        return this.getNameColor(this.get(name));
    }

    public String getNameColor(PRRank rank) {
        if (rank == null) {
            return null;
        }
        return rank.getNamecolor();
    }

    public boolean setChatColor(String name, String chatColor) {
        return this.setChatColor(this.get(name), chatColor);
    }

    public boolean setChatColor(PRRank rank, String chatColor) {
        if (rank == null) {
            return false;
        }
        rank.setChatcolor(chatColor);
        return true;
    }

    public String getChatColor(String name) {
        return this.getChatColor(this.get(name));
    }

    public String getChatColor(PRRank rank) {
        if (rank == null) {
            return null;
        }
        return rank.getChatcolor();
    }

    public boolean addInheritance(String name, String inherit) {
        return this.addInheritance(this.get(name), this.get(inherit));
    }

    public boolean addInheritance(PRRank rank, String inherit) {
        return this.addInheritance(rank, this.get(inherit));
    }

    public boolean addInheritance(String name, PRRank inheritRank) {
        return this.addInheritance(this.get(name), inheritRank);
    }

    public boolean addInheritance(PRRank rank, PRRank inheritRank) {
        if (rank == null || inheritRank == null) {
            return false;
        }
        for (String inheritance : rank.getInheritances()) {
            if (!inheritance.equalsIgnoreCase(inheritRank.getName())) continue;
            return false;
        }
        rank.getInheritances().add(inheritRank.getName());
        return true;
    }

    public boolean removeInheritance(String name, String inherit) {
        return this.removeInheritance(this.get(name), this.get(inherit));
    }

    public boolean removeInheritance(PRRank rank, String inherit) {
        return this.removeInheritance(rank, this.get(inherit));
    }

    public boolean removeInheritance(String name, PRRank inheritRank) {
        return this.removeInheritance(this.get(name), inheritRank);
    }

    public boolean removeInheritance(PRRank rank, PRRank inheritRank) {
        if (rank == null) {
            return false;
        }
        boolean found = false;
        for (String inheritance : rank.getInheritances()) {
            if (!inheritance.equalsIgnoreCase(inheritRank.getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        rank.getInheritances().remove(inheritRank.getName());
        return true;
    }

    public List<PRRank> getInheritances(String name) {
        return this.getInheritances(this.get(name));
    }

    public List<PRRank> getInheritances(PRRank rank) {
        if (rank == null) {
            return null;
        }
        ArrayList<PRRank> inheritances = new ArrayList<PRRank>();
        for (String inherit : rank.getInheritances()) {
            PRRank prRank = this.get(inherit);
            if (prRank == null) continue;
            inheritances.add(prRank);
        }
        return inheritances;
    }

    public boolean addPermission(String name, String permissionNode, boolean allowed) {
        return this.addPermission(this.get(name), new PRPermission(permissionNode, allowed));
    }

    public boolean addPermission(PRRank rank, String permissionNode, boolean allowed) {
        return this.addPermission(rank, new PRPermission(permissionNode, allowed));
    }

    public boolean addPermission(String name, PRPermission permission) {
        return this.addPermission(this.get(name), permission);
    }

    public boolean addPermission(PRRank rank, PRPermission permission) {
        if (rank == null) {
            return false;
        }
        for (PRPermission prPermission : rank.getPermissions()) {
            if (!prPermission.getName().equals(permission.getName())) continue;
            return false;
        }
        rank.getPermissions().add(permission);
        return true;
    }

    public boolean removePermission(String name, String permission) {
        return this.removePermission(this.get(name), permission);
    }

    public boolean removePermission(PRRank rank, String permission) {
        if (rank == null) {
            return false;
        }
        PRPermission foundPermission = null;
        for (PRPermission prPermission : rank.getPermissions()) {
            if (!prPermission.getName().equals(permission)) continue;
            foundPermission = prPermission;
            break;
        }
        if (foundPermission == null) {
            return false;
        }
        rank.getPermissions().remove(foundPermission);
        return true;
    }

    public List<PRPermission> getPermissions(String name) {
        return this.getPermissions(this.get(name));
    }

    public List<PRPermission> getPermissions(PRRank rank) {
        if (rank == null) {
            return null;
        }
        return rank.getPermissions();
    }

    public boolean addBuyableRank(String name, String buyableRankName) {
        return this.addBuyableRank(this.get(name), this.get(buyableRankName));
    }

    public boolean addBuyableRank(PRRank rank, String buyableRankName) {
        return this.addBuyableRank(rank, this.get(buyableRankName));
    }

    public boolean addBuyableRank(String name, PRRank buyableRank) {
        return this.addBuyableRank(this.get(name), buyableRank);
    }

    public boolean addBuyableRank(PRRank rank, PRRank buyableRank) {
        if (rank == null) {
            return false;
        }
        for (String prBuyableRank : rank.getBuyableRanks()) {
            if (!prBuyableRank.equalsIgnoreCase(buyableRank.getName())) continue;
            return false;
        }
        rank.getBuyableRanks().add(buyableRank.getName());
        return true;
    }

    public boolean removeBuyableRank(String name, String buyableRankName) {
        return this.removeBuyableRank(this.get(name), this.get(buyableRankName));
    }

    public boolean removeBuyableRank(PRRank rank, String buyableRankName) {
        return this.removeBuyableRank(rank, this.get(buyableRankName));
    }

    public boolean removeBuyableRank(String name, PRRank buyableRank) {
        return this.removeBuyableRank(this.get(name), buyableRank);
    }

    public boolean removeBuyableRank(PRRank rank, PRRank buyableRank) {
        if (rank == null) {
            return false;
        }
        boolean found = false;
        for (String prBuyableRank : rank.getBuyableRanks()) {
            if (!prBuyableRank.equalsIgnoreCase(buyableRank.getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        rank.getBuyableRanks().remove(buyableRank.getName());
        return true;
    }

    public List<PRRank> getBuyableRanks(String name) {
        return this.getBuyableRanks(this.get(name));
    }

    public List<PRRank> getBuyableRanks(PRRank rank) {
        if (rank == null) {
            return null;
        }
        ArrayList<PRRank> buyableRanks = new ArrayList<PRRank>();
        for (String buyableRank : rank.getBuyableRanks()) {
            PRRank prRank = this.get(buyableRank);
            if (prRank == null) continue;
            buyableRanks.add(prRank);
        }
        return buyableRanks;
    }

    public boolean setBuyCost(String name, float cost) {
        return this.setBuyCost(this.get(name), cost);
    }

    public boolean setBuyCost(PRRank rank, float cost) {
        if (rank == null) {
            return false;
        }
        rank.setBuyCost(cost);
        return true;
    }

    public float getBuyCost(String name) {
        return this.getBuyCost(this.get(name));
    }

    public float getBuyCost(PRRank rank) {
        if (rank == null) {
            return -1.0f;
        }
        return rank.getBuyCost();
    }

    public boolean setBuyDescription(String name, String description) {
        return this.setBuyDescription(this.get(name), description);
    }

    public boolean setBuyDescription(PRRank rank, String description) {
        if (rank == null) {
            return false;
        }
        rank.setBuyDescription(description);
        return true;
    }

    public String getBuyDescription(String name) {
        return this.getBuyDescription(this.get(name));
    }

    public String getBuyDescription(PRRank rank) {
        if (rank == null) {
            return null;
        }
        return rank.getBuyDescription();
    }

    public boolean setBuyCommand(String name, String command) {
        return this.setBuyCommand(this.get(name), command);
    }

    public boolean setBuyCommand(PRRank rank, String command) {
        if (rank == null) {
            return false;
        }
        rank.setBuyCommand(command);
        return true;
    }

    public String getBuyCommand(String name) {
        return this.getBuyCommand(this.get(name));
    }

    public String getBuyCommand(PRRank rank) {
        if (rank == null) {
            return null;
        }
        return rank.getBuyCommand();
    }
}

